/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.im;

import danyfel80.wells.data.ITimepoint;
import danyfel80.wells.data.im.ImChannel;
import java.awt.Point;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.w3c.dom.Element;

public class ImTimepoint
implements ITimepoint {
    private long id;
    private Map<Long, ImChannel> channels;

    @Override
    public long getId() {
        return this.id;
    }

    public Map<Long, ImChannel> getChannels() {
        return this.channels;
    }

    public static class Builder {
        public static ImTimepoint createSingleTimepoint(Element gridElement, Path imagePath, Point positionInWell) throws IOException {
            ImTimepoint timepoint = new ImTimepoint();
            timepoint.id = 0L;
            if (!Files.exists(imagePath, new LinkOption[0])) {
                throw new IOException("image file does not exist: " + imagePath);
            }
            ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
            try {
                reader.setInput(new FileImageInputStream(imagePath.toFile()));
                timepoint.channels = new HashMap();
                int numChannels = reader.getNumImages(true);
                int c = 0;
                while (c < numChannels) {
                    ImChannel channel = ImChannel.Builder.createChannel(gridElement, imagePath, positionInWell, reader, c);
                    timepoint.channels.put(Long.valueOf(c), channel);
                    ++c;
                }
            }
            finally {
                reader.dispose();
            }
            return timepoint;
        }
    }
}

