/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import danyfel80.wells.data.IChannel;
import danyfel80.wells.data.opera.OperaImage;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperaChannel
implements IChannel {
    private long id;
    private String name;
    private String type;
    private OperaImage image;

    private OperaChannel() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Color getColor() {
        return this.image.getChannelColor();
    }

    @Override
    public double getExcitationWavelength() {
        return this.image.getExcitationWavelength();
    }

    @Override
    public double getEmissionWavelength() {
        return this.image.getEmissionWavelength();
    }

    @Override
    public OperaImage getImage() {
        return this.image;
    }

    /* synthetic */ OperaChannel(OperaChannel operaChannel) {
        this();
    }

    public static class Builder {
        public static Map<Long, OperaChannel> channelsFromImages(List<OperaImage> planeImages) {
            return planeImages.stream().collect(Collectors.toMap(OperaImage::getBufferNumber, im -> Builder.fromImage(im)));
        }

        public static OperaChannel fromImage(OperaImage channelImage) {
            OperaChannel channel = new OperaChannel(null);
            channel.id = channelImage.getBufferNumber();
            channel.name = channelImage.getChannelName();
            channel.type = channelImage.getChannelType();
            channel.image = channelImage;
            return channel;
        }

        public static void integrateChannelToChannels(OperaChannel channelToIntegrate, Map<Long, OperaChannel> integratedChannels) {
            OperaChannel integratedChannel = integratedChannels.get(channelToIntegrate.getId());
            if (integratedChannel == null) {
                integratedChannel = new OperaChannel(null);
                integratedChannel.id = channelToIntegrate.id;
                integratedChannel.name = channelToIntegrate.name;
                integratedChannel.type = channelToIntegrate.type;
                integratedChannel.image = channelToIntegrate.image;
                integratedChannels.put(channelToIntegrate.id, integratedChannel);
            }
        }
    }
}

