/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.opera.OperaFilterCombination;
import danyfel80.wells.data.opera.OperaImage;
import danyfel80.wells.data.opera.OperaPlane;
import danyfel80.wells.util.CollectionUtils;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperaField
implements IField {
    private long id;
    private Point2D position;
    private Map<Long, OperaPlane> planes;
    private Rectangle2D bounds;
    private Rectangle2D pixelBounds;

    private OperaField() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public Map<Long, OperaPlane> getPlanes() {
        return this.planes;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getPixelBounds() {
        return this.pixelBounds;
    }

    /* synthetic */ OperaField(OperaField operaField) {
        this();
    }

    public static class Builder {
        public static Map<Long, OperaField> fieldsFromXml(Element imagesElement, String fileUrl, Map<String, OperaFilterCombination> filterCombinations) {
            Map<Long, List<OperaImage>> imagesByField = XMLUtil.getElements((Node)imagesElement, (String)"Image").stream().map(imageElement -> OperaImage.Builder.fromXml(imageElement, fileUrl, filterCombinations)).collect(Collectors.groupingBy(OperaImage::getSublayout));
            return imagesByField.entrySet().stream().map(fieldEntry -> CollectionUtils.newEntry((Long)fieldEntry.getKey(), Builder.createField((List)fieldEntry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static OperaField createField(List<OperaImage> fieldImages) {
            OperaField field = new OperaField(null);
            field.id = fieldImages.get(0).getSublayout();
            field.position = fieldImages.stream().findFirst().map(im -> im.getPositionXY()).orElse(new Point2D.Double());
            field.planes = OperaPlane.Builder.fromImages(fieldImages);
            field.bounds = fieldImages.stream().findFirst().map(im -> new Rectangle2D.Double(im.getPositionX(), im.getPositionY(), (double)im.getSizeX() * im.getResolutionX(), (double)im.getSizeY() * im.getResolutionY())).orElse(new Rectangle2D.Double());
            field.pixelBounds = fieldImages.stream().findFirst().map(im -> new Rectangle2D.Double(im.getPositionX() / im.getResolutionX(), im.getPositionY() / im.getResolutionY(), im.getSizeX(), im.getSizeY())).orElse(new Rectangle2D.Double());
            return field;
        }

        public static void integrateFieldToFields(OperaField fieldToIntegrate, Map<Long, OperaField> integratedFields) {
            OperaField integratedField = integratedFields.get(fieldToIntegrate.getId());
            if (integratedField == null) {
                integratedField = new OperaField(null);
                integratedField.id = fieldToIntegrate.id;
                integratedField.position = fieldToIntegrate.position;
                integratedField.planes = new HashMap();
                integratedField.bounds = fieldToIntegrate.bounds;
                integratedFields.put(fieldToIntegrate.id, integratedField);
            }
            Map planes = integratedField.planes;
            fieldToIntegrate.planes.entrySet().forEach(planeEntry -> OperaPlane.Builder.integratePlaneToPlanes((OperaPlane)planeEntry.getValue(), planes));
        }
    }
}

