/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import danyfel80.wells.data.IImage;
import danyfel80.wells.data.opera.OperaFilterCombination;
import icy.type.dimension.Dimension2D;
import icy.util.ColorUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperaImage
implements IImage {
    private int buffer;
    private String fileName;
    private String objectiveId;
    private String filterCombinationId;
    private String lightSourceCombinationId;
    private int exposureId;
    private int cameraExposureTime;
    private Dimension cameraBinning;
    private long plane;
    private long sublayoutId;
    private double focusHeight;
    private double absoluteFocusHeight;
    private double absolutePiezoHeight;
    private double relativeZ;
    private Point2D.Double positionXY;
    private double positionZ;
    private double measurementTimeOffset;
    private Date time;
    private String cameraReference;
    private String type;
    private String channelName;
    private String acquisitionType;
    private String channelType;
    private String illuminationType;
    private double imageFactor;
    private int bitsPerPixel;
    private Dimension size;
    private String compressionType;
    private double compressionRate;
    private Dimension2D.Double resolution;
    private double excitation;
    private double emission;
    private Color color;

    private OperaImage() {
    }

    public String getObjectiveId() {
        return this.objectiveId;
    }

    public String getFilterCombinationId() {
        return this.filterCombinationId;
    }

    public String getLightSourceCombinationId() {
        return this.lightSourceCombinationId;
    }

    public int getExposureId() {
        return this.exposureId;
    }

    public int getCameraExposureTime() {
        return this.cameraExposureTime;
    }

    public Dimension getCameraBinning() {
        return this.cameraBinning;
    }

    public long getPlane() {
        return this.plane;
    }

    public long getSublayout() {
        return this.sublayoutId;
    }

    public double getFocusHeight() {
        return this.focusHeight;
    }

    public double getAbsoluteFocusHeight() {
        return this.absoluteFocusHeight;
    }

    public double getAbsolutePiezoHeight() {
        return this.absolutePiezoHeight;
    }

    public double getRelativeZ() {
        return this.relativeZ;
    }

    public Point2D.Double getPositionXY() {
        return this.positionXY;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    public double getMeasurementTimeOffset() {
        return this.measurementTimeOffset;
    }

    public Date getAcquisitionDate() {
        return this.time;
    }

    public String getCameraReference() {
        return this.cameraReference;
    }

    public String getType() {
        return this.type;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public String getIlluminationType() {
        return this.illuminationType;
    }

    public double getImageFactor() {
        return this.imageFactor;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public Dimension getSize() {
        return this.size;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public double getCompressionRate() {
        return this.compressionRate;
    }

    public Dimension2D.Double getResolution() {
        return this.resolution;
    }

    @Override
    public String getVersion() {
        return "1";
    }

    @Override
    public String getId() {
        return String.valueOf(this.buffer);
    }

    @Override
    public String getState() {
        return "Ok";
    }

    @Override
    public long getBufferNumber() {
        return this.buffer;
    }

    @Override
    public String getUrl() {
        return this.fileName;
    }

    @Override
    public long getRow() {
        return -1L;
    }

    @Override
    public long getColumn() {
        return -1L;
    }

    @Override
    public long getFieldId() {
        return this.sublayoutId;
    }

    @Override
    public long getPlaneId() {
        return this.plane;
    }

    @Override
    public long getTimepointId() {
        return 0L;
    }

    @Override
    public long getChannelId() {
        return this.buffer;
    }

    @Override
    public Color getChannelColor() {
        return this.color;
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public String getAcquisitionType() {
        return this.acquisitionType;
    }

    @Override
    public double getResolutionX() {
        return this.resolution.sizeX;
    }

    @Override
    public double getResolutionY() {
        return this.resolution.sizeY;
    }

    @Override
    public long getSizeX() {
        return this.size.width;
    }

    @Override
    public long getSizeY() {
        return this.size.height;
    }

    @Override
    public double getPositionX() {
        return this.positionXY.x;
    }

    @Override
    public double getPositionY() {
        return this.positionXY.y;
    }

    @Override
    public double getAbsPositionZ() {
        return this.positionZ;
    }

    @Override
    public double getTime() {
        return this.measurementTimeOffset;
    }

    @Override
    public Date getDate() {
        return this.time;
    }

    @Override
    public double getExcitationWavelength() {
        return this.excitation;
    }

    @Override
    public double getEmissionWavelength() {
        return this.emission;
    }

    /* synthetic */ OperaImage(OperaImage operaImage) {
        this();
    }

    public static class Builder {
        public static OperaImage fromXml(Element imageElement, String fileUrl, Map<String, OperaFilterCombination> filterCombinations) {
            OperaImage image = new OperaImage(null);
            image.buffer = XMLUtil.getAttributeIntValue((Element)imageElement, (String)"BufferNo", (int)0);
            image.fileName = fileUrl;
            image.objectiveId = XMLUtil.getElementValue((Node)imageElement, (String)"ObjectiveRef", null);
            image.filterCombinationId = XMLUtil.getElementValue((Node)imageElement, (String)"FilterCombinationRef", null);
            image.lightSourceCombinationId = XMLUtil.getElementValue((Node)imageElement, (String)"LightSourceCombinationRef", null);
            image.exposureId = XMLUtil.getElementIntValue((Node)imageElement, (String)"ExposureNo", (int)0);
            image.cameraExposureTime = XMLUtil.getElementIntValue((Node)imageElement, (String)"ExposureNo", (int)0);
            image.cameraBinning = new Dimension();
            ((OperaImage)image).cameraBinning.width = XMLUtil.getElementIntValue((Node)imageElement, (String)"CameraBinningX", (int)1);
            ((OperaImage)image).cameraBinning.height = XMLUtil.getElementIntValue((Node)imageElement, (String)"CameraBinningY", (int)1);
            image.plane = XMLUtil.getElementLongValue((Node)imageElement, (String)"Stack", (long)0L);
            image.sublayoutId = XMLUtil.getElementLongValue((Node)imageElement, (String)"Sublayout", (long)0L);
            image.focusHeight = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"FocusHeight", (double)0.0) * 1000000.0;
            image.absoluteFocusHeight = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"AbsoluteFocusHeight", (double)0.0) * 1000000.0;
            image.absolutePiezoHeight = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"AbsolutePiezoHeight", (double)0.0) * 1000000.0;
            image.relativeZ = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"RelativeZ", (double)0.0) * 1000000.0;
            image.positionXY = new Point2D.Double();
            ((OperaImage)image).positionXY.x = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"PositionX", (double)0.0) * 1000000.0;
            ((OperaImage)image).positionXY.y = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"PositionY", (double)0.0) * 1000000.0;
            image.positionZ = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"PositionZ", (double)0.0) * 1000000.0;
            image.measurementTimeOffset = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"MeasurementTimeOffset", (double)0.0);
            String timeText = XMLUtil.getElementValue((Node)imageElement, (String)"DateTime", null);
            try {
                image.time = timeText == null ? null : DatatypeConverter.parseDateTime((String)timeText).getTime();
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Cannot format start time " + timeText == null ? "" : timeText.replaceAll("Z$", "+0000"), e);
            }
            image.cameraReference = XMLUtil.getElementValue((Node)imageElement, (String)"CameraRef", null);
            image.type = XMLUtil.getElementValue((Node)imageElement, (String)"ImageType", null);
            image.channelName = XMLUtil.getElementValue((Node)imageElement, (String)"ChannelName", (String)"");
            image.acquisitionType = XMLUtil.getElementValue((Node)imageElement, (String)"AcquisitionType", null);
            image.channelType = XMLUtil.getElementValue((Node)imageElement, (String)"ChannelType", (String)"");
            image.illuminationType = XMLUtil.getElementValue((Node)imageElement, (String)"IlluminationType", (String)"");
            image.imageFactor = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"ImageFactor", (double)1.0);
            image.bitsPerPixel = XMLUtil.getElementIntValue((Node)imageElement, (String)"ImageBitPerPixel", (int)16);
            image.size = new Dimension();
            ((OperaImage)image).size.width = XMLUtil.getElementIntValue((Node)imageElement, (String)"ImageWidth", (int)0);
            ((OperaImage)image).size.height = XMLUtil.getElementIntValue((Node)imageElement, (String)"ImageHeight", (int)0);
            image.compressionType = XMLUtil.getElementValue((Node)imageElement, (String)"CompressionType", (String)"");
            image.compressionRate = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"CompressionRate", (double)0.0);
            image.resolution = new Dimension2D.Double();
            ((OperaImage)image).resolution.sizeX = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"ImageResolutionX", (double)0.0) * 1000000.0;
            ((OperaImage)image).resolution.sizeY = XMLUtil.getElementDoubleValue((Node)imageElement, (String)"ImageResolutionY", (double)0.0) * 1000000.0;
            OperaFilterCombination combi = filterCombinations.get(image.filterCombinationId);
            String cameraNumber = image.cameraReference.split("Cam")[1];
            String filter = combi.getSliderReferences().get("Camera" + cameraNumber);
            String[] filterValues = filter.split("/");
            image.excitation = Integer.parseInt(filterValues[0]) - Integer.parseInt(filterValues[1]);
            image.emission = image.excitation + 40.0;
            image.color = ColorUtil.getColorFromWavelength((double)image.emission);
            return image;
        }
    }
}

