/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import danyfel80.wells.data.IPlane;
import danyfel80.wells.data.opera.OperaChannel;
import danyfel80.wells.data.opera.OperaImage;
import danyfel80.wells.data.opera.OperaTimepoint;
import danyfel80.wells.util.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OperaPlane
implements IPlane {
    private long id;
    private double positionZ;
    private Map<Long, OperaTimepoint> timepoints;

    private OperaPlane() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    public Map<Long, OperaTimepoint> getTimepoints() {
        return this.timepoints;
    }

    /* synthetic */ OperaPlane(OperaPlane operaPlane) {
        this();
    }

    public static class Builder {
        private static OperaPlane planeFromImages(List<OperaImage> planeImages) {
            OperaPlane plane = new OperaPlane(null);
            plane.id = planeImages.get(0).getPlane();
            plane.positionZ = planeImages.get(0).getRelativeZ();
            Map<Long, OperaChannel> channels = OperaChannel.Builder.channelsFromImages(planeImages);
            plane.timepoints = new HashMap();
            plane.timepoints.put(0L, OperaTimepoint.wrapChannels(channels));
            return plane;
        }

        public static Map<Long, OperaPlane> fromImages(List<OperaImage> fieldImages) {
            Map<Long, List<OperaImage>> imagesByPlane = fieldImages.stream().collect(Collectors.groupingBy(OperaImage::getPlane));
            Map<Long, OperaPlane> planes = imagesByPlane.entrySet().stream().map(plEntry -> CollectionUtils.newEntry((Long)plEntry.getKey(), Builder.planeFromImages((List)plEntry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return planes;
        }

        public static void integratePlaneToPlanes(OperaPlane planeToIntegrate, Map<Long, OperaPlane> integratedPlanes) {
            OperaPlane integratedPlane = integratedPlanes.get(planeToIntegrate.getId());
            if (integratedPlane == null) {
                integratedPlane = new OperaPlane(null);
                integratedPlane.id = planeToIntegrate.id;
                integratedPlane.positionZ = planeToIntegrate.positionZ;
                integratedPlane.timepoints = new HashMap();
                integratedPlanes.put(planeToIntegrate.id, integratedPlane);
            }
            Map integratedTimepoints = integratedPlane.timepoints;
            planeToIntegrate.timepoints.entrySet().forEach(timeEntry -> OperaTimepoint.integrateTimepointToTimepoints((OperaTimepoint)timeEntry.getValue(), integratedTimepoints));
        }
    }
}

