/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.opera.OperaField;
import danyfel80.wells.data.opera.OperaFilterCombination;
import danyfel80.wells.data.opera.OperaSingleWellShape;
import danyfel80.wells.data.opera.OperaWellShape;
import icy.type.dimension.Dimension2D;
import icy.util.XMLUtil;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OperaWell
implements IWell {
    private long wellId;
    private String name;
    private Point coordinate;
    private String sublayoutId;
    private String stackId;
    private Map<Long, OperaField> fields;
    private OperaSingleWellShape shape;

    public static OperaWell joinWellsByField(List<OperaWell> wellsToIntegrate, OperaWellShape plateWellShape) {
        OperaWell integratedWell = new OperaWell();
        OperaWell firstWell = wellsToIntegrate.get(0);
        integratedWell.name = firstWell.name;
        integratedWell.coordinate = firstWell.coordinate;
        integratedWell.sublayoutId = firstWell.sublayoutId;
        integratedWell.stackId = firstWell.stackId;
        integratedWell.fields = new HashMap<Long, OperaField>();
        integratedWell.wellId = firstWell.wellId;
        wellsToIntegrate.stream().forEach(wellToIntegrate -> OperaWell.integrateWellFields(wellToIntegrate.fields, operaWell.fields));
        Rectangle2D wellRectangle = integratedWell.fields.values().stream().map(f -> f.getBounds()).reduce(new Rectangle2D.Double(), (acc, elem) -> {
            if (acc.isEmpty()) {
                acc.setRect((Rectangle2D)elem);
            } else if (!elem.isEmpty()) {
                acc.add((Rectangle2D)elem);
            }
            return acc;
        });
        if (plateWellShape.getSize().getWidth() > 0.0 && plateWellShape.getSize().getHeight() > 0.0) {
            Dimension2D.Double plateWellSize = plateWellShape.getSize();
            wellRectangle.setRect(-plateWellSize.sizeX / 2.0, -plateWellSize.sizeY / 2.0, plateWellSize.sizeX, plateWellSize.sizeY);
        }
        integratedWell.shape = plateWellShape.getShape().equals("Circle") ? new OperaSingleWellShape(new Ellipse2D.Double(wellRectangle.getX(), wellRectangle.getY(), wellRectangle.getWidth(), wellRectangle.getHeight())) : new OperaSingleWellShape(wellRectangle);
        return integratedWell;
    }

    private static void integrateWellFields(Map<Long, OperaField> wellFields, Map<Long, OperaField> integratedFields) {
        wellFields.entrySet().stream().forEach(fieldEntry -> OperaField.Builder.integrateFieldToFields((OperaField)fieldEntry.getValue(), integratedFields));
    }

    private OperaWell() {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.wellId;
    }

    @Override
    public Point getPositionInPlate() {
        return this.coordinate;
    }

    public String getSublayoutId() {
        return this.sublayoutId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public Map<Long, OperaField> getFields() {
        return this.fields;
    }

    @Override
    public OperaSingleWellShape getShape() {
        return this.shape;
    }

    @Override
    public Rectangle2D getFieldBoundsOnWell(IField field) {
        Rectangle2D fieldBounds = field.getBounds();
        Rectangle2D wellBounds = this.getShape().getShape().getBounds2D();
        wellBounds.setRect(wellBounds.getCenterX() + (fieldBounds.getX() - 0.5 * fieldBounds.getWidth()), wellBounds.getCenterY() + fieldBounds.getY() - 0.5 * fieldBounds.getHeight(), fieldBounds.getWidth(), fieldBounds.getHeight());
        return wellBounds;
    }

    /* synthetic */ OperaWell(OperaWell operaWell) {
        this();
    }

    public static class Builder {
        public static OperaWell fromXml(Element wellElement, String fileUrl, Map<String, OperaFilterCombination> filterCombinations) {
            OperaWell well = new OperaWell(null);
            well.name = XMLUtil.getElementValue((Node)wellElement, (String)"AreaName", (String)"Unknown");
            well.coordinate = new Point();
            Element coordinateElement = XMLUtil.getElement((Node)wellElement, (String)"WellCoordinate");
            ((OperaWell)well).coordinate.x = XMLUtil.getAttributeIntValue((Element)coordinateElement, (String)"Col", (int)0);
            ((OperaWell)well).coordinate.y = XMLUtil.getAttributeIntValue((Element)coordinateElement, (String)"Row", (int)0);
            well.sublayoutId = XMLUtil.getElementValue((Node)wellElement, (String)"SublayoutRef", null);
            well.stackId = XMLUtil.getElementValue((Node)wellElement, (String)"StackRef", null);
            well.fields = OperaField.Builder.fieldsFromXml(XMLUtil.getElement((Node)wellElement, (String)"Images"), fileUrl, filterCombinations);
            well.wellId = ((OperaWell)well).coordinate.y * 1000 + ((OperaWell)well).coordinate.x;
            return well;
        }
    }
}

