/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.ui;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import danyfel80.wells.ui.WellViewer;
import icy.gui.frame.IcyFrame;
import icy.gui.viewer.Viewer;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.adufour.hcs.io.AbstractWellPlateReader;

public class WellPlateViewer
extends IcyFrame {
    public WellPlateViewer(final IPlate wellPlate, final AbstractWellPlateReader plateReader) {
        super(wellPlate.toString(), false, true, false, true, true);
        this.setLayout(new BorderLayout());
        Dimension plateDimension = wellPlate.getDimension();
        final JPanel plateView = new JPanel(new GridLayout(plateDimension.height + 1, plateDimension.width + 1, 2, 2));
        plateView.setPreferredSize(new Dimension(250, 425));
        this.add(plateView, "Center");
        JPanel singleWellPanel = new JPanel(new FlowLayout(1));
        singleWellPanel.setPreferredSize(new Dimension(300, 425));
        final JLabel selectedWellLabel = new JLabel("No well selected");
        final JLabel selectedFieldLabel = new JLabel("");
        final JSlider fieldSlider = new JSlider(0);
        fieldSlider.setVisible(false);
        fieldSlider.setBorder(new EmptyBorder(5, 10, 5, 15));
        final Sequence viewerSequence = new Sequence();
        final WellViewer selectedWellViewer = new WellViewer(null, true){
            private static final long serialVersionUID = -7385257944014813154L;

            @Override
            protected void fieldChanged(IWell well, IField field) {
                try {
                    Future<? extends Sequence> sequenceFuture = plateReader.loadField(wellPlate, well, field, viewerSequence, null);
                    Sequence sequence = sequenceFuture.get();
                    sequence.setName("Well" + (char)(65 + well.getPositionInPlate().x - 1) + StringUtil.toString((int)well.getPositionInPlate().y, (int)2) + "_Field" + field.getId());
                    selectedFieldLabel.setText("Field " + field.getId());
                    fieldSlider.setValue((int)field.getId());
                    if (sequence.getFirstViewer() == null) {
                        new Viewer(sequence);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IcyHandledException("Cannot load well " + well.getId(), (Throwable)e);
                }
            }
        };
        selectedWellViewer.setPreferredSize(new Dimension(220, 220));
        fieldSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IWell well = selectedWellViewer.getWell();
                if (well == null || well.getFields().isEmpty()) {
                    return;
                }
                int sliderValue = fieldSlider.getValue();
                if (sliderValue != selectedWellViewer.getSelectedFieldId()) {
                    selectedWellViewer.setSelectedField(well.getFields().get(sliderValue));
                }
            }
        });
        singleWellPanel.add(selectedWellLabel);
        singleWellPanel.add(selectedWellViewer);
        singleWellPanel.add(selectedFieldLabel);
        singleWellPanel.add(fieldSlider);
        this.add(singleWellPanel, "East");
        int nbRows = plateDimension.height + 1;
        int nbCols = plateDimension.width + 1;
        Map<Point, IWell> wellGrid = this.createWellGrid(wellPlate);
        int col = 0;
        while (col < nbCols) {
            JLabel header = new JLabel(col == 0 ? "" : "" + (char)(65 + (col - 1)), 0);
            header.setFont(header.getFont().deriveFont(header.getFont().getSize2D() - 2.0f));
            plateView.add(header);
            ++col;
        }
        int row = 1;
        while (row < nbRows) {
            int col2 = 0;
            while (col2 < nbCols) {
                if (col2 == 0) {
                    JLabel header = new JLabel(StringUtil.toString((int)row, (int)2), 0);
                    header.setFont(header.getFont().deriveFont(header.getFont().getSize2D() - 2.0f));
                    plateView.add(header);
                } else {
                    final IWell well = wellGrid.get(new Point(col2, row));
                    WellViewer wellViewInPlate = new WellViewer(well, false);
                    if (well != null) {
                        final char colWell = (char)(65 + col2);
                        final int rowWell = row;
                        final ArrayList<Long> fieldIds = new ArrayList<Long>(well.getFields().keySet());
                        wellViewInPlate.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                String wellId = "Well " + colWell + StringUtil.toString((int)rowWell, (int)2);
                                selectedWellLabel.setText(wellId);
                                selectedWellViewer.setWell(well);
                                fieldSlider.setVisible(!well.getFields().isEmpty());
                                if (!well.getFields().isEmpty()) {
                                    fieldSlider.setMinimum(0);
                                    fieldSlider.setMaximum(fieldIds.size());
                                }
                                Component[] componentArray = plateView.getComponents();
                                int n = componentArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Component component = componentArray[n2];
                                    if (component instanceof WellViewer) {
                                        WellViewer wellViewer = (WellViewer)component;
                                        Long id = wellViewer.getWell() == null ? null : Long.valueOf(wellViewer.getWell().getId());
                                        wellViewer.setSelected(id != null && id.longValue() == well.getId());
                                    }
                                    ++n2;
                                }
                                plateView.repaint();
                            }
                        });
                    }
                    plateView.add(wellViewInPlate);
                }
                ++col2;
            }
            ++row;
        }
        this.repaint();
    }

    private Map<Point, IWell> createWellGrid(IPlate wellPlate) {
        return wellPlate.getWells().values().stream().collect(Collectors.toMap(IWell::getPositionInPlate, Function.identity()));
    }
}

