/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.PluginActionable;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import plugins.adufour.hcs.data.OldWellPlate;
import plugins.adufour.hcs.gui.OldWellPlateViewer;
import plugins.adufour.hcs.io.OldWellPlateReader;
import plugins.adufour.hcs.io.OldWellPlateReader_Opera;
import plugins.adufour.hcs.io.WellPlateReader_ColumbusOperaFlex;

@Deprecated
public class OldWellPlateImporter
extends PluginActionable {
    private static final Set<OldWellPlateReader> availableReaders = new HashSet<OldWellPlateReader>();

    private static void loadImporters() {
        availableReaders.clear();
        ArrayList<Class<OldWellPlateReader>> importers = new ArrayList<Class<OldWellPlateReader>>();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins(OldWellPlateReader.class)) {
            importers.add(pluginDescriptor.getPluginClass());
        }
        if (importers.isEmpty()) {
            importers.add(OldWellPlateReader_Opera.class.asSubclass(OldWellPlateReader.class));
            importers.add(WellPlateReader_ColumbusOperaFlex.class.asSubclass(OldWellPlateReader.class));
        }
        for (Class clazz : importers) {
            try {
                availableReaders.add((OldWellPlateReader)((Object)clazz.newInstance()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void run() {
        OldWellPlateImporter.loadImporters();
        String lastUsedDirectory = this.getPreferencesRoot().get("lastUsedDirectory", null);
        JFileChooser jfc = new JFileChooser(lastUsedDirectory);
        String tmpFilterName = "Plate folders (";
        for (OldWellPlateReader reader : availableReaders) {
            tmpFilterName = String.valueOf(tmpFilterName) + reader.getSystemName() + ", ";
        }
        final String filterName = String.valueOf(tmpFilterName.substring(0, tmpFilterName.length() - 2)) + ")";
        jfc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return filterName;
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        jfc.setAcceptAllFileFilterUsed(false);
        jfc.setFileSelectionMode(1);
        int result = jfc.showOpenDialog((Component)Icy.getMainInterface().getMainFrame());
        if (result == 0) {
            new Thread(() -> {
                try {
                    File selection = jfc.getSelectedFile();
                    CancelableProgressFrame loadingProgress = new CancelableProgressFrame("Loading plate " + selection.getName());
                    this.getPreferencesRoot().put("lastUsedDirectory", selection.getPath());
                    OldWellPlateReader importer = OldWellPlateImporter.getReaderFor(selection);
                    OldWellPlate wellPlate = importer.loadPlateFromFolder(selection, Optional.of(loadingProgress));
                    loadingProgress.close();
                    ThreadUtil.invokeLater(() -> {
                        OldWellPlateViewer wellPlateViewer = new OldWellPlateViewer(wellPlate);
                        wellPlateViewer.pack();
                        wellPlateViewer.addToDesktopPane();
                        wellPlateViewer.setVisible(true);
                    });
                }
                catch (IOException ioE) {
                    throw new IcyHandledException("Cannot load folder " + jfc.getSelectedFile().getName() + "\nReason: " + ioE.getMessage());
                }
            }).start();
        }
    }

    public static boolean isValid(File path) {
        OldWellPlateImporter.loadImporters();
        for (OldWellPlateReader reader : availableReaders) {
            if (!reader.isValidPlate(path)) continue;
            return true;
        }
        return false;
    }

    public static OldWellPlateReader getReaderFor(File file) {
        for (OldWellPlateReader reader : availableReaders) {
            if (!reader.isValidPlate(file)) continue;
            return reader;
        }
        return null;
    }
}

