/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs;

import danyfel80.wells.data.IPlate;
import danyfel80.wells.ui.WellPlateViewer;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarFolder;
import plugins.adufour.hcs.io.AbstractWellPlateReader;
import plugins.adufour.hcs.io.WellPlateReader_EvotecPerkinElmerOperaFlex;

public class WellPlateImporter
extends EzPlug
implements EzStoppable {
    private static final Set<AbstractWellPlateReader> availableReaders = new HashSet<AbstractWellPlateReader>();
    private EzVarFolder varInDirectory;

    public static AbstractWellPlateReader getReaderFor(File file) {
        WellPlateImporter.loadAvailableReaders();
        for (AbstractWellPlateReader reader : availableReaders) {
            if (!reader.isValidPlate(file)) continue;
            return reader;
        }
        return null;
    }

    private static void loadAvailableReaders() {
        if (availableReaders.isEmpty()) {
            WellPlateImporter.reloadAvailableReaders();
        }
    }

    public static void reloadAvailableReaders() {
        availableReaders.clear();
        ArrayList<Class<AbstractWellPlateReader>> importers = new ArrayList<Class<AbstractWellPlateReader>>();
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins(AbstractWellPlateReader.class)) {
            importers.add(pluginDescriptor.getPluginClass());
        }
        if (importers.isEmpty()) {
            importers.add(WellPlateReader_EvotecPerkinElmerOperaFlex.class.asSubclass(AbstractWellPlateReader.class));
        }
        for (Class clazz : importers) {
            try {
                availableReaders.add((AbstractWellPlateReader)((Object)clazz.newInstance()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initialize() {
        this.varInDirectory = new EzVarFolder("Well plate folder", null);
        this.addEzComponent((EzComponent)this.varInDirectory);
    }

    protected void execute() {
        File targetDirectory = (File)this.varInDirectory.getValue(true);
        if (!this.isHeadLess()) {
            this.getUI().setProgressBarVisible(true);
        }
        this.notifyProgressUI(0.001, "Loading plate " + targetDirectory.getName());
        this.getPreferencesRoot().put("lastUsedDirectory", targetDirectory.getPath());
        try {
            try {
                AbstractWellPlateReader reader = WellPlateImporter.getReaderFor(targetDirectory);
                Future<? extends IPlate> plateFuture = reader.loadPlateFromFolder(targetDirectory, this::notifyProgressUI);
                IPlate plate = plateFuture.get();
                ThreadUtil.invokeLater(() -> {
                    WellPlateViewer wellPlateViewer = new WellPlateViewer(plate, reader);
                    wellPlateViewer.pack();
                    wellPlateViewer.addToDesktopPane();
                    wellPlateViewer.setVisible(true);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IcyHandledException((Throwable)e);
            }
        }
        finally {
            if (!this.isHeadLess()) {
                this.getUI().setProgressBarVisible(false);
            }
        }
    }

    private void notifyProgressUI(double progress, String message) {
        if (this.isHeadLess()) {
            System.out.println("Loading well plate " + (int)Math.round(progress * 100.0) + "%: " + Objects.toString(message));
        } else {
            if (!Double.isNaN(progress)) {
                this.getUI().setProgressBarValue(progress);
            }
            if (message != null) {
                this.getUI().setProgressBarMessage(message);
            }
        }
    }

    public void clean() {
    }
}

