/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.blocks;

import icy.gui.frame.progress.CancelableProgressFrame;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.hcs.OldWellPlateImporter;
import plugins.adufour.hcs.data.OldField;
import plugins.adufour.hcs.data.OldWellPlate;
import plugins.adufour.hcs.io.OldWellPlateReader;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarListener;

@Deprecated
public class OldWellPlateBatch
extends Batch {
    private VarFile plateFolder;
    private VarSequence element;
    private VarString wellFilter;
    private VarString plateID;
    private VarString wellID;
    private VarInteger fieldID;
    private OldWellPlateReader reader;
    private OldWellPlate currentWellPlate;
    private boolean wellPlateLoaded = false;
    private Iterator<OldField> fieldIterator;

    public Var<?> getBatchSource() {
        if (this.plateFolder == null) {
            this.plateFolder = new VarFile("Plate folder", null, (VarListener)new VarListener<File>(){

                public void valueChanged(Var<File> source, File oldValue, File newValue) {
                    OldWellPlateBatch.this.wellPlateLoaded = false;
                }

                public void referenceChanged(Var<File> source, Var<? extends File> oldReference, Var<? extends File> newReference) {
                    OldWellPlateBatch.this.wellPlateLoaded = false;
                }
            });
            this.plateFolder.setDefaultEditorModel((VarEditorModel)new FileTypeModel(null, FileMode.FOLDERS, null, false));
        }
        return this.plateFolder;
    }

    public VarSequence getBatchElement() {
        if (this.element == null) {
            this.element = new VarSequence("Sequence", null);
        }
        return this.element;
    }

    public void initializeLoop() {
        if (!this.wellPlateLoaded) {
            File folder = (File)this.plateFolder.getValue(true);
            this.reader = OldWellPlateImporter.getReaderFor(folder);
            if (this.reader == null) {
                throw new IcyHandledException("No plate reader found for folder " + folder.getPath());
            }
            Optional<CancelableProgressFrame> progress = SystemUtil.isHeadLess() ? Optional.empty() : Optional.of(new CancelableProgressFrame("Loading well plate..."));
            try {
                try {
                    this.currentWellPlate = this.reader.loadPlateFromFolder(folder, progress);
                    this.plateID.setValue((Object)this.currentWellPlate.getMetaData().getPlateID(0));
                    this.wellPlateLoaded = true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (progress.isPresent()) {
                    progress.get().close();
                }
            }
        }
        this.fieldIterator = this.currentWellPlate.fieldIterator((String)this.wellFilter.getValue());
    }

    public void beforeIteration() {
        try {
            Sequence sequence = new Sequence(this.currentWellPlate.getMetaData());
            OldField currentField = this.fieldIterator.next();
            this.wellID.setValue((Object)currentField.getWell().getAlphanumericID());
            this.fieldID.setValue((Object)currentField.getID());
            this.reader.loadField(currentField, sequence);
            this.element.setValue(sequence);
            Thread.yield();
        }
        catch (Exception e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }

    public boolean isStopConditionReached() {
        return !this.fieldIterator.hasNext();
    }

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.wellFilter = new VarString("Well filter", "");
        inputMap.add("wellFilter", (Var)this.wellFilter);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        this.plateID = new VarString("Plate", "--");
        this.plateID.setEnabled(false);
        outputMap.add("plateID", (Var)this.plateID);
        this.wellID = new VarString("Well", "--");
        this.wellID.setEnabled(false);
        outputMap.add("wellID", (Var)this.wellID);
        this.fieldID = new VarInteger("Field", 0);
        this.fieldID.setEnabled(false);
        outputMap.add("fieldID", (Var)this.fieldID);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        loopVariables.add((Var<?>)this.wellFilter);
        loopVariables.add((Var<?>)this.plateID);
        loopVariables.add((Var<?>)this.wellID);
        loopVariables.add((Var<?>)this.fieldID);
    }
}

