/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.io;

import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.google.common.util.concurrent.AtomicDouble;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codecimpl.TIFFCodec;
import icy.file.FileUtil;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.util.ColorUtil;
import icy.util.OMEUtil;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.PositiveInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import plugins.adufour.hcs.data.OldField;
import plugins.adufour.hcs.data.OldWell;
import plugins.adufour.hcs.data.OldWellPlate;
import plugins.adufour.hcs.io.OldWellPlateReader;

@Deprecated
public class OldWellPlateReader_Opera
extends OldWellPlateReader {
    private static final FileFilter FLEX_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return FileUtil.getFileExtension((String)pathname.getName(), (boolean)false).equalsIgnoreCase("flex");
        }
    };
    private static final FileFilter COLUMBUS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".meax") || pathname.getName().endsWith(".ColumbusIDX.xml");
        }
    };

    @Override
    public String getSystemName() {
        return "Opera (PerkinElmer)";
    }

    @Override
    public boolean isValidPlate(File folder) {
        boolean hasColombusIndexFile;
        boolean containsFlexFiles = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        boolean bl = hasColombusIndexFile = FileUtil.getFiles((String)folder.getPath(), (FileFilter)COLUMBUS_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        return containsFlexFiles && !hasColombusIndexFile;
    }

    @Override
    public OldWellPlate loadPlateFromFolder(File folder, Optional<CancelableProgressFrame> progress) throws IOException {
        String[] files = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false);
        if (files.length == 0) {
            throw new IcyHandledException("Invalid folder: " + folder.getPath());
        }
        AtomicReference<OldWellPlate> wellPlate = new AtomicReference<OldWellPlate>();
        OMEXMLMetadata metadata = OMEUtil.createOMEXMLMetadata();
        metadata.setFolderName(folder.getPath(), 0);
        Map<String, Element> filterCombinations = Collections.synchronizedMap(new HashMap());
        Map<String, Map<Integer, Point2D>> plateLayout = Collections.synchronizedMap(new HashMap());
        AtomicDouble fieldWidth = new AtomicDouble();
        AtomicDouble fieldHeight = new AtomicDouble();
        AtomicDouble pixelSizeX = new AtomicDouble();
        AtomicDouble pixelSizeY = new AtomicDouble();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(numProcessors * 2);
        threadPool.prestartAllCoreThreads();
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(threadPool);
        int processedFiles = 0;
        CancelableProgressFrame progressFrame = progress.orElseGet(null);
        if (progressFrame != null) {
            progressFrame.setLength((double)files.length);
        }
        AtomicBoolean firstRun = new AtomicBoolean(true);
        completionService.submit(new LoadFileTask(this, wellPlate, metadata, filterCombinations, plateLayout, fieldWidth, fieldHeight, pixelSizeX, pixelSizeY, firstRun, files[0]));
        try {
            Future fileTask = completionService.take();
            if (progressFrame != null) {
                if (progressFrame.isCancelRequested()) {
                    throw new IcyHandledException("Loading was cancelled (" + folder.getPath() + ")");
                }
                progressFrame.setPosition((double)(++processedFiles));
                progressFrame.setMessage(String.format("Loading plate %s (file %d/%d)...", folder.getName(), processedFiles, files.length));
            }
            fileTask.get();
            int fileIt = 1;
            while (fileIt < files.length) {
                String filePath = files[fileIt];
                completionService.submit(new LoadFileTask(this, wellPlate, metadata, filterCombinations, plateLayout, fieldWidth, fieldHeight, pixelSizeX, pixelSizeY, firstRun, filePath));
                ++fileIt;
            }
            threadPool.shutdown();
            fileIt = 1;
            while (fileIt < files.length) {
                fileTask = completionService.take();
                if (progressFrame != null) {
                    if (progressFrame.isCancelRequested()) {
                        threadPool.shutdownNow();
                        boolean finished = threadPool.awaitTermination(5L, TimeUnit.SECONDS);
                        if (!finished) {
                            throw new IcyHandledException("Loading was cancelled but hasn't stopped yet(" + folder.getPath() + ")");
                        }
                        throw new IcyHandledException("Loading was cancelled (" + folder.getPath() + ")");
                    }
                    progressFrame.setPosition((double)(++processedFiles));
                    progressFrame.setMessage(String.format("Loading plate %s (file %d/%d)...", folder.getName(), processedFiles, files.length));
                }
                Thread.yield();
                fileTask.get();
                ++fileIt;
            }
        }
        catch (InterruptedException e) {
            threadPool.shutdownNow();
            e.printStackTrace();
            throw new IcyHandledException("Loading was cancelled (" + folder.getPath() + ")");
        }
        catch (ExecutionException e) {
            threadPool.shutdownNow();
            e.printStackTrace();
            throw new IcyHandledException((Throwable)e);
        }
        if (progress.isPresent()) {
            progress.get().setLength((double)files.length);
        }
        return wellPlate.get();
    }

    @Override
    public void loadField(OldField field, Sequence sequence) throws IOException {
        Document flex;
        Metadata mmd;
        sequence.setName("Well " + field.getWell().getAlphanumericID() + ", Field #" + field.getID());
        String path = field.getFilePaths()[0];
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)new FileInputStream(path), (boolean)true);
        ImageDecoder dec = TIFFCodec.createImageDecoder((String)"tiff", (SeekableStream)ss, (ImageDecodeParam)new TIFFDecodeParam());
        try {
            mmd = TiffMetadataReader.readMetadata((File)new File(path));
        }
        catch (TiffProcessingException e) {
            throw new IOException(e);
        }
        Directory dir = (Directory)mmd.getDirectories().iterator().next();
        try {
            flex = XMLUtil.createDocument((String)((Tag)dir.getTags().iterator().next()).getDescription());
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        Element _root = XMLUtil.getElement((Node)flex, (String)"Root");
        Element _flex = XMLUtil.getElement((Node)_root, (String)"FLEX");
        TreeMap<String, Element> stackRefs = new TreeMap<String, Element>();
        Element _stacks = XMLUtil.getElement((Node)_flex, (String)"Stacks");
        for (Element _stack : XMLUtil.getElements((Node)_stacks, (String)"Stack")) {
            stackRefs.put(XMLUtil.getAttributeValue((Element)_stack, (String)"ID", (String)""), _stack);
        }
        Element _well = XMLUtil.getElement((Node)_flex, (String)"Well");
        Element _images = XMLUtil.getElement((Node)_well, (String)"Images");
        Element _stack = (Element)stackRefs.get(XMLUtil.getElementValue((Node)_well, (String)"StackRef", null));
        int sizeZ = _stack.getChildNodes().getLength();
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        sequence.beginUpdate();
        int z = 1;
        while (z <= sizeZ) {
            ArrayList<IcyBufferedImage> channels = new ArrayList<IcyBufferedImage>();
            for (Element _image : XMLUtil.getElements((Node)_images, (String)"Image")) {
                int currentZ = XMLUtil.getElementIntValue((Node)_image, (String)"Stack", (int)0);
                if (z != currentZ) continue;
                int tiffPage = XMLUtil.getAttributeIntValue((Element)_image, (String)"BufferNo", (int)0);
                RenderedImage _plane = dec.decodeAsRenderedImage(tiffPage);
                channels.add(IcyBufferedImage.createFrom((PlanarImage)new RenderedImageAdapter(_plane)));
            }
            IcyBufferedImage plane = IcyBufferedImage.createFrom(channels);
            sequence.setImage(0, z - 1, (BufferedImage)plane);
            ++z;
        }
        sequence.setPositionX(field.getBounds().getX());
        sequence.setPositionY(field.getBounds().getY());
        try {
            int c = 0;
            while (c < sequence.getSizeC()) {
                int emmission = metadata.getChannelEmissionWavelength(0, c).value().intValue();
                java.awt.Color color = OMEUtil.getJavaColor((Color)metadata.getChannelColor(0, c));
                LinearColorMap colorMap = new LinearColorMap(String.valueOf(emmission) + "nm", color);
                sequence.setColormap(c, (IcyColorMap)colorMap, true);
                ++c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sequence.endUpdate();
    }

    private class LoadFileTask
    implements Callable<Void> {
        OldWellPlateReader_Opera readerReference;
        AtomicReference<OldWellPlate> wellPlate;
        OMEXMLMetadata metadata;
        Map<String, Element> filterCombinations;
        Map<String, Map<Integer, Point2D>> plateLayout;
        AtomicDouble fieldWidth;
        AtomicDouble fieldHeight;
        AtomicDouble pixelSizeX;
        AtomicDouble pixelSizeY;
        AtomicBoolean firstRun;
        String filePath;

        public LoadFileTask(OldWellPlateReader_Opera reader, AtomicReference<OldWellPlate> wellPlateReference, OMEXMLMetadata metadata, Map<String, Element> filterCombinations, Map<String, Map<Integer, Point2D>> plateLayout, AtomicDouble fieldWidth, AtomicDouble fieldHeight, AtomicDouble pixelSizeX, AtomicDouble pixelSizeY, AtomicBoolean firstRun, String filePath) {
            this.wellPlate = wellPlateReference;
            this.readerReference = reader;
            this.metadata = metadata;
            this.filterCombinations = filterCombinations;
            this.plateLayout = plateLayout;
            this.fieldWidth = fieldWidth;
            this.fieldHeight = fieldHeight;
            this.pixelSizeX = pixelSizeX;
            this.pixelSizeY = pixelSizeY;
            this.firstRun = firstRun;
            this.filePath = filePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Object sublayoutsElement;
            Metadata flexMetadata = TiffMetadataReader.readMetadata((File)new File(this.filePath));
            Thread.yield();
            Directory flexDirectory = flexMetadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            String flexDescriptionXml = flexDirectory.getDescription(65200);
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileOutputStream outputStream = new FileOutputStream(new File(String.valueOf(this.filePath) + "_toXML.xml"));){
                outputStream.write(flexDescriptionXml.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Document flexDocument = XMLUtil.createDocument((String)flexDescriptionXml);
            Element rootElement = XMLUtil.getElement((Node)flexDocument, (String)"Root");
            Element flexElement = XMLUtil.getElement((Node)rootElement, (String)"FLEX");
            if (this.firstRun.get()) {
                Object camID;
                Object sliderRefElement2;
                String device = flexElement.getAttribute("OperaDevice");
                OMEXMLMetadata oMEXMLMetadata = this.metadata;
                synchronized (oMEXMLMetadata) {
                    this.metadata.setInstrumentID(device, 0);
                }
                Optional<Element> filterCombinationsElement = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"FilterCombinations"));
                if (filterCombinationsElement.isPresent()) {
                    for (Element filterCombinationElement : XMLUtil.getElements((Node)filterCombinationsElement.get(), (String)"FilterCombination")) {
                        String expID = XMLUtil.getAttributeValue((Element)filterCombinationElement, (String)"ID", (String)"");
                        expID = "Exp" + expID.substring(expID.length() - 1);
                        for (Object sliderRefElement2 : XMLUtil.getElements((Node)filterCombinationElement, (String)"SliderRef")) {
                            camID = XMLUtil.getAttributeValue((Element)sliderRefElement2, (String)"ID", (String)"");
                            if (!((String)camID).startsWith("Camera")) continue;
                            camID = "Cam" + ((String)camID).substring(((String)camID).length() - 1);
                            Map<String, Element> map = this.filterCombinations;
                            synchronized (map) {
                                this.filterCombinations.put(String.valueOf(expID) + (String)camID, (Element)sliderRefElement2);
                            }
                        }
                    }
                }
                Thread.yield();
                Element plateElement = XMLUtil.getElement((Node)flexElement, (String)"Plate");
                String plateType = XMLUtil.getElementValue((Node)plateElement, (String)"PlateName", (String)"Unknown plate");
                String plateID = XMLUtil.getElementValue((Node)plateElement, (String)"Barcode", (String)"");
                sliderRefElement2 = this.metadata;
                synchronized (sliderRefElement2) {
                    this.metadata.setPlateName(plateType, 0);
                    this.metadata.setPlateID(plateID, 0);
                }
                int nbRows = XMLUtil.getElementIntValue((Node)plateElement, (String)"XSize", (int)3);
                int nbCols = XMLUtil.getElementIntValue((Node)plateElement, (String)"YSize", (int)4);
                camID = this.metadata;
                synchronized (camID) {
                    this.metadata.setPlateRows(new PositiveInteger(Integer.valueOf(nbRows)), 0);
                    this.metadata.setPlateColumns(new PositiveInteger(Integer.valueOf(nbCols)), 0);
                }
                Element wellShapeElement = XMLUtil.getElement((Node)plateElement, (String)"WellShape");
                String shape = XMLUtil.getElementValue((Node)wellShapeElement, (String)"Shape", (String)"Circle");
                OldWell.Shape wellShape = OldWell.Shape.valueOf(shape);
                this.wellPlate.set(new OldWellPlate((OldWellPlateReader)this.readerReference, this.metadata, wellShape));
                sublayoutsElement = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Sublayouts"));
                if (((Optional)sublayoutsElement).isPresent()) {
                    for (Element sublayoutElement : XMLUtil.getElements((Node)((Node)((Optional)sublayoutsElement).get()), (String)"Sublayout")) {
                        Map<Integer, Point2D> layout;
                        HashMap<Integer, Point2D> sublayout = new HashMap<Integer, Point2D>();
                        for (Element fieldElement : XMLUtil.getElements((Node)sublayoutElement, (String)"Field")) {
                            int fieldID = XMLUtil.getAttributeIntValue((Element)fieldElement, (String)"No", (int)1);
                            double centerX = XMLUtil.getElementDoubleValue((Node)fieldElement, (String)"OffsetX", (double)0.0) * 1000000.0;
                            double centerY = XMLUtil.getElementDoubleValue((Node)fieldElement, (String)"OffsetY", (double)0.0) * 1000000.0;
                            sublayout.put(fieldID, new Point2D.Double(centerX, centerY));
                        }
                        String subLayoutID = XMLUtil.getAttributeValue((Element)sublayoutElement, (String)"ID", (String)"");
                        Map<String, Map<Integer, Point2D>> fieldID = this.plateLayout;
                        synchronized (fieldID) {
                            layout = this.plateLayout.get(subLayoutID);
                            if (layout == null) {
                                layout = new HashMap<Integer, Point2D>();
                                this.plateLayout.put(subLayoutID, layout);
                            }
                        }
                        Map<Integer, Point2D> layoutFinal = layout;
                        sublayout.forEach((key, value) -> {
                            Map map2 = layoutFinal;
                            synchronized (map2) {
                                layoutFinal.put((Integer)key, (Point2D)value);
                            }
                        });
                    }
                }
            }
            Thread.yield();
            Element wellElement = XMLUtil.getElement((Node)flexElement, (String)"Well");
            Element wellCoordinateElement = XMLUtil.getElement((Node)wellElement, (String)"WellCoordinate");
            int row = XMLUtil.getAttributeIntValue((Element)wellCoordinateElement, (String)"Row", (int)0);
            int col = XMLUtil.getAttributeIntValue((Element)wellCoordinateElement, (String)"Col", (int)0);
            OldWell well = this.wellPlate.get().getWellAt(row - 1, col - 1);
            String subLayoutID = XMLUtil.getElementValue((Node)wellElement, (String)"SublayoutRef", (String)"");
            Element imagesElement = XMLUtil.getElement((Node)wellElement, (String)"Images");
            ArrayList imageChannelsElement = XMLUtil.getElements((Node)imagesElement, (String)"Image");
            int currentChannel = 0;
            while (currentChannel < imageChannelsElement.size()) {
                Thread.yield();
                Element imageElement = (Element)imageChannelsElement.get(currentChannel);
                if (this.firstRun.get()) {
                    String cameraRef;
                    Element filterCombinationElement;
                    String filter;
                    if (currentChannel == 0) {
                        this.pixelSizeX.set(XMLUtil.getElementDoubleValue((Node)imageElement, (String)"ImageResolutionX", (double)1.0E-6) * 1000000.0);
                        this.pixelSizeY.set(XMLUtil.getElementDoubleValue((Node)imageElement, (String)"ImageResolutionY", (double)1.0E-6) * 1000000.0);
                        sublayoutsElement = this.metadata;
                        synchronized (sublayoutsElement) {
                            MetaDataUtil.setPixelSizeX((OMEXMLMetadata)this.metadata, (int)0, (double)this.pixelSizeX.get());
                            MetaDataUtil.setPixelSizeY((OMEXMLMetadata)this.metadata, (int)0, (double)this.pixelSizeY.get());
                        }
                        int imageWidth = XMLUtil.getElementIntValue((Node)imageElement, (String)"ImageWidth", (int)0);
                        int imageHeight = XMLUtil.getElementIntValue((Node)imageElement, (String)"ImageHeight", (int)0);
                        this.fieldWidth.set(this.pixelSizeX.get() * (double)imageWidth);
                        this.fieldHeight.set(this.pixelSizeY.get() * (double)imageHeight);
                    }
                    if ((filter = XMLUtil.getAttributeValue((Element)(filterCombinationElement = this.filterCombinations.get(cameraRef = XMLUtil.getElementValue((Node)imageElement, (String)"CameraRef", null))), (String)"Filter", null)) == null) {
                        filter = "540/75";
                    }
                    OMEXMLMetadata sublayout = this.metadata;
                    synchronized (sublayout) {
                        this.metadata.setChannelName(filter, 0, currentChannel);
                    }
                    String[] filterValues = filter.split("/");
                    int lambdaEx = Integer.parseInt(filterValues[0]) - Integer.parseInt(filterValues[1]);
                    int lambdaEm = lambdaEx + 40;
                    Unit lambdaUnit = Unit.CreateBaseUnit((String)"nanometers", (String)"lambda");
                    Length excitation = new Length((Number)lambdaEx, lambdaUnit);
                    Length emmission = new Length((Number)lambdaEm, lambdaUnit);
                    OMEXMLMetadata centerY = this.metadata;
                    synchronized (centerY) {
                        this.metadata.setChannelExcitationWavelength(excitation, 0, currentChannel);
                        this.metadata.setChannelEmissionWavelength(emmission, 0, currentChannel);
                    }
                    java.awt.Color color = ColorUtil.getColorFromWavelength((double)lambdaEm);
                    OMEXMLMetadata oMEXMLMetadata = this.metadata;
                    synchronized (oMEXMLMetadata) {
                        this.metadata.setChannelColor(OMEUtil.getOMEColor((java.awt.Color)color), 0, currentChannel);
                    }
                }
                int fieldNumber = XMLUtil.getElementIntValue((Node)imageElement, (String)"Sublayout", (int)0);
                Point2D fieldPosition = this.plateLayout.get(subLayoutID).get(fieldNumber);
                RectangularShape wellShape = well.getShape().wellShape;
                double fieldX = wellShape.getCenterX() + (fieldPosition.getX() - 0.5 * this.fieldWidth.get());
                double fieldY = wellShape.getCenterY() + (fieldPosition.getY() - 0.5 * this.fieldHeight.get());
                OldWell oldWell = well;
                synchronized (oldWell) {
                    well.addField(new OldField(well, fieldNumber, fieldX, fieldY, this.fieldWidth.get(), this.fieldHeight.get(), new String[]{this.filePath}));
                }
                ++currentChannel;
            }
            this.firstRun.set(false);
            return null;
        }
    }
}

