/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.io;

import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codecimpl.TIFFCodec;
import danyfel80.wells.data.IField;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.opera.OperaChannel;
import danyfel80.wells.data.opera.OperaField;
import danyfel80.wells.data.opera.OperaPlane;
import danyfel80.wells.data.opera.OperaPlate;
import danyfel80.wells.data.opera.OperaTimepoint;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.sequence.Sequence;
import icy.type.dimension.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedImageAdapter;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.primitives.PositiveInteger;
import plugins.adufour.hcs.io.AbstractWellPlateReader;

public class WellPlateReader_EvotecPerkinElmerOperaFlex
extends AbstractWellPlateReader {
    private static final FileFilter FLEX_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return FileUtil.getFileExtension((String)pathname.getName(), (boolean)false).equalsIgnoreCase("flex");
        }
    };
    private static final FileFilter COLUMBUS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".meax") || pathname.getName().endsWith(".ColumbusIDX.xml");
        }
    };

    @Override
    public String getSystemName() {
        return "Evotec-PerkinElmer Opera Flex";
    }

    @Override
    public boolean isValidPlate(File folder) {
        boolean hasColombusIndexFile;
        boolean containsFlexFiles = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        boolean bl = hasColombusIndexFile = FileUtil.getFiles((String)folder.getPath(), (FileFilter)COLUMBUS_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        return containsFlexFiles && !hasColombusIndexFile;
    }

    public Future<OperaPlate> loadPlateFromFolder(File folder, MessageProgressListener progressListener) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "EvotecFlexWellPlateReader"));
        Future<OperaPlate> future = executor.submit(() -> this.loadPlateFromFolder_internal(folder, progressListener));
        executor.shutdown();
        return future;
    }

    private OperaPlate loadPlateFromFolder_internal(File folder, MessageProgressListener progressListener) throws IOException {
        String[] files = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false);
        String descriptorFile = Optional.ofNullable(FileUtil.getFiles((String)folder.getPath(), (FileFilter)COLUMBUS_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false)).map(fs -> ((String[])fs).length == 0 ? null : fs[0]).orElse(null);
        if (files.length == 0 || descriptorFile != null) {
            throw new IOException("Invalid folder: " + folder.getPath() + ", no valid files in it.");
        }
        OperaPlate plate = new OperaPlate.Builder(folder.getAbsolutePath(), files).progressListener(progressListener).build();
        return plate;
    }

    @Override
    public Future<? extends Sequence> loadField(IPlate plate, IWell well, IField field, Sequence sequence, MessageProgressListener progressListener) {
        CompletableFuture<Sequence> future = new CompletableFuture<Sequence>();
        if (!(field instanceof OperaField)) {
            future.completeExceptionally(new ClassCastException("Provided field is not of type " + OperaField.class.getName()));
            return future;
        }
        if (!(plate instanceof OperaPlate)) {
            future.completeExceptionally(new ClassCastException("Provided plate is not of type " + OperaPlate.class.getName()));
            return future;
        }
        if (sequence == null) {
            sequence = new Sequence();
        }
        sequence.beginUpdate();
        OperaPlate operaPlate = (OperaPlate)plate;
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        metadata.setInstrumentID(operaPlate.getDevice(), 0);
        metadata.setPlateName(operaPlate.getName(), 0);
        metadata.setPlateID(operaPlate.getBarcode(), 0);
        metadata.setPlateRows(new PositiveInteger(Integer.valueOf(operaPlate.getDimension().height)), 0);
        metadata.setPlateColumns(new PositiveInteger(Integer.valueOf(operaPlate.getDimension().width)), 0);
        sequence.setPositionX(field.getPosition().getX());
        sequence.setPositionY(field.getPosition().getY());
        Dimension2D.Double pixelSize = new Dimension2D.Double();
        HashMap<Integer, String> channelNames = new HashMap<Integer, String>();
        HashMap<Integer, IcyColorMap> channelColors = new HashMap<Integer, IcyColorMap>();
        try {
            this.loadPlanes(operaPlate, (OperaField)field, sequence, pixelSize, channelNames, channelColors);
            sequence.setPixelSizeX(pixelSize.getSizeX());
            sequence.setPixelSizeY(pixelSize.getSizeY());
            for (Map.Entry entry : channelNames.entrySet()) {
                sequence.setChannelName(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            for (Map.Entry entry : channelColors.entrySet()) {
                sequence.setColormap(((Integer)entry.getKey()).intValue(), (IcyColorMap)entry.getValue(), true);
            }
        }
        finally {
            sequence.endUpdate();
        }
        future.complete(sequence);
        return future;
    }

    private void loadPlanes(OperaPlate plate, OperaField field, Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors) {
        List planes = field.getPlanes().values().stream().sorted(Comparator.comparingDouble(OperaPlane::getPositionZ)).map(StreamUtils.wrapFunction(plane -> this.loadPlane(sequence, pixelSize, channelNames, channelColors, plate, field, (OperaPlane)plane))).collect(Collectors.toList());
        int z = 0;
        for (List planeImages : planes) {
            int t = 0;
            for (IcyBufferedImage image : planeImages) {
                sequence.setImage(t, z, (BufferedImage)image);
                ++t;
            }
            ++z;
        }
    }

    private List<IcyBufferedImage> loadPlane(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, OperaPlate plate, OperaField field, OperaPlane plane) {
        List<IcyBufferedImage> timeImages = plane.getTimepoints().values().stream().sorted(Comparator.comparingLong(OperaTimepoint::getId)).map(StreamUtils.wrapFunction(t -> this.loadTimePoint(sequence, pixelSize, channelNames, channelColors, plate, field, plane, (OperaTimepoint)t))).collect(Collectors.toList());
        return timeImages;
    }

    private IcyBufferedImage loadTimePoint(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, OperaPlate plate, OperaField field, OperaPlane plane, OperaTimepoint t) {
        List channelImages = t.getChannels().values().stream().sorted(Comparator.comparingLong(OperaChannel::getId)).map(StreamUtils.wrapFunction(ch -> this.loadChannel(sequence, pixelSize, channelNames, channelColors, plate, field, plane, t, (OperaChannel)ch))).collect(Collectors.toList());
        return IcyBufferedImage.createFrom(channelImages);
    }

    private IcyBufferedImage loadChannel(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, OperaPlate plate, OperaField field, OperaPlane plane, OperaTimepoint t, OperaChannel ch) throws IOException {
        String folderPath = plate.getFolder();
        String flexFile = ch.getImage().getUrl();
        File fullFilePath = Paths.get(folderPath, flexFile).toFile();
        channelNames.put((int)ch.getId(), ch.getName());
        LinearColorMap colorMap = new LinearColorMap(String.valueOf((int)ch.getEmissionWavelength()) + "nm", ch.getColor());
        channelColors.put((int)ch.getId(), (IcyColorMap)colorMap);
        pixelSize.setSize(ch.getImage().getResolutionX(), ch.getImage().getResolutionY());
        SeekableStream ss = SeekableStream.wrapInputStream((InputStream)new FileInputStream(fullFilePath.getAbsoluteFile()), (boolean)true);
        ImageDecoder dec = TIFFCodec.createImageDecoder((String)"tiff", (SeekableStream)ss, (ImageDecodeParam)new TIFFDecodeParam());
        RenderedImage loadedImage = dec.decodeAsRenderedImage((int)ch.getId());
        return IcyBufferedImage.createFrom((PlanarImage)new RenderedImageAdapter(loadedImage));
    }
}

