/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.saveastiffast;

import icy.file.Loader;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.viewer.Viewer;
import icy.imagej.ImageJUtil;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.sequence.Sequence;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.swing.SwingUtilities;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;

public class SaveAsTifFast
extends EzPlug
implements Block {
    private EzVar<Sequence> inputseq = new EzVarSequence("Sequence");
    private EzVarFile outputfile = new EzVarFile("Output file", null);

    protected void initialize() {
        this.addEzComponent((EzComponent)new EzLabel(this.getVersionString()));
        this.inputseq.setToolTipText("Sequence to Save");
        this.outputfile.setToolTipText("Where to save as tif");
        this.outputfile = new EzVarFile("Output file", ((Sequence)this.inputseq.getValue()).getFilename());
        this.addEzComponent((EzComponent)this.inputseq);
        this.addEzComponent((EzComponent)this.outputfile);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("inputseq", this.inputseq.getVariable());
        inputMap.add("outputfile", this.outputfile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
    }

    protected void execute() {
        ImagePlus tmpimp = ImageJUtil.convertToImageJImage((Sequence)((Sequence)this.inputseq.getValue()), null);
        String mynamepath = ((File)this.outputfile.getValue()).getPath();
        if (!mynamepath.endsWith(".tif")) {
            mynamepath = mynamepath + ".tif";
        }
        IJ.saveAsTiff((ImagePlus)tmpimp, (String)mynamepath);
        try {
            SwingUtilities.invokeAndWait(() -> ((Sequence)this.inputseq.getValue()).saveXMLData());
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        String inputxml = ((Sequence)this.inputseq.getValue()).getOutputFilename(false) + ".xml";
        String outputxml = mynamepath.replaceAll(".tif", ".xml");
        SaveAsTifFast.copyfile(inputxml, outputxml);
        if (!this.isHeadLess()) {
            new AnnounceFrame(((Sequence)this.inputseq.getValue()).getName() + " has been saved as " + mynamepath, 5);
        }
        System.out.println(((Sequence)this.inputseq.getValue()).getName() + " has been saved as " + mynamepath);
    }

    private static boolean copyfile(String inputxml, String outputxml) {
        try {
            Path inputxmlPath = Paths.get(inputxml, new String[0]);
            Path outputxmlPath = Paths.get(outputxml, new String[0]);
            Files.copy(inputxmlPath, outputxmlPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {
        Icy.main((String[])args);
        String imagePath = "samples/Cont1.lsm";
        Sequence sequence = Loader.loadSequence((String)"samples/Cont1.lsm", (int)0, (boolean)true);
        SwingUtilities.invokeAndWait(() -> new Viewer(sequence));
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)SaveAsTifFast.class.getName()));
    }

    public void clean() {
    }

    private String getVersionString() {
        String version = "unknown";
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            version = model.getArtifactId() + model.getVersion();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return version;
    }
}

