/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.models.Model;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;

public abstract class Collection {
    JSONArray list = new JSONArray();
    HashMap<String, String> map = new HashMap();
    HashMap<String, String> params = new HashMap();
    protected int max;
    protected int offset;

    public Collection(int max, int offset) {
        this.max = max;
        this.offset = offset;
    }

    public void nextPageIndex() {
        this.offset += this.max;
    }

    public String getPaginatorURLParams() {
        return "&max=" + this.max + "&offset=" + this.offset;
    }

    public abstract String toURL();

    public abstract String getDomainName();

    public JSONArray getList() {
        return this.list;
    }

    public void setList(JSONArray list) {
        this.list = list;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(Object o) {
        this.list.add((Object)((Model)o).getAttr());
    }

    boolean isFilterBy(String name) {
        return this.map.containsKey(name);
    }

    public String getFilter(String name) {
        return this.map.get(name);
    }

    public Map<String, String> getFilters() {
        return this.map;
    }

    public void addFilter(String name, String value) {
        this.map.put(name, value);
    }

    public void addParams(String name, String value) {
        this.params.put(name, value);
    }

    public String getJSONResourceURL() {
        if (this.params.isEmpty()) {
            return "/api/" + this.getDomainName() + ".json";
        }
        String base = "/api/" + this.getDomainName() + ".json?";
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            base = base + param.getKey() + "=" + param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public String getJSONResourceURLWithFilter(String filter1Name) {
        return "/api/" + filter1Name + "/" + this.getFilter(filter1Name) + "/" + this.getDomainName() + ".json";
    }

    public String getJSONResourceURLWithFilter(String filter1Name, String filter2Name) {
        return "/api/" + filter1Name + "/" + this.getFilter(filter1Name) + "/" + filter2Name + "/" + this.getFilter(filter2Name) + "/" + this.getDomainName() + ".json";
    }

    public String toString() {
        return this.getDomainName() + " collection";
    }
}

