/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public abstract class Model {
    JSONObject attr = new JSONObject();
    HashMap<String, String> params = new HashMap();
    HashMap<String, String> map = new HashMap();

    public void addParams(String name, String value) {
        this.params.put(name, value);
    }

    public JSONObject getAttr() {
        return this.attr;
    }

    public void setAttr(JSONObject attr) {
        this.attr = attr;
    }

    public void set(String name, Object value) {
        this.attr.put((Object)name, value);
    }

    public Object get(String name) {
        try {
            return this.attr.get((Object)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getStr(String name) {
        if (this.get(name) == null) {
            return null;
        }
        return this.get(name) + "";
    }

    public Integer getInt(String name) {
        String str = this.getStr(name);
        if (str == null) {
            return null;
        }
        return Integer.parseInt(str);
    }

    public Long getLong(String name) {
        String str = this.getStr(name);
        if (str == null) {
            return null;
        }
        return Long.parseLong(str);
    }

    public Double getDbl(String name) {
        if (this.get(name) == null) {
            return null;
        }
        if (this.get(name).getClass().getName().equals("java.lang.Long")) {
            return ((Long)this.get(name)).doubleValue();
        }
        return (Double)this.get(name);
    }

    public Boolean getBool(String name) {
        return (Boolean)this.get(name);
    }

    public List getList(String name) {
        return (List)this.get(name);
    }

    public String toURL() {
        Long id = (Long)this.get("id");
        if (id != null) {
            return this.getJSONResourceURL(id);
        }
        return this.getJSONResourceURL();
    }

    public Long getId() {
        return this.getLong("id");
    }

    public String toJSON() {
        return this.attr.toString();
    }

    public String getJSONResourceURL() {
        if (this.params.isEmpty()) {
            return "/api/" + this.getDomainName() + ".json";
        }
        String base = "/api/" + this.getDomainName() + ".json?";
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            base = base + param.getKey() + "=" + param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public String getJSONResourceURL(Long id) {
        return this.getJSONResourceURL(id + "");
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().intValue();
        }
        return 0;
    }

    public String getJSONResourceURL(String id) {
        if (this.params.isEmpty()) {
            return "/api/" + this.getDomainName() + "/" + id + ".json";
        }
        String base = "/api/" + this.getDomainName() + "/" + id + ".json?";
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            base = base + param.getKey() + "=" + param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public abstract String getDomainName();

    boolean isFilterBy(String name) {
        return this.map.containsKey(name);
    }

    public String getFilter(String name) {
        return this.map.get(name);
    }

    public void addFilter(String name, String value) {
        this.map.put(name, value);
    }

    public String toString() {
        return this.getDomainName() + this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        return ((Model)o).getId().equals(this.getId());
    }
}

