/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import be.cytomine.client.models.Model;
import java.util.Optional;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientUtils;
import org.bioimageanalysis.icy.icytomine.core.model.Description;

public abstract class Entity {
    private CytomineClient client;
    private Model model;

    public Entity(CytomineClient client, Model model) {
        this.client = client;
        this.model = model;
    }

    public CytomineClient getClient() {
        return this.client;
    }

    public Model getModel() {
        return this.model;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    public Long getId() {
        return this.model.getId();
    }

    public Optional<String> getStr(String field) {
        Optional<String> value = Optional.ofNullable(this.getModel().getStr(field));
        if (value.isPresent()) {
            value = Optional.of(CytomineClientUtils.convertFromSystenEncodingToUTF8(value.get()));
        }
        return value;
    }

    public Optional<Long> getLong(String field) {
        return Optional.ofNullable(this.getModel().getLong(field));
    }

    public Optional<Integer> getInt(String field) {
        return Optional.ofNullable(this.getModel().getInt(field));
    }

    public Optional<Double> getDbl(String field) {
        return Optional.ofNullable(this.getModel().getDbl(field));
    }

    public String getDomainName() {
        return this.getModel().getDomainName();
    }

    public Description getDescription() throws CytomineClientException {
        return this.getClient().getDescription(this.getId(), this.getDomainName());
    }

    public String toString() {
        return String.format("Entity (%s). Id: %s", this.getClass().getTypeName(), String.valueOf(this.getId()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.client != null) {
            result += this.client.hashCode();
        }
        result = 31 * result;
        if (this.model != null && this.getId() != null) {
            result += this.getId().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return this.hashCode() == other.hashCode();
    }
}

