/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import be.cytomine.client.models.ImageInstance;
import icy.type.dimension.Dimension2D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.core.model.User;

public class Image
extends Entity {
    private static final int DEFAULT_TILE_SIZE = 256;
    private List<String> imageServers;
    private List<Annotation> annotations;

    public static Image retrieve(CytomineClient client, long imageInstanceId) throws CytomineClientException {
        return client.getImageInstance(imageInstanceId);
    }

    public Image(CytomineClient client, ImageInstance internalImage) {
        super(client, internalImage);
    }

    public ImageInstance getInternalImage() {
        return (ImageInstance)this.getModel();
    }

    public Optional<Calendar> getCreationDate() {
        Optional<Long> numericDate = this.getLong("created");
        if (numericDate.isPresent()) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(numericDate.get());
            return Optional.of(c);
        }
        return Optional.ofNullable(null);
    }

    public Optional<Long> getAbstractImageId() {
        return this.getLong("baseImage");
    }

    public Optional<Long> getProjectId() {
        return this.getLong("project");
    }

    public Optional<String> getName() {
        return this.getStr("originalFilename");
    }

    public Optional<String> getMimeType() {
        return this.getStr("mime");
    }

    public Optional<Integer> getSizeX() {
        return this.getInt("width");
    }

    public Optional<Integer> getSizeY() {
        return this.getInt("height");
    }

    public Optional<Dimension> getSize() {
        if (this.getSizeX().isPresent() && this.getSizeY().isPresent()) {
            return Optional.of(new Dimension(this.getSizeX().get(), this.getSizeY().get()));
        }
        return Optional.ofNullable(null);
    }

    public Optional<Double> getResolution() {
        return super.getDbl("resolution");
    }

    public Optional<Double> getDimensionX() {
        Optional<Double> resolution = this.getResolution();
        Optional<Integer> size = this.getSizeX();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(resolution.get() * (double)size.get().intValue());
        }
        return Optional.ofNullable(null);
    }

    public Optional<Double> getDimensionY() {
        Optional<Double> resolution = this.getResolution();
        Optional<Integer> size = this.getSizeY();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(resolution.get() * (double)size.get().intValue());
        }
        return Optional.ofNullable(null);
    }

    public Optional<Dimension2D> getDimension() {
        Optional<Dimension> size = this.getSize();
        Optional<Double> resolution = this.getResolution();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(new Dimension2D.Double((double)size.get().width * resolution.get(), (double)size.get().height * resolution.get()));
        }
        return Optional.ofNullable(null);
    }

    public Optional<Integer> getMagnification() {
        return this.getInt("magnification");
    }

    public Optional<Long> getDepth() {
        return this.getLong("depth");
    }

    public Optional<Integer> getTileWidth() {
        return Optional.of(256);
    }

    public Optional<Integer> getTileHeight() {
        return Optional.of(256);
    }

    public Optional<Dimension> getTileSize() {
        if (this.getTileWidth().isPresent() && this.getTileHeight().isPresent()) {
            return Optional.of(new Dimension(this.getTileWidth().get(), this.getTileHeight().get()));
        }
        return Optional.ofNullable(null);
    }

    public Long getOriginalUserId() {
        return this.getLong("user").get();
    }

    public Optional<Long> getAnnotationsOfUsersNumber() {
        return this.getLong("numberOfAnnotations");
    }

    public Optional<Long> getAnnotationsOfAlgorithmNumber() {
        return this.getLong("numberOfJobAnnotations");
    }

    public Optional<String> getTileUrl(long resolution, int x, int y) throws CytomineClientException {
        List<String> servers = this.getImageServers(false);
        if (servers.isEmpty()) {
            return Optional.ofNullable(null);
        }
        return Optional.of(String.format("%s&z=%d&x=%d&y=%d&mimeType=%s", servers.get(0), this.getDepth().orElse(0L) - resolution, x, y, this.getMimeType().orElse("ndpi")));
    }

    public List<String> getImageServers(boolean recompute) throws CytomineClientException {
        if (this.imageServers == null || recompute) {
            this.imageServers = null;
            this.imageServers = this.getClient().getImageServers(this);
        }
        return this.imageServers;
    }

    public BufferedImage getThumbnail(int maxSize) throws CytomineClientException {
        return this.getClient().downloadImageAsBufferedImage(this.getAbstractImageId().get(), maxSize);
    }

    public List<Annotation> getAnnotations(boolean recompute) throws CytomineClientException {
        if (this.annotations == null || recompute) {
            this.annotations = null;
            this.annotations = this.getClient().getImageAnnotations(this.getId());
        }
        return this.annotations;
    }

    public List<Annotation> getAnnotationsWithGeometry(boolean recompute) throws CytomineClientException {
        long annotationsWithoutGeometry = 0L;
        if (this.annotations != null) {
            annotationsWithoutGeometry = this.annotations.stream().filter(a -> !a.getLocation().isPresent()).count();
        }
        if (this.annotations == null || recompute || annotationsWithoutGeometry > 0L) {
            this.annotations = null;
            this.annotations = this.getClient().getFullImageAnnotations(this.getId());
        }
        return this.annotations;
    }

    public List<Annotation> getAnnotationsWithGeometryOf(Rectangle2D currentTileArea) throws CytomineClientException {
        return this.getClient().getFullImageAnnotations(this.getId(), currentTileArea);
    }

    public Project getProject() throws CytomineClientException {
        return this.getClient().getProject(this.getProjectId().get());
    }

    public Set<User> getAnnotationUsers() {
        List<Annotation> annotations = this.getAnnotations(false);
        return annotations.stream().map(a -> a.getUser()).collect(Collectors.toSet());
    }

    public void removeAnnotations(Set<Annotation> selectedAnnotations) throws CytomineClientException {
        for (Annotation annotation2 : selectedAnnotations) {
            this.getClient().removeAnnotation(annotation2.getId());
        }
        Set selectedAnnotationIds = selectedAnnotations.stream().map(a -> a.getId()).collect(Collectors.toSet());
        if (this.annotations != null) {
            boolean bl = this.annotations.removeIf(annotation -> selectedAnnotationIds.contains(annotation.getId()));
        }
    }

    public void setMagnification(Integer newMagnification) throws CytomineClientException {
        this.getClient().updateImageMagnfication(this, newMagnification);
    }

    public void setResolution(Double newResolution) throws CytomineClientException {
        this.getClient().updateImageResolution(this, newResolution);
    }

    @Override
    public String toString() {
        return String.format("Image instance: id=%s, name=%s", String.valueOf(this.getId()), this.getName().orElse("Not specified"));
    }
}

