/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;

public class GeometricHash<T> {
    private Rectangle2D area;
    private int columns;
    private int rows;
    private List<Set<T>> cells;

    public GeometricHash(Rectangle2D area, int cols, int rows) throws IllegalArgumentException {
        if (cols < 1) {
            throw new IllegalArgumentException("Column count less than 1.");
        }
        if (rows < 1) {
            throw new IllegalArgumentException("Row count less than 1.");
        }
        this.area = area;
        this.columns = cols;
        this.rows = rows;
        this.cells = new ArrayList<Set<T>>((this.columns + 2) * (rows + 2));
        IntStream.range(0, (this.columns + 2) * (rows + 2)).forEach(i -> this.cells.add(Collections.synchronizedSet(new HashSet())));
    }

    public GeometricHash(Rectangle2D area, int cellCount) {
        if (cellCount < 1) {
            throw new IllegalArgumentException("Cell count less than 1.");
        }
        this.area = area;
        double rel = Math.abs(area.getWidth() / area.getHeight());
        this.columns = Math.max(1, (int)Math.sqrt((double)cellCount * rel));
        this.rows = Math.max(1, cellCount / this.columns);
        this.columns = Math.max(1, cellCount / this.rows);
        this.cells = new ArrayList<Set<T>>((this.columns + 2) * (this.rows + 2));
        IntStream.range(0, (this.columns + 2) * (this.rows + 2)).forEach(i -> this.cells.add(new HashSet()));
    }

    public Rectangle2D area() {
        return this.area;
    }

    public int columns() {
        return this.columns;
    }

    public int rows() {
        return this.rows;
    }

    public double verticalLinePosition(int column) throws IllegalArgumentException {
        if (column < -1 || column > this.columns + 1) {
            throw new IllegalArgumentException("Invalid column (<-1 or >columns+1");
        }
        double rel = (double)column / (double)this.columns;
        double pos = rel * this.area.getMaxX() + (1.0 - rel) * this.area.getMinX();
        if (column == -1) {
            pos = Double.NEGATIVE_INFINITY;
        }
        if (column == this.columns + 1) {
            pos = Double.POSITIVE_INFINITY;
        }
        return pos;
    }

    public double horizontalLinePosition(int row) throws IllegalArgumentException {
        if (row < -1 || row > this.rows + 1) {
            throw new IllegalArgumentException("Invalid row (<-1 or >rows+1");
        }
        double rel = (double)row / (double)this.rows;
        double pos = rel * this.area.getMaxY() + (1.0 - rel) * this.area.getMinY();
        if (row == -1) {
            pos = Double.NEGATIVE_INFINITY;
        }
        if (row == this.rows + 1) {
            pos = Double.POSITIVE_INFINITY;
        }
        return pos;
    }

    public int[] cellContaining(Point2D pos) {
        int[] coord = new int[2];
        if (pos.getX() >= this.area.getMaxX()) {
            coord[0] = this.columns;
        } else if (pos.getX() < this.area.getMinX()) {
            coord[0] = -1;
        } else {
            double dc = (pos.getX() - this.area.getMinX()) * (double)this.columns / this.area.getWidth();
            if (dc >= (double)this.columns) {
                coord[0] = this.columns;
            } else if (dc <= -1.0) {
                coord[0] = -1;
            } else {
                int ic = (int)dc;
                coord[0] = Math.max(Math.min(ic, this.columns), -1);
            }
        }
        if (pos.getY() >= this.area.getMaxY()) {
            coord[1] = this.rows;
        } else if (pos.getY() < this.area.getMinY()) {
            coord[1] = -1;
        } else {
            double dl = (pos.getY() - this.area.getMinY()) * (double)this.rows / this.area.getHeight();
            if (dl >= (double)this.rows) {
                coord[1] = this.rows;
            } else if (dl <= -1.0) {
                coord[1] = -1;
            } else {
                int il = (int)dl;
                coord[1] = Math.max(Math.min(il, this.rows), -1);
            }
        }
        return coord;
    }

    public int[] cellsContaining(Rectangle2D rectangle) {
        int[] range = new int[4];
        int[] lb = this.cellContaining(new Point2D.Double(rectangle.getMinX(), rectangle.getMinY()));
        int[] rt = this.cellContaining(new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY()));
        range[0] = lb[1];
        range[1] = rt[1];
        range[2] = lb[0];
        range[3] = rt[0];
        return range;
    }

    public Rectangle2D cellArea(int column, int row) throws IllegalArgumentException {
        if (column < -1 || column > this.columns) {
            throw new IllegalArgumentException("Invalid column < -1 or > columns");
        }
        if (row < -1 || row > this.rows) {
            throw new IllegalArgumentException("Invalid row < -1 or > rows");
        }
        return new Rectangle2D.Double(this.horizontalLinePosition(row), this.horizontalLinePosition(row + 1), this.verticalLinePosition(column), this.verticalLinePosition(column + 1));
    }

    public void addObjectAt(T object, Rectangle2D area) {
        int[] range = this.cellsContaining(area);
        for (int y = range[0]; y <= range[1]; ++y) {
            for (int x = range[2]; x <= range[3]; ++x) {
                this.cellObjectsAt(x, y).add(object);
            }
        }
    }

    public Set<T> cellObjectsAt(Rectangle2D rectangle) throws InterruptedException {
        HashSet<T> objs = new HashSet<T>();
        int[] range = this.cellsContaining(rectangle);
        for (int y = range[0]; y <= range[1]; ++y) {
            for (int x = range[2]; x <= range[3]; ++x) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                objs.addAll(this.cellObjectsAt(x, y));
            }
        }
        return objs;
    }

    protected Set<T> cellObjectsAt(int column, int row) {
        if (column < -1 || column > this.columns) {
            throw new IllegalArgumentException("Invalid column < -1 or > columns");
        }
        if (row < -1 || row > this.rows) {
            throw new IllegalArgumentException("Invalid row < -1 or > rows");
        }
        return this.cells.get((column + 1) * (this.rows + 2) + (row + 1));
    }

    public void clear() {
        for (Set<T> cell : this.cells) {
            cell.clear();
        }
    }
}

