/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilterByUser;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationFilterByUserPanel
extends AnnotationFilterPanel<AnnotationFilterByUser.UserItem> {
    AnnotationFilterByUser userFilter;

    public AnnotationFilterByUserPanel() {
        this.setLabelText("Users:");
        this.userFilter = new AnnotationFilterByUser();
        this.setFilter(this.userFilter);
    }

    public void setPreviousFilter(AnnotationFilter previousFilter) {
        this.userFilter.setPreviousFilter(previousFilter);
    }

    public void setUsers(Set<User> users) {
        Set<AnnotationFilterByUser.UserItem> userItems = users.stream().map(u -> new AnnotationFilterByUser.UserItem((User)u)).collect(Collectors.toSet());
        userItems.add(AnnotationFilterByUser.UserItem.NO_USER);
        this.userFilter.setActiveUsers(userItems);
        this.setModel(userItems.toArray(new AnnotationFilterByUser.UserItem[userItems.size()]), u -> u.toString());
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AnnotationFilterByUser.UserItem userItem = (AnnotationFilterByUser.UserItem)checkableItem.object;
        if (!checkableItem.isSelected()) {
            this.userFilter.getActiveUsers().add(userItem);
        } else {
            this.userFilter.getActiveUsers().remove(userItem);
        }
        this.userFilter.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

