/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.IcySequenceToCytominePanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.SequenceItem;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class IcySequenceToCytominePanel
extends JPanel {
    private JComboBox<SequenceItem> sequenceComboBox;
    private JCheckBox roiSelectionCheckBox;
    private JProgressBar transferProgressBar;
    private JButton sendButton;
    private JButton cancelButton;
    private IcySequenceToCytominePanelController panelController;

    public IcySequenceToCytominePanel(ViewController viewController) {
        this.setView();
        this.setPanelController(viewController);
    }

    private void setView() {
        this.setPreferredSize(new Dimension(300, 220));
        this.setGridBagLayout();
        this.addInstructionsMessage();
        this.addSequenceSelection();
        this.addRoiSelection();
        this.addProgressBar();
        this.addActionButtons();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
    }

    private void addInstructionsMessage() {
        JLabel messageLabel = new JLabel("Please select the sequence to send");
        this.addWithConstraints(messageLabel, this, 0, 0, 2, 1, 10, 0, 5, 5, 5, 5);
    }

    private void addSequenceSelection() {
        JLabel sequenceLabel = new JLabel("Sequence");
        this.addWithConstraints(sequenceLabel, this, 0, 1, 1, 1, 13, 2, 0, 5, 5, 5);
        this.sequenceComboBox = new JComboBox();
        this.addWithConstraints(this.sequenceComboBox, this, 1, 1, 1, 1, 10, 2, 0, 0, 5, 5);
    }

    private void addRoiSelection() {
        this.roiSelectionCheckBox = new JCheckBox("Send only selected ROI's");
        this.addWithConstraints(this.roiSelectionCheckBox, this, 0, 2, 2, 1, 10, 0, 0, 5, 5, 5);
    }

    private void addProgressBar() {
        this.transferProgressBar = new JProgressBar();
        this.addWithConstraints(this.transferProgressBar, this, 0, 3, 2, 1, 10, 1, 0, 5, 5, 5);
    }

    private void addActionButtons() {
        JPanel panel = this.getActionButtonPanel();
        this.addWithConstraints(panel, this, 0, 4, 2, 1, 10, 1, 0, 5, 5, 5);
    }

    private JPanel getActionButtonPanel() {
        JPanel panel = new JPanel();
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.columnWidths = new int[]{0, 0};
        panelLayout.rowHeights = new int[]{0};
        panelLayout.columnWeights = new double[]{0.0, 0.0};
        panelLayout.rowWeights = new double[]{0.0};
        panel.setLayout(panelLayout);
        this.sendButton = new JButton("Send");
        this.addWithConstraints(this.sendButton, panel, 0, 0, 1, 1, 10, 0, 0, 0, 0, 5);
        this.cancelButton = new JButton("Cancel");
        this.addWithConstraints(this.cancelButton, panel, 1, 0, 1, 1, 10, 0, 0, 0, 0, 0);
        return panel;
    }

    private void addWithConstraints(Component component, Container container, int x, int y, int width, int height, int anchor, int fill, int topInset, int leftInset, int bottomInset, int rightInset) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.insets = new Insets(10, 10, 10, 10);
        container.add(component, constraints);
    }

    private void setPanelController(ViewController viewController) {
        if (viewController != null) {
            this.panelController = new IcySequenceToCytominePanelController(this, viewController);
        }
    }

    public void addCloseListener(ActionListener listener) {
        this.panelController.addCloseListener(listener);
    }

    protected JComboBox<SequenceItem> getSequenceComboBox() {
        return this.sequenceComboBox;
    }

    protected JCheckBox getRoiSelectionCheckBox() {
        return this.roiSelectionCheckBox;
    }

    protected JProgressBar getTransferProgressBar() {
        return this.transferProgressBar;
    }

    protected JButton getSendButton() {
        return this.sendButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    public IcySequenceToCytominePanelController getController() {
        return this.panelController;
    }
}

