/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client;

import be.cytomine.client.CytomineException;
import be.cytomine.client.HttpClient;
import be.cytomine.client.collections.AmqpQueueCollection;
import be.cytomine.client.collections.AnnotationCollection;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.collections.DeleteCommandCollection;
import be.cytomine.client.collections.ImageInstanceCollection;
import be.cytomine.client.collections.JobDataCollection;
import be.cytomine.client.collections.OntologyCollection;
import be.cytomine.client.collections.ProjectCollection;
import be.cytomine.client.collections.PropertyCollection;
import be.cytomine.client.collections.ReviewedAnnotationCollection;
import be.cytomine.client.collections.RoleCollection;
import be.cytomine.client.collections.SearchCollection;
import be.cytomine.client.collections.SoftwareCollection;
import be.cytomine.client.collections.StorageCollection;
import be.cytomine.client.collections.TermCollection;
import be.cytomine.client.collections.UploadedFileCollection;
import be.cytomine.client.collections.UserCollection;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.Annotation;
import be.cytomine.client.models.AnnotationTerm;
import be.cytomine.client.models.AnnotationUnion;
import be.cytomine.client.models.AttachedFile;
import be.cytomine.client.models.Description;
import be.cytomine.client.models.ImageFilter;
import be.cytomine.client.models.ImageGroup;
import be.cytomine.client.models.ImageGroupHDF5;
import be.cytomine.client.models.ImageInstance;
import be.cytomine.client.models.ImageSequence;
import be.cytomine.client.models.ImageServers;
import be.cytomine.client.models.Job;
import be.cytomine.client.models.JobData;
import be.cytomine.client.models.JobParameter;
import be.cytomine.client.models.JobTemplate;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Ontology;
import be.cytomine.client.models.ProcessingServer;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.Property;
import be.cytomine.client.models.Role;
import be.cytomine.client.models.Software;
import be.cytomine.client.models.SoftwareParameter;
import be.cytomine.client.models.SoftwareProject;
import be.cytomine.client.models.Storage;
import be.cytomine.client.models.StorageAbstractImage;
import be.cytomine.client.models.Term;
import be.cytomine.client.models.UploadedFile;
import be.cytomine.client.models.User;
import be.cytomine.client.models.UserJob;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Cytomine {
    private static final Logger log = Logger.getLogger(Cytomine.class);
    private String host;
    private String login;
    private String pass;
    private String publicKey;
    private String privateKey;
    private String charEncoding = "UTF-8";
    private int max = 0;
    private int offset = 0;

    public Cytomine(String host, String publicKey, String privateKey) {
        this.host = host;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.login = publicKey;
        this.pass = privateKey;
    }

    @Deprecated
    public Cytomine(String host, String publicKey, String privateKey, String basePath) {
        this(host, publicKey, privateKey);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    boolean testHostConnection() throws Exception {
        HttpClient client = new HttpClient();
        client.connect(this.getHost() + "/server/ping", this.login, this.pass);
        int code = 0;
        try {
            code = client.get();
        }
        catch (Exception e) {
            log.error((Object)e.toString());
        }
        client.disconnect();
        return code == 200 || code == 201 || code == 304;
    }

    public boolean nextPage(Collection collection) throws CytomineException {
        collection.nextPageIndex();
        collection = this.fetchCollection(collection);
        return !collection.isEmpty();
    }

    private String buildEncode(String keywords) throws CytomineException {
        try {
            return URLEncoder.encode(keywords, this.getCharEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new CytomineException(e);
        }
    }

    private void analyzeCode(int code, JSONObject json) throws CytomineException {
        if (code >= 400 && code < 600) {
            throw new CytomineException(code, json);
        }
        if (code == 302) {
            throw new CytomineException(code, json);
        }
    }

    private JSONObject createJSONResponse(int code, String response) throws CytomineException {
        try {
            Object obj = JSONValue.parse((String)response);
            return (JSONObject)obj;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CytomineException(code, response);
        }
        catch (Error e) {
            log.error((Object)e);
            throw new CytomineException(code, response);
        }
    }

    private JSONArray createJSONArrayResponse(int code, String response) throws CytomineException {
        Object obj = JSONValue.parse((String)response);
        return (JSONArray)obj;
    }

    public String doGet(String suburl) throws CytomineException {
        String response;
        try {
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("GET", suburl, "", "application/json,*/*");
            client.connect(this.getHost() + suburl);
            int code = client.get();
            response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
        return response;
    }

    private <T extends Model> T fetchModel(T model) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("GET", model.toURL(), "", "application/json,*/*");
            client.connect(this.getHost() + model.toURL());
            int code = client.get();
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            model.setAttr(json);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
        return model;
    }

    private <T extends Collection> T fetchCollection(T collection) throws CytomineException {
        HttpClient client = null;
        String url = collection.toURL();
        if (!url.contains("?")) {
            url = url + "?";
        }
        url = url + collection.getPaginatorURLParams();
        log.info((Object)("fetchCollection=" + url));
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("GET", url, "", "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.get();
            String response = client.getResponseData();
            client.disconnect();
            log.debug((Object)response);
            log.info((Object)code);
            Object obj = JSONValue.parse((String)response);
            if (obj instanceof JSONObject) {
                JSONObject json = (JSONObject)obj;
                this.analyzeCode(code, json);
                collection.setList((JSONArray)json.get((Object)"collection"));
            } else {
                collection.setList((JSONArray)obj);
            }
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
        return collection;
    }

    private String doPost(String suburl, String data) throws CytomineException {
        HttpClient client = null;
        client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
        try {
            client.authorize("POST", suburl, "", "application/json,*/*");
            client.connect(this.getHost() + suburl);
            int code = client.post(data);
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            return json.toString();
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    private String doDelete(String suburl) throws CytomineException {
        try {
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("DELETE", suburl, "", "application/json,*/*");
            client.connect(this.getHost() + suburl);
            int code = client.delete();
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            return json.toString();
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    private <T extends Model> T saveModel(T model) throws CytomineException {
        try {
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", model.toURL(), "", "application/json,*/*");
            client.connect(this.getHost() + model.toURL());
            int code = client.post(model.toJSON());
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            model.setAttr((JSONObject)json.get((Object)model.getDomainName()));
            return model;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public <T extends Model> T updateModel(T model) throws CytomineException {
        try {
            HttpClient client = null;
            String prefixUrl = model.toURL().split("\\?")[0];
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("PUT", prefixUrl, "", "application/json,*/*");
            client.connect(this.getHost() + model.toURL());
            int code = client.put(model.toJSON());
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            model.setAttr((JSONObject)json.get((Object)model.getDomainName()));
            return model;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    private void deleteModel(Model model) throws CytomineException {
        try {
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("DELETE", model.toURL(), "", "application/json,*/*");
            client.connect(this.getHost() + model.toURL());
            int code = client.delete();
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    private String doPut(String url, String content) throws CytomineException {
        try {
            HttpClient client = null;
            String prefixUrl = url.split("\\?")[0];
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("PUT", url, "", "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.put(content);
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            return json.toString();
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public void uploadFile(String url, byte[] data) throws CytomineException {
        try {
            HttpClient client = null;
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("files[]", (ContentBody)new ByteArrayBody(data, new Date().getTime() + "file"));
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", url, entity.getContentType().getValue(), "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.post(entity);
            String response = client.getResponseData();
            log.debug((Object)("response=" + response));
            client.disconnect();
            JSONObject jSONObject = this.createJSONResponse(code, response);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public void downloadPicture(String url, String dest) throws CytomineException {
        this.downloadPicture(url, dest, "jpg");
    }

    public void downloadPicture(String url, String dest, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            BufferedImage img = client.readBufferedImageFromURL(url);
            ImageIO.write((RenderedImage)img, format, new File(dest));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public void downloadPictureWithRedirect(String url, String dest, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            BufferedImage img = HttpClient.readBufferedImageFromRETRIEVAL(url, this.login, this.pass, this.getHost());
            ImageIO.write((RenderedImage)img, format, new File(dest));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public void downloadAbstractImage(long ID, int maxSize, String dest) throws CytomineException {
        String url = this.getHost() + "/api/abstractimage/" + ID + "/thumb.png?maxSize=" + maxSize;
        this.downloadPicture(url, dest, "png");
    }

    public void downloadImageInstance(long ID, String dest) throws CytomineException {
        this.downloadFile("/api/imageinstance/" + ID + "/download", dest);
    }

    public BufferedImage downloadPictureAsBufferedImage(String url, String format) throws CytomineException {
        HttpClient client = null;
        try {
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            return client.readBufferedImageFromURL(url);
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public BufferedImage downloadAbstractImageAsBufferedImage(long ID, int maxSize) throws CytomineException {
        String url = this.getHost() + "/api/abstractimage/" + ID + "/thumb.png?maxSize=" + maxSize;
        return this.downloadPictureAsBufferedImage(url, "png");
    }

    public void downloadFile(String url, String dest) throws CytomineException {
        try {
            HttpClient client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            int code = client.get(this.getHost() + url, dest);
            this.analyzeCode(code, (JSONObject)JSONValue.parse((String)"{}"));
        }
        catch (Exception e) {
            throw new CytomineException(0, e.toString());
        }
    }

    public Project getProject(Long id) throws CytomineException {
        Project project = new Project();
        project.set("id", id);
        return this.fetchModel(project);
    }

    public ProjectCollection getProjects() throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        return this.fetchCollection(projects);
    }

    public ProjectCollection getProjectsByOntology(Long idOntology) throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        projects.addFilter("ontology", idOntology + "");
        return this.fetchCollection(projects);
    }

    public ProjectCollection getProjectsByUser(Long idUser) throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        projects.addFilter("user", idUser + "");
        return this.fetchCollection(projects);
    }

    public Project addProject(String name, Long idOntology) throws CytomineException {
        Project project = new Project();
        project.set("name", name);
        project.set("ontology", idOntology);
        return this.saveModel(project);
    }

    public Project editProject(Long idProject, String name, Long idOntology) throws CytomineException {
        Project project = this.getProject(idProject);
        project.set("name", name);
        project.set("ontology", idOntology);
        return this.updateModel(project);
    }

    public void deleteProject(Long idProject) throws CytomineException {
        Project project = new Project();
        project.set("id", idProject);
        this.deleteModel(project);
    }

    public Ontology getOntology(Long id) throws CytomineException {
        Ontology ontology = new Ontology();
        ontology.set("id", id);
        return this.fetchModel(ontology);
    }

    public OntologyCollection getOntologies() throws CytomineException {
        OntologyCollection ontologys = new OntologyCollection(this.offset, this.max);
        return this.fetchCollection(ontologys);
    }

    public OntologyCollection getOntologiesByProject(Long idProject) throws CytomineException {
        OntologyCollection ontologys = new OntologyCollection(this.offset, this.max);
        ontologys.addFilter("project", idProject + "");
        return this.fetchCollection(ontologys);
    }

    public Ontology addOntology(String name) throws CytomineException {
        Ontology ontology = new Ontology();
        ontology.set("name", name);
        return this.saveModel(ontology);
    }

    public Ontology editOntology(Long idOntology, String name) throws CytomineException {
        Ontology ontology = this.getOntology(idOntology);
        ontology.set("name", name);
        return this.updateModel(ontology);
    }

    public void deleteOntology(Long idOntology) throws CytomineException {
        Ontology ontology = new Ontology();
        ontology.set("id", idOntology);
        this.deleteModel(ontology);
    }

    public AbstractImage addAbstractImage(String filename, String mime) throws CytomineException {
        AbstractImage abstractImage = new AbstractImage();
        abstractImage.set("filename", filename);
        abstractImage.set("path", filename);
        abstractImage.set("mime", mime);
        return this.saveModel(abstractImage);
    }

    public AbstractImage getAbstractImage(Long id) throws CytomineException {
        AbstractImage abstractImage = new AbstractImage();
        abstractImage.set("id", id);
        return this.fetchModel(abstractImage);
    }

    public ImageServers getAbstractImageServers(AbstractImage abstractImage) throws CytomineException {
        ImageServers imageServers = new ImageServers();
        imageServers.set("abstractimage", "" + abstractImage.getId());
        return this.fetchModel(imageServers);
    }

    public ImageInstance getImageInstance(Long id) throws CytomineException {
        ImageInstance image = new ImageInstance();
        image.set("id", id);
        return this.fetchModel(image);
    }

    public ImageServers getImageInstanceServers(ImageInstance image) throws CytomineException {
        AbstractImage abstractImage = new AbstractImage();
        abstractImage.set("id", image.get("baseImage"));
        return this.getAbstractImageServers(abstractImage);
    }

    public ImageInstanceCollection getImageInstances(Long idProject) throws CytomineException {
        ImageInstanceCollection image = new ImageInstanceCollection(this.offset, this.max);
        image.addFilter("project", idProject + "");
        return this.fetchCollection(image);
    }

    public ImageInstanceCollection getImageInstancesByOffsetWithMax(Long idProject, int offset, int max) throws CytomineException {
        ImageInstanceCollection image = new ImageInstanceCollection(offset, max);
        image.addFilter("project", idProject + "");
        image.addFilter("offset", offset + "");
        image.addFilter("max", max + "");
        return this.fetchCollection(image);
    }

    public ImageInstance addImageInstance(Long idAbstractImage, Long idProject) throws CytomineException {
        ImageInstance image = new ImageInstance();
        image.set("baseImage", idAbstractImage);
        image.set("project", idProject);
        return this.saveModel(image);
    }

    public void deleteImageInstance(Long idImageInstance) throws CytomineException {
        ImageInstance image = new ImageInstance();
        image.set("id", idImageInstance);
        this.deleteModel(image);
    }

    public Annotation getAnnotation(Long id) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("id", id);
        return this.fetchModel(annotation);
    }

    public AnnotationCollection getAnnotations() throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByProject(Long idProject) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("project", idProject + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByTermAndProject(Long idTerm, Long idProject) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        annotations.addFilter("project", idProject + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByTerm(Long idTerm) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByUser(Long idUser) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("user", idUser + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByOntology(Long idOntology) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("ontology", idOntology + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByImage(Long idImage) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("image", idImage + "");
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotations(Map<String, String> filters) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            annotations.addFilter(entry.getKey(), entry.getValue());
        }
        return this.fetchCollection(annotations);
    }

    public AnnotationCollection getAnnotationsByTermAndImage(Long idTerm, Long idImage) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        annotations.addFilter("imageinstance", idImage + "");
        return this.fetchCollection(annotations);
    }

    public Annotation addAnnotation(String locationWKT, Long image) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("location", locationWKT);
        annotation.set("image", image);
        annotation.set("name", "");
        return this.saveModel(annotation);
    }

    public Annotation addAnnotationWithTerms(String locationWKT, Long image, List<Long> terms) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("location", locationWKT);
        annotation.set("image", image);
        annotation.set("name", "");
        annotation.set("term", terms);
        return this.saveModel(annotation);
    }

    public Annotation addAnnotation(String locationWKT, Long image, Long project) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("location", locationWKT);
        annotation.set("image", image);
        annotation.set("project", project);
        annotation.set("name", "");
        return this.saveModel(annotation);
    }

    public Annotation editAnnotation(Long idAnnotation, String locationWKT) throws CytomineException {
        Annotation annotation = this.getAnnotation(idAnnotation);
        annotation.set("location", locationWKT);
        return this.updateModel(annotation);
    }

    public void deleteAnnotation(Long idAnnotation) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("id", idAnnotation);
        this.deleteModel(annotation);
    }

    public void simplifyAnnotation(Long idAnnotation, Long minPoint, Long maxPoint) throws CytomineException {
        String url = "/api/annotation/" + idAnnotation + "/simplify.json?minPoint=" + minPoint + "&maxPoint=" + maxPoint;
        this.doPut(url, "");
    }

    public Term getTerm(Long id) throws CytomineException {
        Term term = new Term();
        term.set("id", id);
        return this.fetchModel(term);
    }

    public TermCollection getTerms() throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        return this.fetchCollection(terms);
    }

    public TermCollection getTermsByOntology(Long idOntology) throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        terms.addFilter("ontology", idOntology + "");
        return this.fetchCollection(terms);
    }

    public TermCollection getTermsByAnnotation(Long idAnnotation) throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        terms.addFilter("annotation", idAnnotation + "");
        return this.fetchCollection(terms);
    }

    public Term addTerm(String name, String color, Long idOntology) throws CytomineException {
        Term term = new Term();
        term.set("name", name);
        term.set("color", color);
        term.set("ontology", idOntology);
        return this.saveModel(term);
    }

    public Term editTerm(Long idTerm, String name, String color, Long idOntology) throws CytomineException {
        Term term = this.getTerm(idTerm);
        term.set("name", name);
        term.set("color", color);
        term.set("ontology", idOntology);
        return this.updateModel(term);
    }

    public void deleteTerm(Long idTerm) throws CytomineException {
        Term term = new Term();
        term.set("id", idTerm);
        this.deleteModel(term);
    }

    public AnnotationTerm getAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm();
        annotationTerm.set("annotation", idAnnotation);
        annotationTerm.set("userannotation", idAnnotation);
        annotationTerm.set("term", idTerm);
        return this.fetchModel(annotationTerm);
    }

    public AnnotationTerm setAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        try {
            AnnotationTerm annotationTerm = new AnnotationTerm();
            annotationTerm.set("userannotation", idAnnotation);
            annotationTerm.set("annotationIdent", idAnnotation);
            annotationTerm.set("term", idTerm);
            AnnotationTerm model = annotationTerm;
            String clearBeforeURL = "/api/annotation/" + idAnnotation + "/term/" + idTerm + "/clearBefore.json";
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", clearBeforeURL, "", "application/json,*/*");
            client.connect(this.getHost() + clearBeforeURL);
            int code = client.post(model.toJSON());
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            model.setAttr((JSONObject)json.get((Object)((Model)model).getDomainName()));
            return model;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public AnnotationTerm addAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm();
        annotationTerm.set("userannotation", idAnnotation);
        annotationTerm.set("annotationIdent", idAnnotation);
        annotationTerm.set("term", idTerm);
        return this.saveModel(annotationTerm);
    }

    public AnnotationTerm addAnnotationTerm(Long idAnnotation, Long idTerm, Long idExpectedTerm, Long idUser, double rate) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm();
        annotationTerm.set("annotation", idAnnotation);
        annotationTerm.set("annotation", idAnnotation);
        annotationTerm.set("term", idTerm);
        annotationTerm.set("expectedTerm", idExpectedTerm);
        annotationTerm.set("user", idUser);
        annotationTerm.set("rate", rate);
        return this.saveModel(annotationTerm);
    }

    public void deleteAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm();
        annotationTerm.set("annotation", idAnnotation);
        annotationTerm.set("userannotation", idAnnotation);
        annotationTerm.set("term", idTerm);
        this.deleteModel(annotationTerm);
    }

    public User addUser(String username, String firstname, String lastname, String email, String password) throws CytomineException {
        User user = new User();
        user.set("username", username);
        user.set("firstname", firstname);
        user.set("lastname", lastname);
        user.set("email", email);
        user.set("password", password);
        return this.saveModel(user);
    }

    public void addUserFromLDAP(String username) throws CytomineException {
        this.doPost("/api/ldap/user.json?username=" + username, "");
    }

    public User getUser(Long id) throws CytomineException {
        User user = new User();
        user.set("id", id);
        return this.fetchModel(user);
    }

    public User getCurrentUser() throws CytomineException {
        User user = new User();
        user.set("current", "current");
        return this.fetchModel(user);
    }

    public User getUserByUsername(String username) throws CytomineException {
        User user = new User();
        user.set("username get", username);
        return this.fetchModel(user);
    }

    public void addACL(String domainClassName, Long domainIdent, Long idUser, String auth) throws CytomineException {
        this.doPost("/api/domain/" + domainClassName + "/" + domainIdent + "/user/" + idUser + ".json?auth=" + auth, "");
    }

    public void addUserProject(Long idUser, Long idProject) throws CytomineException {
        this.addUserProject(idUser, idProject, false);
    }

    public void addUserProject(Long idUser, Long idProject, boolean admin) throws CytomineException {
        this.doPost("/api/project/" + idProject + "/user/" + idUser + (admin ? "/admin" : "") + ".json", "");
    }

    public void deleteUserProject(Long idUser, Long idProject) throws CytomineException {
        this.deleteUserProject(idUser, idProject, false);
    }

    public void deleteUserProject(Long idUser, Long idProject, boolean admin) throws CytomineException {
        this.doDelete("/api/project/" + idProject + "/user/" + idUser + (admin ? "/admin" : "") + ".json");
    }

    public UserCollection getProjectUsers(Long idProject) throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        users.addFilter("project", idProject + "");
        return this.fetchCollection(users);
    }

    public UserCollection getProjectAdmins(Long idProject) throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        users.addFilter("project", idProject + "");
        users.addFilter("admin", "true");
        return this.fetchCollection(users);
    }

    public void doUserPosition(Long idImage, Long x, Long y, Long zoom) throws CytomineException {
        String data = "{image : " + idImage + ", lat : " + x + ", lon : " + y + ", zoom : " + zoom + "}";
        this.doPost("/api/imageinstance/" + idImage + "/position.json", data);
    }

    public void doUserPosition(Long idImage, Long zoom, Long bottomLeftX, Long bottomLeftY, Long bottomRightX, Long bottomRightY, Long topLeftX, Long topLeftY, Long topRightX, Long topRightY) throws CytomineException {
        String data = "{image : " + idImage + ", zoom : " + zoom + ", bottomLeftX : " + bottomLeftX + ", bottomLeftY : " + bottomLeftY + ", bottomRightX : " + bottomRightX + ", bottomRightY : " + bottomRightY + ", topLeftX : " + topLeftX + ", topLeftY : " + topLeftY + ", topRightX : " + topRightX + ", topRightY : " + topRightY + "}";
        this.doPost("/api/imageinstance/" + idImage + "/position.json", data);
    }

    public User getUser(String publicKey) throws CytomineException {
        User user = new User();
        user.addFilter("publicKey", publicKey);
        return this.fetchModel(user);
    }

    public UserCollection getUsers() throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        return this.fetchCollection(users);
    }

    public User getKeys(String publicKey) throws CytomineException {
        User user = new User();
        user.addFilter("publicKeyFilter", publicKey);
        return this.fetchModel(user);
    }

    public User getKeys(Long id) throws CytomineException {
        User user = new User();
        user.addFilter("id", id + "");
        user.addFilter("keys", "keys");
        return this.fetchModel(user);
    }

    public User getKeysByUsername(String username) throws CytomineException {
        User user = new User();
        user.addFilter("id", username + "");
        user.addFilter("keys", "keys");
        return this.fetchModel(user);
    }

    public UserJob getUserJob(Long id) throws CytomineException {
        UserJob user = new UserJob();
        user.set("id", id);
        return this.fetchModel(user);
    }

    public Job getJob(Long id) throws CytomineException {
        Job job = new Job();
        job.set("id", id);
        return this.fetchModel(job);
    }

    public Job editJob(Long id, Job newJob) throws CytomineException {
        Job job = new Job();
        job.setAttr(newJob.getAttr());
        return this.updateModel(job);
    }

    public Job changeStatus(Long id, int status, int progress) throws CytomineException {
        return this.changeStatus(id, status, progress, null);
    }

    public Job changeStatus(Long id, int status, int progress, String comment) throws CytomineException {
        Job job = this.getJob(id);
        job.set("progress", progress);
        job.set("status", status);
        job.set("statusComment", comment);
        return this.editJob(id, job);
    }

    public User addUserJob(Long idSoftware, Long idProject, Long idUserParent) throws CytomineException {
        return this.addUserJob(idSoftware, idUserParent, idProject, new Date(), null);
    }

    public User addUserJob(Long idSoftware, Long idUserParent, Long idProject, Date created, Long idJob) throws CytomineException {
        UserJob user = new UserJob();
        user.set("parent", idUserParent);
        user.set("software", idSoftware);
        user.set("project", idProject);
        user.set("job", idJob);
        user.set("created", created.getTime());
        user = this.saveModel(user);
        User userFinal = new User();
        userFinal.setAttr(user.getAttr());
        return userFinal;
    }

    public Software addSoftware(String name, String serviceName, String resultType, String executeCommand) throws CytomineException {
        Software software = new Software();
        software.set("name", name);
        software.set("serviceName", serviceName);
        software.set("resultName", resultType);
        software.set("executeCommand", executeCommand);
        return this.saveModel(software);
    }

    public void deleteSoftware(Long idSoftware) throws CytomineException {
        Software software = new Software();
        software.set("id", idSoftware);
        this.deleteModel(software);
    }

    public void unionAnnotation(Long idImage, Long idUser, Integer minIntersectionLength) throws CytomineException {
        AnnotationUnion annotation = new AnnotationUnion();
        annotation.addParams("idImage", idImage + "");
        annotation.addParams("idUser", idUser + "");
        annotation.addParams("minIntersectionLength", minIntersectionLength + "");
        this.updateModel(annotation);
    }

    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, String uri, String uriSortAttribut, String uriPrintAttribut) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, uri, uriSortAttribut, uriPrintAttribut, false);
    }

    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, String uri, String uriSortAttribut, String uriPrintAttribut, boolean setByServer) throws CytomineException {
        SoftwareParameter softwareParameter = new SoftwareParameter();
        softwareParameter.set("name", name);
        softwareParameter.set("type", type);
        softwareParameter.set("software", idSoftware);
        softwareParameter.set("defaultValue", defaultValue);
        softwareParameter.set("required", required);
        softwareParameter.set("index", index);
        softwareParameter.set("uri", uri);
        softwareParameter.set("uriPrintAttribut", uriPrintAttribut);
        softwareParameter.set("uriSortAttribut", uriSortAttribut);
        softwareParameter.set("setByServer", setByServer);
        return this.saveModel(softwareParameter);
    }

    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, null, null, null, false);
    }

    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, boolean setByServer) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, null, null, null, setByServer);
    }

    public SoftwareProject addSoftwareProject(Long idSoftware, Long idProject) throws CytomineException {
        SoftwareProject softwareProject = new SoftwareProject();
        softwareProject.set("software", idSoftware);
        softwareProject.set("project", idProject);
        return this.saveModel(softwareProject);
    }

    public SoftwareCollection getSoftwaresByProject(Long idProject) throws CytomineException {
        SoftwareCollection softwares = new SoftwareCollection(this.offset, this.max);
        softwares.addFilter("project", idProject + "");
        return this.fetchCollection(softwares);
    }

    public SoftwareCollection getSoftwares() throws CytomineException {
        SoftwareCollection softwares = new SoftwareCollection(this.offset, this.max);
        return this.fetchCollection(softwares);
    }

    public Software getSoftware(Long id) throws CytomineException {
        Software software = new Software();
        software.set("id", id);
        return this.fetchModel(software);
    }

    public ProcessingServer addProcessingServer(String url) throws CytomineException {
        ProcessingServer processingServer = new ProcessingServer();
        processingServer.set("url", url);
        return this.saveModel(processingServer);
    }

    public ImageFilter addImageFilter(String name, String baseUrl, String processingServer) throws CytomineException {
        ImageFilter imageFilter = new ImageFilter();
        imageFilter.set("name", name);
        imageFilter.set("baseUrl", baseUrl);
        imageFilter.set("processingServer", processingServer);
        return this.saveModel(imageFilter);
    }

    public JobData getJobData(Long id) throws CytomineException {
        JobData jobData = new JobData();
        jobData.set("id", id);
        return this.fetchModel(jobData);
    }

    public JobDataCollection getJobDatas() throws CytomineException {
        JobDataCollection jobDatas = new JobDataCollection(this.offset, this.max);
        return this.fetchCollection(jobDatas);
    }

    public JobDataCollection getJobDataByJob(Long idJob) throws CytomineException {
        JobDataCollection jobDatas = new JobDataCollection(this.offset, this.max);
        jobDatas.addFilter("job", idJob + "");
        return this.fetchCollection(jobDatas);
    }

    public JobData addJobData(String key, Long idJob, String filename) throws CytomineException {
        JobData jobData = new JobData();
        jobData.set("key", key);
        jobData.set("job", idJob);
        jobData.set("filename", filename);
        return this.saveModel(jobData);
    }

    public JobData editJobData(Long idJobData, String key, Long idJob, String filename) throws CytomineException {
        JobData jobData = this.getJobData(idJobData);
        jobData.set("key", key);
        jobData.set("job", idJob);
        jobData.set("filename", filename);
        return this.updateModel(jobData);
    }

    public void deleteJobData(Long idJobData) throws CytomineException {
        JobData jobData = new JobData();
        jobData.set("id", idJobData);
        this.deleteModel(jobData);
    }

    public void uploadJobData(Long idJobData, byte[] data) throws CytomineException {
        this.uploadFile("/api/jobdata/" + idJobData + "/upload", data);
    }

    public void downloadJobData(Long idJobData, String file) throws CytomineException {
        this.downloadFile("/api/jobdata/" + idJobData + "/download", file);
    }

    public void downloadAnnotation(Annotation annotation, String path) throws CytomineException {
        String url = annotation.getStr("url");
        this.downloadPicture(url, path);
    }

    public ReviewedAnnotationCollection getReviewedAnnotationsByTermAndImage(Long idTerm, Long idImage) throws CytomineException {
        ReviewedAnnotationCollection reviewed = new ReviewedAnnotationCollection(this.offset, this.max);
        reviewed.addFilter("term", idTerm + "");
        reviewed.addFilter("imageinstance", idImage + "");
        return this.fetchCollection(reviewed);
    }

    public ReviewedAnnotationCollection getReviewedAnnotationsByProject(Long idProject) throws CytomineException {
        ReviewedAnnotationCollection reviewed = new ReviewedAnnotationCollection(this.offset, this.max);
        reviewed.addFilter("project", idProject + "");
        return this.fetchCollection(reviewed);
    }

    public Property getDomainProperty(Long id, Long domainIdent, String domain) throws CytomineException {
        Property property = new Property();
        property.set("id", id);
        property.set("domainIdent", domainIdent);
        property.set("domain", domain);
        return this.fetchModel(property);
    }

    public PropertyCollection getDomainProperties(String domain, Long domainIdent) throws CytomineException {
        PropertyCollection properties = new PropertyCollection(this.offset, this.max);
        properties.addFilter(domain, domainIdent + "");
        properties.addFilter("domainClassName", domain + "");
        properties.addFilter("domainIdent", domainIdent + "");
        return this.fetchCollection(properties);
    }

    public Property getPropertyByDomainAndKey(String domain, Long domainIdent, String key) throws CytomineException {
        Property property = new Property();
        property.set("domainIdent", domainIdent);
        property.set("domain", domain);
        property.set("key", key);
        return this.fetchModel(property);
    }

    public Property addDomainProperties(String domain, Long domainIdent, String key, String value) throws CytomineException {
        Property property = new Property();
        property.set("domain", domain);
        property.set("domainIdent", domainIdent);
        property.set("key", key);
        property.set("value", value);
        return this.saveModel(property);
    }

    public Property editDomainProperty(String domain, Long id, Long domainIdent, String key, String value) throws CytomineException {
        Property property = this.getDomainProperty(id, domainIdent, domain);
        property.set("domain", domain);
        property.set("domainIdent", domainIdent);
        property.set("key", key);
        property.set("value", value);
        return this.updateModel(property);
    }

    public void deleteDomainProperty(String domain, Long id, Long domainIdent) throws CytomineException {
        Property property = this.getDomainProperty(id, domainIdent, domain);
        property.set("id", id);
        property.set("domain", domain);
        property.set("domainIdent", domainIdent);
        this.deleteModel(property);
    }

    public PropertyCollection getKeysForDomain(String domain, String nameIdDomain, Long idDomain) throws CytomineException {
        PropertyCollection properties = new PropertyCollection(this.offset, this.max);
        properties.addFilter(domain, "");
        properties.addFilter("idDomain", idDomain + "");
        properties.addFilter("nameIdDomain", nameIdDomain);
        return this.fetchCollection(properties);
    }

    public SearchCollection getSearch(String keywords, Operator operator, Filter filter) throws CytomineException {
        return this.getSearch(keywords, operator, filter, null);
    }

    public SearchCollection getSearch(String keywords, Operator operator, Filter filter, List<Long> idProjects) throws CytomineException {
        SearchCollection search = new SearchCollection(this.offset, this.max);
        if (operator == null) {
            operator = Operator.OR;
        }
        if (filter == null) {
            filter = Filter.ALL;
        }
        search.addFilter("keywords", this.buildEncode(keywords));
        search.addFilter("operator", this.buildEncode((Object)((Object)operator) + ""));
        search.addFilter("filter", this.buildEncode((Object)((Object)filter) + ""));
        if (idProjects != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < idProjects.size(); ++i) {
                list.add(idProjects.get(i) + "");
            }
            search.addFilter("projects", Cytomine.join(list, ", "));
        }
        return this.fetchCollection(search);
    }

    public static String join(ArrayList s, String delimiter) {
        if (s.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public Storage getStorage(Long id) throws CytomineException {
        Storage storage = new Storage();
        storage.set("id", id);
        return this.fetchModel(storage);
    }

    public StorageCollection getStorages() throws CytomineException {
        StorageCollection storages = new StorageCollection(this.offset, this.max);
        return this.fetchCollection(storages);
    }

    public StorageAbstractImage addStorageAbstractImage(Long idStorage, Long idAbstractImage) throws CytomineException {
        StorageAbstractImage sai = new StorageAbstractImage();
        sai.set("storage", idStorage);
        sai.set("abstractimage", idAbstractImage);
        return this.saveModel(sai);
    }

    public String resetPassword(Long idUser, String newPassword) throws CytomineException {
        return this.doPut("/api/user/" + idUser + "/password.json", "{password: " + newPassword + "}");
    }

    public AbstractImage editAbstractImage(Long idAbstractImage, String originalFilename) throws CytomineException {
        AbstractImage image = this.getAbstractImage(idAbstractImage);
        image.set("originalFilename", originalFilename);
        return this.updateModel(image);
    }

    public ImageGroup addImageGroup(Long idProject) throws CytomineException {
        ImageGroup imageGroup = new ImageGroup();
        imageGroup.set("project", idProject + "");
        return this.saveModel(imageGroup);
    }

    public ImageSequence addImageSequence(Long idImageGroup, Long idImage, Integer zStack, Integer slice, Integer time, Integer channel) throws CytomineException {
        ImageSequence imageSequence = new ImageSequence();
        imageSequence.set("imageGroup", idImageGroup + "");
        imageSequence.set("image", idImage + "");
        imageSequence.set("zStack", zStack + "");
        imageSequence.set("slice", slice + "");
        imageSequence.set("time", time + "");
        imageSequence.set("channel", channel + "");
        return this.saveModel(imageSequence);
    }

    public ImageGroupHDF5 getImageGroupHDF5(Long id) throws CytomineException {
        ImageGroupHDF5 groupHDF5 = new ImageGroupHDF5();
        groupHDF5.set("id", id);
        return this.fetchModel(groupHDF5);
    }

    public ImageGroupHDF5 editImageGroupHDF5(Long id, Integer status, Integer progress) throws CytomineException {
        ImageGroupHDF5 groupHDF5 = this.getImageGroupHDF5(id);
        groupHDF5.set("status", status);
        groupHDF5.set("progress", progress);
        return this.updateModel(groupHDF5);
    }

    public Description getDescription(Long domainIdent, String domainClassName) throws CytomineException {
        Description description = new Description();
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        return this.fetchModel(description);
    }

    public Description addDescription(Long domainIdent, String domainClassName, String text) throws CytomineException {
        Description description = new Description();
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        description.set("data", text);
        return this.saveModel(description);
    }

    public Description editDescription(Long domainIdent, String domainClassName, String text) throws CytomineException {
        Description description = this.getDescription(domainIdent, domainClassName);
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        description.set("data", text);
        return this.updateModel(description);
    }

    public void deleteDescription(Long domainIdent, String domainClassName) throws CytomineException {
        Description description = this.getDescription(domainIdent, domainClassName);
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        this.deleteModel(description);
    }

    public RoleCollection getRoles() throws CytomineException {
        RoleCollection role = new RoleCollection(this.offset, this.max);
        return this.fetchCollection(role);
    }

    public Map<String, Long> getRoleMap() throws CytomineException {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        RoleCollection roles = this.getRoles();
        for (int i = 0; i < roles.size(); ++i) {
            map.put(roles.get(i).getStr("authority"), roles.get(i).getLong("id"));
        }
        return map;
    }

    public Role addRole(Long idUser, Long idRole) throws CytomineException {
        Role role = new Role();
        role.set("user", idUser + "");
        role.set("role", idRole + "");
        role.addFilter("user", idUser + "");
        return this.saveModel(role);
    }

    public void deleteRole(Long idUser, Long idRole) throws CytomineException {
        Role role = new Role();
        role.set("user", idUser + "");
        role.set("role", idRole + "");
        role.addFilter("user", idUser + "");
        role.addFilter("role", idRole + "");
        this.deleteModel(role);
    }

    public JobTemplate addJobTemplate(String name, Long iProject, Long idSoftware) throws CytomineException {
        JobTemplate job = new JobTemplate();
        job.set("name", name + "");
        job.set("project", iProject + "");
        job.set("software", idSoftware + "");
        return this.saveModel(job);
    }

    public JobParameter addJobParameter(Long job, Long softwareParameter, String value) throws CytomineException {
        JobParameter jobParam = new JobParameter();
        jobParam.set("job", job + "");
        jobParam.set("softwareParameter", softwareParameter + "");
        jobParam.set("value", value + "");
        return this.saveModel(jobParam);
    }

    public AbstractImage addNewImage(Long idUploadedFile, String path, String filename, String mimeType) throws CytomineException {
        return this.addNewImage(idUploadedFile, path, filename, null, mimeType);
    }

    public AbstractImage addNewImage(Long idUploadedFile, String path, String filename, String originalFilename, String mimeType) throws CytomineException {
        AbstractImage image = new AbstractImage();
        image.set("path", path);
        image.set("filename", filename);
        if (originalFilename != null) {
            image.set("originalFilename", originalFilename);
        }
        image.set("mimeType", mimeType);
        image.addFilter("uploadedFile", idUploadedFile + "");
        return this.saveModel(image);
    }

    public UploadedFile addUploadedFile(String originalFilename, String realFilename, String path, Long size, String ext, String contentType, List idProjects, List idStorages, Long idUser, Long idParent) throws CytomineException {
        return this.addUploadedFile(originalFilename, realFilename, path, size, ext, contentType, idProjects, idStorages, idUser, -1L, idParent);
    }

    public UploadedFile addUploadedFile(String originalFilename, String realFilename, String path, Long size, String ext, String contentType, List idProjects, List idStorages, Long idUser, Long status, Long idParent) throws CytomineException {
        UploadedFile uploadedFile = new UploadedFile();
        uploadedFile.set("originalFilename", originalFilename);
        uploadedFile.set("filename", realFilename);
        uploadedFile.set("path", path);
        uploadedFile.set("size", size);
        uploadedFile.set("ext", ext);
        uploadedFile.set("contentType", contentType);
        uploadedFile.set("path", path);
        uploadedFile.set("projects", idProjects);
        uploadedFile.set("storages", idStorages);
        uploadedFile.set("user", idUser);
        uploadedFile.set("parent", idParent);
        if (status != -1L) {
            uploadedFile.set("status", status);
        }
        return this.saveModel(uploadedFile);
    }

    public UploadedFileCollection getUploadedFiles(boolean deleted) throws CytomineException {
        UploadedFileCollection files = new UploadedFileCollection(this.offset, this.max);
        files.addParams("deleted", "" + deleted);
        return this.fetchCollection(files);
    }

    public void deleteUploadedFile(Long idUploadedFile) throws CytomineException {
        UploadedFile uploadedFile = new UploadedFile();
        uploadedFile.set("id", idUploadedFile);
        this.deleteModel(uploadedFile);
    }

    public UploadedFile editUploadedFile(Long id, int status, boolean converted, Long idParent) throws CytomineException {
        UploadedFile uploadedFile = this.getUploadedFile(id);
        uploadedFile.set("status", status);
        uploadedFile.set("converted", converted);
        uploadedFile.set("parent", idParent);
        return this.updateModel(uploadedFile);
    }

    public UploadedFile editUploadedFile(Long id, int status, boolean converted) throws CytomineException {
        UploadedFile uploadedFile = this.getUploadedFile(id);
        uploadedFile.set("status", status);
        uploadedFile.set("converted", converted);
        return this.updateModel(uploadedFile);
    }

    public UploadedFile editUploadedFile(Long id, int status) throws CytomineException {
        UploadedFile uploadedFile = this.getUploadedFile(id);
        uploadedFile.set("status", status);
        return this.updateModel(uploadedFile);
    }

    public UploadedFile getUploadedFile(Long id) throws CytomineException {
        UploadedFile uploadedFile = new UploadedFile();
        uploadedFile.set("id", id);
        return this.fetchModel(uploadedFile);
    }

    public UploadedFile getUploadedFileByAbstractImage(Long idAbstractImage) throws CytomineException {
        UploadedFile uploadedFile = new UploadedFile();
        uploadedFile.set("baseImage", idAbstractImage);
        return this.fetchModel(uploadedFile);
    }

    public String clearAbstractImageProperties(Long idImage) throws CytomineException {
        return this.doPost("/api/abstractimage/" + idImage + "/properties/clear.json", "");
    }

    public String populateAbstractImageProperties(Long idImage) throws CytomineException {
        return this.doPost("/api/abstractimage/" + idImage + "/properties/populate.json", "");
    }

    public String extractUsefulAbstractImageProperties(Long idImage) throws CytomineException {
        return this.doPost("/api/abstractimage/" + idImage + "/properties/extract.json", "");
    }

    public String getSimplified(String wkt, Long min, Long max) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("wkt", wkt);
        return this.doPost("/api/simplify.json?minPoint=" + min + "&maxPoint=" + max, annotation.toJSON());
    }

    public void uploadImage(String file, String cytomineHost) throws CytomineException {
        this.uploadImage(file, null, null, cytomineHost);
    }

    public AttachedFile uploadAttachedFile(String file, String domainClassName, Long domainIdent) throws CytomineException {
        String url = "/api/attachedfile.json?domainClassName=" + domainClassName + "&domainIdent=" + domainIdent;
        JSONObject json = this.uploadFile(url, file);
        AttachedFile attachedFile = new AttachedFile();
        attachedFile.setAttr(json);
        return attachedFile;
    }

    public JSONObject uploadFile(String url, String file) throws CytomineException {
        try {
            HttpClient client = null;
            MultipartEntity entity = new MultipartEntity();
            entity.addPart("files[]", (ContentBody)new FileBody(new File(file)));
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", url, entity.getContentType().getValue(), "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.post(entity);
            String response = client.getResponseData();
            log.debug((Object)("response=" + response));
            client.disconnect();
            return this.createJSONResponse(code, response);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public JSONArray uploadImage(String file, Long idProject, Long idStorage, String cytomineHost) throws CytomineException {
        return this.uploadImage(file, idProject, idStorage, cytomineHost, null, false);
    }

    public JSONArray uploadImage(String file, Long idProject, Long idStorage, String cytomineHost, Map<String, String> properties, boolean synchrone) throws CytomineException {
        try {
            HttpClient client = null;
            String projectParam = "";
            if (idProject != null && idProject != 0L) {
                projectParam = "&idProject=" + idProject;
            }
            String url = "/upload?idStorage=" + idStorage + "&cytomine=" + cytomineHost + projectParam;
            if (properties != null && properties.size() > 0) {
                ArrayList<String> keys = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    keys.add(entry.getKey());
                    values.add(entry.getValue());
                }
                url = url + "&keys=" + StringUtils.join(keys, (String)",") + "&values=" + StringUtils.join(values, (String)",");
            }
            if (synchrone) {
                url = url + "&sync=" + true;
            }
            MultipartEntity entity = new MultipartEntity();
            if (idProject != null && idStorage != null) {
                entity.addPart("idProject", (ContentBody)new StringBody(idProject + ""));
                entity.addPart("idStorage", (ContentBody)new StringBody(idStorage + ""));
            }
            entity.addPart("files[]", (ContentBody)new FileBody(new File(file)));
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", url, entity.getContentType().getValue(), "application/json,*/*");
            client.connect(this.getHost() + url);
            int code = client.post(entity);
            String response = client.getResponseData();
            log.debug((Object)("response=" + response));
            client.disconnect();
            return this.createJSONArrayResponse(code, response);
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public void indexToRetrieval(Long id, Long container, String url) throws CytomineException {
        String data = "{id : " + id + ", container : " + container + ", url : '" + url + "'}";
        this.doPost("/retrieval-web/api/resource.json", data);
    }

    public void executeJob(Long idJob) throws CytomineException {
        this.doPost("/api/job/" + idJob + "/execute.json", "");
    }

    public JSONObject getSimilaritiesByRetrieval(Long idAnnotation) throws CytomineException {
        String response = this.doGet("/api/annotation/" + idAnnotation + "/retrieval.json");
        return (JSONObject)JSONValue.parse((String)response);
    }

    public AmqpQueueCollection getAmqpQueue() throws CytomineException {
        AmqpQueueCollection queues = new AmqpQueueCollection(this.offset, this.max);
        return this.fetchCollection(queues);
    }

    public DeleteCommandCollection getDeleteCommandByDomainAndAfterDate(String domain, Long timestamp) throws CytomineException {
        DeleteCommandCollection commands = new DeleteCommandCollection(this.offset, this.max);
        commands.addParams("domain", "uploadedFile");
        commands.addParams("after", timestamp.toString());
        return this.fetchCollection(commands);
    }

    public static enum Operator {
        OR,
        AND;

    }

    public static enum Filter {
        ALL,
        PROJECT,
        ANNOTATION,
        IMAGE,
        ABSTRACTIMAGE;

    }

    public static class UploadStatus {
        public static final int UPLOADED = 0;
        public static final int CONVERTED = 1;
        public static final int DEPLOYED = 2;
        public static final int ERROR_FORMAT = 3;
        public static final int ERROR_CONVERT = 4;
        public static final int UNCOMPRESSED = 5;
        public static final int TO_DEPLOY = 6;
    }

    public static class JobStatus {
        public static final int NOTLAUNCH = 0;
        public static final int INQUEUE = 1;
        public static final int RUNNING = 2;
        public static final int SUCCESS = 3;
        public static final int FAILED = 4;
        public static final int INDETERMINATE = 5;
        public static final int WAIT = 6;
    }
}

