/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.models.Model;
import java.util.Map;

public class Property
extends Model {
    @Override
    public String getDomainName() {
        return "property";
    }

    @Override
    public String toURL() {
        Long id = (Long)this.get("id");
        Long domainIdent = (Long)this.get("domainIdent");
        String domain = (String)this.get("domain");
        String key = (String)this.get("key");
        String value = (String)this.get("value");
        if (id != null && domainIdent != null && domain != null) {
            return this.getJSONResourceURL(id, domainIdent, domain);
        }
        if (domainIdent != null && domain != null && key != null && value == null) {
            return this.getJSONResourceURL(domainIdent, domain, key);
        }
        if (domainIdent != null && domain != null) {
            return this.getJSONResourceURL(domainIdent, domain);
        }
        return this.getJSONResourceURL();
    }

    public String getJSONResourceURL(Long id, Long domainIdent, String domain) {
        String domainFix = domain;
        if (domain.contains(".")) {
            domainFix = "domain/" + domain;
        }
        if (this.params.isEmpty()) {
            return "/api/" + domainFix + "/" + domainIdent + "/property/" + id + ".json";
        }
        String base = "/api/" + domainFix + "/" + domainIdent + "/property/" + id + ".json?";
        for (Map.Entry param : this.params.entrySet()) {
            base = base + (String)param.getKey() + "=" + (String)param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public String getJSONResourceURL(Long domainIdent, String domain) {
        String domainFix = domain;
        if (domain.contains(".")) {
            domainFix = "domain/" + domain;
        }
        if (this.params.isEmpty()) {
            return "/api/" + domainFix + "/" + domainIdent + "/property.json";
        }
        String base = "/api/" + domainFix + "/" + domainIdent + "/property.json?";
        for (Map.Entry param : this.params.entrySet()) {
            base = base + (String)param.getKey() + "=" + (String)param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }

    public String getJSONResourceURL(Long domainIdent, String domain, String key) {
        String domainFix = domain;
        if (domain.contains(".")) {
            domainFix = "domain/" + domain;
        }
        String base = "/api/" + domainFix + "/" + domainIdent + "/key/" + key + "/property.json";
        return base;
    }
}

