/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.importer;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TileImporter;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.Tile2DKey;
import org.bioimageanalysis.icy.icytomine.core.view.TileResult;

public class TileGridImporter {
    private Image imageInformation;
    private Rectangle grid;
    private int resolution;
    private Dimension tileSize;
    private Set<TileImportationListener> tileImportationListeners;
    private Set<TileImportationEndListener> tileImportationEndListeners;
    private ExecutorService threadPool;
    private ExecutorService futureResultsHandlingService;

    public TileGridImporter(Image imageInformation, int resolution, Rectangle grid) {
        this.imageInformation = imageInformation;
        this.resolution = resolution;
        this.grid = grid;
        this.tileSize = imageInformation.getTileSize().get();
        this.tileImportationListeners = new HashSet<TileImportationListener>();
        this.tileImportationEndListeners = new HashSet<TileImportationEndListener>();
    }

    public void requestTileGrid() {
        int numberOfTiles = this.getNumberOfTiles();
        int numProcessors = Math.min(numberOfTiles, Runtime.getRuntime().availableProcessors());
        this.threadPool = Executors.newFixedThreadPool(numProcessors);
        ExecutorCompletionService<TileResult> completionService = new ExecutorCompletionService<TileResult>(this.threadPool);
        List<Future<TileResult>> futureResults = this.submitTileTasks(completionService);
        this.startHandlingFutureResults(completionService, futureResults);
    }

    private List<Future<TileResult>> submitTileTasks(CompletionService<TileResult> completionService) {
        LinkedList<Future<TileResult>> futureResults = new LinkedList<Future<TileResult>>();
        for (int x = 0; !Thread.interrupted() && x < this.grid.width; ++x) {
            for (int y = 0; !Thread.interrupted() && y < this.grid.height; ++y) {
                Tile2DKey key = new Tile2DKey(this.imageInformation, this.resolution, this.grid.x + x, this.grid.y + y);
                futureResults.add(completionService.submit(this.getTileTask(key)));
            }
        }
        return futureResults;
    }

    private void startHandlingFutureResults(CompletionService<TileResult> completionService, List<Future<TileResult>> futureResults) {
        this.futureResultsHandlingService = Executors.newSingleThreadExecutor();
        this.futureResultsHandlingService.submit(() -> {
            int tile;
            CompletableFuture<Void> endFuture = new CompletableFuture<Void>();
            int numberOfTiles = futureResults.size();
            for (tile = 0; !Thread.interrupted() && tile < numberOfTiles; ++tile) {
                try {
                    Future futureResult = completionService.take();
                    TileResult result = (TileResult)futureResult.get();
                    CompletableFuture<TileResult> returnFuture = new CompletableFuture<TileResult>();
                    returnFuture.complete(result);
                    this.notifyTileImportationListeners(returnFuture);
                    continue;
                }
                catch (InterruptedException e) {
                    futureResults.forEach(f -> f.cancel(true));
                    break;
                }
                catch (ExecutionException e) {
                    futureResults.forEach(f -> f.cancel(true));
                    endFuture.completeExceptionally(e);
                    break;
                }
            }
            if (Thread.interrupted() || tile < numberOfTiles) {
                endFuture.cancel(true);
            }
            if (!endFuture.isDone()) {
                endFuture.complete(null);
            }
            this.notifyTileImportationEndListeners(endFuture);
            this.threadPool.shutdownNow();
            this.futureResultsHandlingService.shutdown();
        });
    }

    public int getNumberOfTiles() {
        return this.grid.width * this.grid.height;
    }

    private Callable<TileResult> getTileTask(Tile2DKey key) {
        return () -> {
            TileImporter importer = new TileImporter(key.getImage(), (int)key.getResolution(), key.getX(), key.getY());
            BufferedImage tileImage = importer.getTile();
            return new TileResult(key, tileImage);
        };
    }

    private void notifyTileImportationListeners(CompletableFuture<TileResult> returnFuture) {
        this.tileImportationListeners.forEach(l -> l.tileImported(returnFuture));
    }

    private void notifyTileImportationEndListeners(CompletableFuture<Void> endFuture) {
        this.tileImportationEndListeners.forEach(l -> l.importationFinished(endFuture));
    }

    public void addTileImportationListener(TileImportationListener listener) {
        this.tileImportationListeners.add(listener);
    }

    public void removeTileImportationListener(TileImportationListener listener) {
        this.tileImportationListeners.remove(listener);
    }

    public void addTileImportationEndListener(TileImportationEndListener listener) {
        this.tileImportationEndListeners.add(listener);
    }

    public void removeTileImportationEndListener(TileImportationEndListener listener) {
        this.tileImportationEndListeners.remove(listener);
    }

    public void cancelImportation() throws RuntimeException, InterruptedException {
        this.futureResultsHandlingService.shutdownNow();
        if (!this.futureResultsHandlingService.awaitTermination(5L, TimeUnit.SECONDS)) {
            throw new RuntimeException("Could not interrupt all threads");
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public Dimension getTileSize() {
        return this.tileSize;
    }

    public static interface TileImportationEndListener {
        public void importationFinished(Future<Void> var1);
    }

    public static interface TileImportationListener {
        public void tileImported(Future<TileResult> var1);
    }
}

