/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.view;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.Tile2DKey;
import org.bioimageanalysis.icy.icytomine.core.view.ViewListener;
import org.bioimageanalysis.icy.icytomine.core.view.ViewTileCache;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.ViewProvider;

public class CachedImageView
implements ViewTileCache.ViewTileLoadListener {
    private Image imageInformation;
    private BufferedImage currentView;
    private ViewTileCache tileCache;
    private Set<ViewListener> viewListeners;
    private Set<ViewProvider.ViewProcessListener> viewProcessListeners;
    private double targetResolution;
    private long requestedResolution;
    private Rectangle2D imageBoundsAtZeroResolution;
    private Rectangle2D viewBoundsAtZeroResolution;
    private Rectangle2D viewBoundsAtTargetResolution;
    private Rectangle2D constrainedViewBoundsAtZeroResolution;
    private Rectangle2D constrainedViewBoundsAtRequestedResolution;
    private Rectangle tilesToRequest;
    private Dimension2D tileSizeAtRequestedResolution;
    private Dimension2D tileSizeAtTargetResolution;
    private BufferedImage lowResImage;
    private BufferedImage previousView;
    private double previousResolution;
    private Rectangle2D previousViewBoundsAtTargetResolution;

    public CachedImageView(Image imageInformation) {
        this.imageInformation = imageInformation;
        this.targetResolution = 0.0;
        this.viewBoundsAtZeroResolution = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.viewBoundsAtTargetResolution = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        this.previousViewBoundsAtTargetResolution = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        this.constrainedViewBoundsAtZeroResolution = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.constrainedViewBoundsAtRequestedResolution = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        this.startCache();
        this.initializeListeners();
        this.computeImageBoundsAtZeroResolution();
        this.loadLowResImage();
    }

    private void startCache() {
        this.tileCache = new ViewTileCache(this.imageInformation);
        this.tileCache.addTileLoadedListener(this);
    }

    private void initializeListeners() {
        this.viewListeners = Collections.synchronizedSet(new HashSet());
        this.viewProcessListeners = Collections.synchronizedSet(new HashSet());
    }

    private void computeImageBoundsAtZeroResolution() {
        this.imageBoundsAtZeroResolution = new Rectangle(this.imageInformation.getSize().get());
    }

    private void loadLowResImage() {
        try {
            this.lowResImage = this.imageInformation.getThumbnail(512);
        }
        catch (CytomineClientException e) {
            this.lowResImage = new BufferedImage(512, 512, 2);
            System.out.println("No thumbnail available...");
        }
    }

    public Image getImageInformation() {
        return this.imageInformation;
    }

    public void addViewListener(ViewListener listener) {
        this.viewListeners.add(listener);
    }

    public void addViewProcessListener(ViewProvider.ViewProcessListener listener) {
        this.viewProcessListeners.add(listener);
    }

    public synchronized BufferedImage getView(Point2D targetPositionAt0Resolution, Dimension canvasSize, double targetResolution) {
        Rectangle2D newViewBoundsAtZeroResolution = this.createViewBoundsAtZeroResolution(targetPositionAt0Resolution, canvasSize, targetResolution);
        if (this.isNewRequest(newViewBoundsAtZeroResolution, targetResolution)) {
            this.tileCache.cancelPreviousRequest();
            this.notifyProcessListeners(true);
            this.setPreviousViewValues();
            this.setCurrentParameters(newViewBoundsAtZeroResolution, canvasSize, targetResolution);
            this.requestView();
        }
        return this.currentView;
    }

    private Rectangle2D createViewBoundsAtZeroResolution(Point2D viewPositionAt0Resolution, Dimension canvasSize, double targetResolution) {
        Dimension2D canvasSizeAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(canvasSize, targetResolution, 0.0);
        return new Rectangle2D.Double(viewPositionAt0Resolution.getX(), viewPositionAt0Resolution.getY(), canvasSizeAtZeroResolution.getWidth(), canvasSizeAtZeroResolution.getHeight());
    }

    private boolean isNewRequest(Rectangle2D newViewBoundsAtZeroResolution, double newResolution) {
        return !newViewBoundsAtZeroResolution.equals(this.viewBoundsAtZeroResolution) || newResolution != this.targetResolution;
    }

    private void notifyProcessListeners(boolean isProcessing) {
        this.viewProcessListeners.forEach(l -> l.onViewProcessEvent(isProcessing));
    }

    private void setPreviousViewValues() {
        this.previousResolution = this.targetResolution;
        this.previousViewBoundsAtTargetResolution.setFrame(this.viewBoundsAtTargetResolution);
        this.previousView = this.currentView;
    }

    private void setCurrentParameters(Rectangle2D newViewBoundsAtZeroResolution, Dimension canvasSize, double targetResolution) {
        this.targetResolution = targetResolution;
        this.viewBoundsAtZeroResolution.setRect(newViewBoundsAtZeroResolution);
        Point2D viewPositionAtTargetResolution = MagnitudeResolutionConverter.convertPoint2D(new Point2D.Double(newViewBoundsAtZeroResolution.getX(), newViewBoundsAtZeroResolution.getY()), 0.0, targetResolution);
        this.viewBoundsAtTargetResolution.setFrame(viewPositionAtTargetResolution, canvasSize);
    }

    private void requestView() {
        this.computeViewRequestParameters();
        this.initializeCurrentView();
        this.requestTiles();
    }

    private void computeViewRequestParameters() {
        this.computeRequestedResolution();
        this.computeRequestedParameters();
    }

    private void computeRequestedResolution() {
        this.requestedResolution = Math.min(Math.max(0L, (long)this.targetResolution), this.imageInformation.getDepth().get());
    }

    private void computeRequestedParameters() {
        this.computeConstrainedParameters();
        this.computeTileRequestParameters();
    }

    private void computeConstrainedParameters() {
        this.constrainedViewBoundsAtZeroResolution.setRect(this.intersectRectangles(this.imageBoundsAtZeroResolution, this.viewBoundsAtZeroResolution));
        this.constrainedViewBoundsAtRequestedResolution = MagnitudeResolutionConverter.convertRectangle2D(this.constrainedViewBoundsAtZeroResolution, 0.0, this.requestedResolution);
    }

    private Rectangle2D intersectRectangles(Rectangle2D rect1, Rectangle2D rect2) {
        double maxStartX = Math.max(rect1.getX(), rect2.getX());
        double maxStartY = Math.max(rect1.getY(), rect2.getY());
        double minEndX = Math.min(rect1.getMaxX(), rect2.getMaxX());
        double minEndY = Math.min(rect1.getMaxY(), rect2.getMaxY());
        double width = 0.0;
        double height = 0.0;
        if (minEndX > maxStartX) {
            width = minEndX - maxStartX;
        }
        if (minEndY > maxStartY) {
            height = minEndY - maxStartY;
        }
        return new Rectangle2D.Double(maxStartX, maxStartY, width, height);
    }

    private void computeTileRequestParameters() {
        this.computeTileSize();
        int x = Math.max(0, (int)(this.constrainedViewBoundsAtRequestedResolution.getX() / this.tileSizeAtRequestedResolution.getWidth()));
        int y = Math.max(0, (int)(this.constrainedViewBoundsAtRequestedResolution.getY() / this.tileSizeAtRequestedResolution.getHeight()));
        int maxX = this.constrainedViewBoundsAtRequestedResolution.getWidth() > 0.0 ? this.ceilDiv((int)this.constrainedViewBoundsAtRequestedResolution.getMaxX(), (int)this.tileSizeAtRequestedResolution.getWidth()) : 0;
        int maxY = this.constrainedViewBoundsAtRequestedResolution.getHeight() > 0.0 ? this.ceilDiv((int)this.constrainedViewBoundsAtRequestedResolution.getMaxY(), (int)this.tileSizeAtRequestedResolution.getHeight()) : 0;
        this.tilesToRequest = new Rectangle(x, y, Math.max(0, maxX - x), Math.max(0, maxY - y));
    }

    private void computeTileSize() {
        this.tileSizeAtRequestedResolution = this.imageInformation.getTileSize().get();
        this.tileSizeAtTargetResolution = MagnitudeResolutionConverter.convertDimension2D(this.tileSizeAtRequestedResolution, this.requestedResolution, this.targetResolution);
    }

    private int ceilDiv(int a, int b) {
        return a / b + (a % b == 0 ? 0 : 1);
    }

    private void initializeCurrentView() {
        this.currentView = new BufferedImage((int)this.viewBoundsAtTargetResolution.getWidth(), (int)this.viewBoundsAtTargetResolution.getHeight(), 2);
        this.paintLowResolutionViewInCurrentView();
        this.paintPreviousViewInCurrentView();
        this.notifyTileLoaded();
    }

    private void paintLowResolutionViewInCurrentView() {
        Graphics2D painter = this.currentView.createGraphics();
        Dimension2D imageSizeAtTargetResolution = this.getImageSizeAtTargetResolution();
        painter.drawImage(this.lowResImage, (int)(-this.viewBoundsAtTargetResolution.getX()), (int)(-this.viewBoundsAtTargetResolution.getY()), (int)imageSizeAtTargetResolution.getWidth(), (int)imageSizeAtTargetResolution.getHeight(), null);
        painter.dispose();
    }

    private void paintPreviousViewInCurrentView() {
    }

    private Dimension2D getImageSizeAtTargetResolution() {
        return MagnitudeResolutionConverter.convertDimension2D(new Dimension((int)this.imageBoundsAtZeroResolution.getWidth(), (int)this.imageBoundsAtZeroResolution.getHeight()), 0.0, this.targetResolution);
    }

    private void requestTiles() {
        int i = this.tilesToRequest.x;
        while ((double)i < this.tilesToRequest.getMaxX()) {
            int j = this.tilesToRequest.y;
            while ((double)j < this.tilesToRequest.getMaxY()) {
                this.tileCache.requestTile(this.requestedResolution, i, j);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void tileLoaded(Tile2DKey tileKey, BufferedImage tileImage) {
        Point position = this.getTilePositionInView(tileKey);
        this.drawTileInCurrentView(position, tileImage);
        this.notifyTileLoaded();
    }

    private Point getTilePositionInView(Tile2DKey tileKey) {
        Point tilePositionAtTargetResolution = this.getTilePositonAtTargetResolution(tileKey);
        return new Point((int)((double)tilePositionAtTargetResolution.x - this.viewBoundsAtTargetResolution.getX()), (int)((double)tilePositionAtTargetResolution.y - this.viewBoundsAtTargetResolution.getY()));
    }

    private Point getTilePositonAtTargetResolution(Tile2DKey tileKey) {
        int x = (int)((double)tileKey.getX() * this.tileSizeAtTargetResolution.getWidth());
        int y = (int)((double)tileKey.getY() * this.tileSizeAtTargetResolution.getHeight());
        return new Point(x, y);
    }

    private void drawTileInCurrentView(Point position, BufferedImage tileImage) {
        Graphics2D g = this.currentView.createGraphics();
        Dimension2D tileSize = this.getTileSize(new Dimension(tileImage.getWidth(), tileImage.getHeight()));
        g.drawImage(tileImage, position.x, position.y, (int)Math.ceil(tileSize.getWidth()), (int)Math.ceil(tileSize.getHeight()), null);
        g.dispose();
    }

    private Dimension2D getTileSize(Dimension tileImageSize) {
        if (this.tileSizeAtRequestedResolution.equals(tileImageSize)) {
            return this.tileSizeAtTargetResolution;
        }
        return MagnitudeResolutionConverter.convertDimension2D(tileImageSize, this.requestedResolution, this.targetResolution);
    }

    private void notifyTileLoaded() {
        this.viewListeners.stream().forEach(l -> l.onViewChanged(this.currentView));
        this.tryNotifyProcess();
    }

    private void tryNotifyProcess() {
        if (!this.isTileCacheProcessing()) {
            this.notifyProcessListeners(false);
        }
    }

    private boolean isTileCacheProcessing() {
        return this.tileCache.isProcessing();
    }

    public void stop() {
        this.tileCache.stop();
    }
}

