/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.view;

import java.awt.Point;
import org.bioimageanalysis.icy.icytomine.core.model.Image;

public class Tile2DKey {
    private final Image image;
    private final long resolution;
    private final int x;
    private final int y;
    private final int hashCode;

    public Tile2DKey(Image image, long resolution, int x, int y) {
        this.image = image;
        this.resolution = resolution;
        this.x = x;
        this.y = y;
        this.hashCode = this.computeHashCode();
    }

    public Tile2DKey(Tile2DKey k) {
        this.image = k.image;
        this.resolution = k.resolution;
        this.x = k.x;
        this.y = k.y;
        this.hashCode = k.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (int)(this.resolution ^ this.resolution >>> 32);
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public Image getImage() {
        return this.image;
    }

    public long getResolution() {
        return this.resolution;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tile2DKey)) {
            return false;
        }
        Tile2DKey other = (Tile2DKey)obj;
        if (this.image == null ? other.image != null : !this.image.equals(other.image)) {
            return false;
        }
        if (this.resolution != other.resolution) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public String toString() {
        return String.format("Tile2DKey [hashCode=%s, host=%s, image=%s(id=%s), resolution=%s, x=%s, y=%s]", this.hashCode, this.image.getClient().getHost(), this.image, this.image.getId(), this.resolution, this.x, this.y);
    }
}

