/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationManagerPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions.AnnotationActionPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilteringPanel;

public class AnnotationManagerPanel
extends JPanel {
    private AnnotationFilteringPanel filterPanel;
    private AnnotationTable annotationTable;
    private AnnotationActionPanel actionPanel;
    private AnnotationManagerPanelController panelController;

    public AnnotationManagerPanel() {
        this((Image)null);
    }

    public AnnotationManagerPanel(Image imageInformation) {
        this.setView();
        this.setController(imageInformation);
    }

    private void setView() {
        this.setLayout(new BorderLayout(0, 0));
        this.addFilterPanel();
        this.addAnnotationPanel();
        this.addActionPanel();
    }

    private void addFilterPanel() {
        this.filterPanel = new AnnotationFilteringPanel();
        this.add((Component)this.filterPanel, "North");
    }

    private void addAnnotationPanel() {
        this.annotationTable = new AnnotationTable();
        this.add((Component)this.annotationTable, "Center");
    }

    private void addActionPanel() {
        this.actionPanel = new AnnotationActionPanel();
        this.add((Component)this.actionPanel, "South");
    }

    private void setController(Image imageInformation) {
        this.panelController = new AnnotationManagerPanelController(this, imageInformation);
    }

    public void addAnnotationsVisibilityListener(AnnotationsVisibilityListener listener) {
        this.panelController.addAnnotationsVisibilityListener(listener);
    }

    public void removeAnnotationsVisibilityListener(AnnotationsVisibilityListener listener) {
        this.panelController.removeAnnotationsVisibilityListener(listener);
    }

    public void addAnnotationSelectionListener(AnnotationTable.AnnotationSelectionListener listener) {
        this.annotationTable.addAnnotationSelectionListener(listener);
    }

    public void removeAnnotationSelectionListener(AnnotationTable.AnnotationSelectionListener listener) {
        this.annotationTable.removeAnnotationSelectionListener(listener);
    }

    public void addAnnotationDoubleClickListener(AnnotationTable.AnnotationDoubleClickListener listener) {
        this.annotationTable.addAnnotationDoubleClickListener(listener);
    }

    public void removeAnnotationDoubleClickListener(AnnotationTable.AnnotationDoubleClickListener listener) {
        this.annotationTable.removeAnnotationDoubleClickListener(listener);
    }

    protected AnnotationFilteringPanel getFilteringPanel() {
        return this.filterPanel;
    }

    protected AnnotationTable getAnnotationTable() {
        return this.annotationTable;
    }

    public AnnotationActionPanel getActionPanel() {
        return this.actionPanel;
    }

    public void addAnnotationTermSelectionCommitListener(AnnotationManagerPanelController.AnnotationTermCommitListener listener) {
        this.panelController.addAnnotationTermSelectionCommitListener(listener);
    }

    public void addAnnonationDeletionListener(AnnotationManagerPanelController.AnnotationDeletionListener listener) {
        this.panelController.addAnnotationDeletionListener(listener);
    }

    public void updateAnnotations() {
        this.panelController.updateAnnotations();
    }

    public void selectAnnotations(Set<Annotation> selectedAnnotations) {
        this.annotationTable.setSelectedAnnotations(selectedAnnotations);
    }

    public static interface AnnotationsVisibilityListener {
        public void annotationsVisibiliyChanged(Set<Annotation> var1);
    }
}

