/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationManagerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions.AnnotationActionPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.actions.AnnotationTermSelectionPanelController;

public class AnnotationManagerPanelController {
    private AnnotationManagerPanel panel;
    private Image imageInformation;
    private Set<AnnotationManagerPanel.AnnotationsVisibilityListener> annotationsVisibilitylisteners;
    private Set<AnnotationTermCommitListener> annotationTermSelectionCommitListeners;
    private Set<AnnotationDeletionListener> annotationDeletionListeners;

    public AnnotationManagerPanelController(AnnotationManagerPanel panel, Image imageInformation) {
        this.panel = panel;
        this.imageInformation = imageInformation;
        this.setupListeners();
        this.setupAnnotationFilterPanel();
        this.setupAnnotationTable();
        this.setupAnnotationActionPanel();
    }

    private void setupListeners() {
        this.annotationsVisibilitylisteners = new HashSet<AnnotationManagerPanel.AnnotationsVisibilityListener>();
        this.annotationTermSelectionCommitListeners = new HashSet<AnnotationTermCommitListener>();
        this.annotationDeletionListeners = new HashSet<AnnotationDeletionListener>();
        this.panel.getAnnotationTable().addAnnotationVisibilityListener((annotation, visible) -> this.annotationVisibilityChanged(annotation, visible));
        this.panel.getFilteringPanel().addAnnotationFilterUpdateListener(activeAnnotations -> this.activeAnnotationsUpdated(activeAnnotations));
    }

    private void annotationVisibilityChanged(Entity annotation, boolean visible) {
        this.notifyAnnotationsVisibilityListeners(this.panel.getAnnotationTable().getTableModel().getVisibleAnnotations());
    }

    private void notifyAnnotationsVisibilityListeners(Set<Annotation> newVisibleAnnotations) {
        this.annotationsVisibilitylisteners.forEach(l -> l.annotationsVisibiliyChanged(newVisibleAnnotations));
    }

    private void activeAnnotationsUpdated(Set<Annotation> activeAnnotations) {
        Map<Annotation, Boolean> currentVisibility = this.panel.getAnnotationTable().getTableModel().getAnnotationVisibility();
        Map<Annotation, Boolean> annotationVisibility = this.createAnnotationVisibility(activeAnnotations, currentVisibility);
        this.panel.getAnnotationTable().setTableModel(annotationVisibility);
        Set<Annotation> visibleAnnotations = annotationVisibility.keySet().stream().filter(a -> (Boolean)annotationVisibility.get(a)).collect(Collectors.toSet());
        this.notifyAnnotationsVisibilityListeners(visibleAnnotations);
    }

    private Map<Annotation, Boolean> createAnnotationVisibility(Set<Annotation> annotations, Map<Annotation, Boolean> currentVisibility) {
        Map<Annotation, Boolean> annotationVisibility = annotations.parallelStream().collect(Collectors.toMap(Function.identity(), a -> {
            if (currentVisibility.containsKey(a)) {
                return (Boolean)currentVisibility.get(a);
            }
            return true;
        }));
        return annotationVisibility;
    }

    private void setupAnnotationFilterPanel() {
        this.panel.getFilteringPanel().setImageInformation(this.imageInformation);
    }

    private void setupAnnotationTable() {
        AnnotationTable annotationTable = this.panel.getAnnotationTable();
        Map<Annotation, Boolean> annotationVisibility = this.createAnnotationVisibility(this.panel.getFilteringPanel().getActiveAnnotations(), new HashMap<Annotation, Boolean>(0));
        annotationTable.setTableModel(annotationVisibility);
        annotationTable.addAnnotationSelectionListener(this.getAnnotationSelectionChangeHandler());
    }

    private AnnotationTable.AnnotationSelectionListener getAnnotationSelectionChangeHandler() {
        return selectedAnnotations -> {
            Set<Term> selectedTerms = this.getUserTermsFromAnnotations(selectedAnnotations);
            this.panel.getActionPanel().setSelectedTerms(selectedTerms);
        };
    }

    private Set<Term> getUserTermsFromAnnotations(Set<Annotation> selectedAnnotations) {
        Set<Term> userTerms = selectedAnnotations.stream().map(a -> a.getAssociatedTermsByUser(a.getClient().getCurrentUser().getId())).flatMap(Collection::stream).collect(Collectors.toSet());
        return userTerms;
    }

    private void setupAnnotationActionPanel() {
        AnnotationActionPanel actionPanel = this.panel.getActionPanel();
        actionPanel.setAvailableTerms(this.getAvailableTerms());
        actionPanel.addTermSelectionCommitListener(this.getAnnotationTermSelectionCommitHandler());
        actionPanel.addAnnotationDeletionListener(this.getAnnotationDeletionHandler());
    }

    private Collection<Term> getAvailableTerms() {
        Collection<Term> terms;
        try {
            terms = this.imageInformation.getProject().getOntology().getTerms(false);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            terms = new ArrayList(0);
        }
        return terms;
    }

    private AnnotationTermSelectionPanelController.AnnotationTermSelectionCommitListener getAnnotationTermSelectionCommitHandler() {
        return selectedTerms -> {
            Set<Annotation> selectedAnnotations = this.getSelectedAnnotations();
            if (selectedAnnotations.isEmpty()) {
                MessageDialog.showDialog((String)"Associating terms to annotations - Icytomine", (String)"No annotation selected", (int)2);
                return;
            }
            try {
                for (Annotation selectedAnnotation : selectedAnnotations) {
                    Map<Term, Boolean> termSelection = this.getTermSelection(selectedAnnotation, selectedTerms);
                    selectedAnnotation.associateTerms(termSelection);
                }
                this.notifyAnnotationTermSelectionCommitted(selectedAnnotations);
            }
            catch (CytomineClientException e) {
                e.printStackTrace();
                throw e;
            }
        };
    }

    private Set<Annotation> getSelectedAnnotations() {
        return this.panel.getAnnotationTable().getSelectedAnnotations();
    }

    private Map<Term, Boolean> getTermSelection(Annotation selectedAnnotation, Set<Term> selectedTerms) {
        HashMap<Term, Boolean> termSelection = new HashMap<Term, Boolean>(1);
        Set<Term> associatedTerms = selectedAnnotation.getAssociatedTermsByCurrentUser();
        HashSet<Term> termsToAdd = new HashSet<Term>(selectedTerms);
        termsToAdd.removeAll(associatedTerms);
        termsToAdd.forEach(t -> termSelection.put((Term)t, true));
        HashSet<Term> termsToRemove = new HashSet<Term>(associatedTerms);
        termsToRemove.removeAll(selectedTerms);
        termsToRemove.forEach(t -> termSelection.put((Term)t, false));
        return termSelection;
    }

    private void notifyAnnotationTermSelectionCommitted(Set<Annotation> selectedAnnotations) {
        this.annotationTermSelectionCommitListeners.forEach(listener -> listener.annotationTermCommited(selectedAnnotations));
    }

    private ActionListener getAnnotationDeletionHandler() {
        return event -> {
            Set<Annotation> selectedAnnotations = this.getSelectedAnnotations();
            if (selectedAnnotations.isEmpty()) {
                MessageDialog.showDialog((String)"Deleting annotations - Icytomine", (String)"No annotations selected", (int)2);
                return;
            }
            boolean confirmation = ConfirmDialog.confirm((String)"Deleting annotations - Icytomine", (String)"Are you sure to delete the annotations?", (int)0);
            if (confirmation) {
                Annotation anAnnotation = selectedAnnotations.iterator().next();
                Image image = anAnnotation.getImage();
                try {
                    image.removeAnnotations(selectedAnnotations);
                    System.out.format("Erased %s annotations\n", selectedAnnotations.size());
                }
                catch (CytomineClientException e) {
                    e.printStackTrace();
                    MessageDialog.showDialog((String)"Deleting annotations - Icytomine", (String)"Could not remove annotations.", (int)0);
                    return;
                }
                finally {
                    this.notifyAnnotationDeletion(selectedAnnotations);
                }
            }
        };
    }

    private void notifyAnnotationDeletion(Set<Annotation> selectedAnnotations) {
        this.annotationDeletionListeners.forEach(listener -> listener.annotationsDeleted(selectedAnnotations));
    }

    public void updateAnnotations() {
        this.updateAnnotationTable();
    }

    private void updateAnnotationTable() {
        AnnotationTable annotationTable = this.panel.getAnnotationTable();
        this.panel.getFilteringPanel().setImageInformation(this.imageInformation);
        Map<Annotation, Boolean> annotationVisibility = this.createAnnotationVisibility(this.panel.getFilteringPanel().getActiveAnnotations(), new HashMap<Annotation, Boolean>(0));
        annotationTable.setTableModel(annotationVisibility);
    }

    public void addAnnotationsVisibilityListener(AnnotationManagerPanel.AnnotationsVisibilityListener listener) {
        this.annotationsVisibilitylisteners.add(listener);
    }

    public void removeAnnotationsVisibilityListener(AnnotationManagerPanel.AnnotationsVisibilityListener listener) {
        this.annotationsVisibilitylisteners.remove(listener);
    }

    public void addAnnotationTermSelectionCommitListener(AnnotationTermCommitListener listener) {
        this.annotationTermSelectionCommitListeners.add(listener);
    }

    public void removeAnnotationTermSelectionCommitListener(AnnotationTermCommitListener listener) {
        this.annotationTermSelectionCommitListeners.remove(listener);
    }

    public void addAnnotationDeletionListener(AnnotationDeletionListener listener) {
        this.annotationDeletionListeners.add(listener);
    }

    public void removeAnnotationDeletionListener(AnnotationDeletionListener listener) {
        this.annotationDeletionListeners.remove(listener);
    }

    public static interface AnnotationDeletionListener {
        public void annotationsDeleted(Set<Annotation> var1);
    }

    public static interface AnnotationTermCommitListener {
        public void annotationTermCommited(Set<Annotation> var1);
    }
}

