/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.event.ActionEvent;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilterByTerm;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter.AnnotationFilterPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationFilterByTermPanel
extends AnnotationFilterPanel<AnnotationFilterByTerm.TermItem> {
    AnnotationFilterByTerm termFilter;

    public AnnotationFilterByTermPanel() {
        this.setLabelText("Terms:");
        this.termFilter = new AnnotationFilterByTerm();
        this.setFilter(this.termFilter);
    }

    public void setPreviousFilter(AnnotationFilter previousFilter) {
        this.termFilter.setPreviousFilter(previousFilter);
    }

    public void setTerms(Set<Term> terms) {
        Set<AnnotationFilterByTerm.TermItem> termItems = terms.stream().map(t -> new AnnotationFilterByTerm.TermItem((Term)t)).collect(Collectors.toSet());
        termItems.add(AnnotationFilterByTerm.TermItem.NO_TERM);
        this.termFilter.setActiveTerms(termItems);
        this.setModel(termItems.toArray(new AnnotationFilterByTerm.TermItem[termItems.size()]), item -> item.toString());
    }

    @Override
    protected void choiceChanged(ActionEvent e) {
        JCheckableItem checkableItem = (JCheckableItem)((JCheckedComboBox)e.getSource()).getSelectedItem();
        AnnotationFilterByTerm.TermItem termItem = (AnnotationFilterByTerm.TermItem)checkableItem.object;
        if (!checkableItem.isSelected()) {
            this.termFilter.getActiveTerms().add(termItem);
        } else {
            this.termFilter.getActiveTerms().remove(termItem);
        }
        this.termFilter.computeActiveAnnotations(AnnotationFilter.ComputationMode.RECOMPUTE_JUST_THIS);
    }
}

