/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.core.model.filters.AnnotationFilter;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.AnnotationManagerPanel;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public abstract class AnnotationFilterPanel<E>
extends JPanel {
    private static Image panelRemoveImage = new ImageIcon(AnnotationManagerPanel.class.getResource("/com/sun/java/swing/plaf/windows/icons/Error.gif")).getImage();
    private static final Dimension CHOICESBOX_MIN_SIZE = new Dimension(28, 20);
    private JLabel filterLabel;
    private JCheckedComboBox<E> choicesComboBox;
    private JButton filterRemoveButton;
    private AnnotationFilter filter;

    public AnnotationFilterPanel() {
        this.setGridBagLayout();
        this.addFilterLabel();
        this.addChoiceComboBox();
        this.addFilterRemoveButton();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addFilterLabel() {
        this.filterLabel = new JLabel();
        this.filterLabel.setMinimumSize(new Dimension(55, 14));
        GridBagConstraints gbc_filterLabel = new GridBagConstraints();
        gbc_filterLabel.anchor = 17;
        gbc_filterLabel.insets = new Insets(0, 0, 0, 5);
        gbc_filterLabel.gridx = 0;
        gbc_filterLabel.gridy = 0;
        this.add((Component)this.filterLabel, gbc_filterLabel);
    }

    private void addChoiceComboBox() {
        this.choicesComboBox = new JCheckedComboBox();
        this.choicesComboBox.setModel(new DefaultComboBoxModel());
        GridBagConstraints gbc_choicesComboBox = new GridBagConstraints();
        gbc_choicesComboBox.fill = 2;
        gbc_choicesComboBox.insets = new Insets(0, 0, 0, 5);
        gbc_choicesComboBox.gridx = 1;
        gbc_choicesComboBox.gridy = 0;
        this.add(this.choicesComboBox, gbc_choicesComboBox);
    }

    private void addFilterRemoveButton() {
        this.filterRemoveButton = new JButton("");
        Dimension filterRemoveButtonSize = new Dimension(15, 15);
        this.filterRemoveButton.setPreferredSize(filterRemoveButtonSize);
        this.filterRemoveButton.setMinimumSize(filterRemoveButtonSize);
        this.filterRemoveButton.setIcon(this.getRemoveIcon(filterRemoveButtonSize));
        GridBagConstraints gbc_filterRemoveButton = new GridBagConstraints();
        gbc_filterRemoveButton.anchor = 17;
        gbc_filterRemoveButton.gridx = 2;
        gbc_filterRemoveButton.gridy = 0;
        this.add((Component)this.filterRemoveButton, gbc_filterRemoveButton);
    }

    private Icon getRemoveIcon(Dimension size) {
        Image resizedFilterRemoveIcon = panelRemoveImage.getScaledInstance(size.width, size.height, 4);
        return new ImageIcon(resizedFilterRemoveIcon);
    }

    public void setLabelText(String labelText) {
        this.filterLabel.setText(labelText);
    }

    protected void setFilter(AnnotationFilter filter) {
        this.filter = filter;
    }

    public AnnotationFilter getFilter() {
        return this.filter;
    }

    public void setModel(E[] items, Function<E, String> labelFunction) {
        JCheckableItem[] checkableItems = (JCheckableItem[])Arrays.stream(items).map(it -> new JCheckableItem<Object>(it, (String)labelFunction.apply(it), true)).toArray(JCheckableItem[]::new);
        this.choicesComboBox.setModel(new DefaultComboBoxModel<JCheckableItem>(checkableItems));
        this.choicesComboBox.addActionListener(e -> this.choiceChanged(e));
        this.choicesComboBox.setMinimumSize(CHOICESBOX_MIN_SIZE);
    }

    protected abstract void choiceChanged(ActionEvent var1);

    public void addRemoveButtonListener(ActionListener listener) {
        this.filterRemoveButton.addActionListener(listener);
    }

    public void removeRemoveButtonListener(ActionListener listener) {
        this.filterRemoveButton.removeActionListener(listener);
    }

    public static interface AnnotationFilterListener {
        public void filterUpdated(Set<Annotation> var1);
    }
}

