/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.annotations.filter;

import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FilterAdditionPanel
extends JPanel {
    private Set<FilterAdditionListener> filterListeners = new HashSet<FilterAdditionListener>();

    public FilterAdditionPanel() {
        this(new String[]{"User", "Term"});
    }

    public FilterAdditionPanel(String[] availableFilters) {
        this.setLayout(new BoxLayout(this, 0));
        JComboBox<String> filterComboBox = new JComboBox<String>();
        filterComboBox.setModel(new DefaultComboBoxModel<String>(availableFilters));
        this.add(filterComboBox);
        JButton addFilterButton = new JButton("Add Filter");
        this.add(addFilterButton);
        addFilterButton.addActionListener(e -> this.addFilterButtonClicked((String)filterComboBox.getSelectedItem()));
    }

    public void addFilterAdditionListener(FilterAdditionListener listener) {
        this.filterListeners.add(listener);
    }

    public void removeFilterAdditionListener(FilterAdditionListener listener) {
        this.filterListeners.remove(listener);
    }

    private void addFilterButtonClicked(String selectedItem) {
        System.out.println(selectedItem);
        this.filterListeners.forEach(l -> l.filterAdditionRequested(selectedItem));
    }

    public static interface FilterAdditionListener {
        public void filterAdditionRequested(String var1);
    }
}

