/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence;

import be.cytomine.client.CytomineException;
import icy.common.listener.ProgressListener;
import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.RoiAnnotationSender;
import org.bioimageanalysis.icy.icytomine.core.model.Annotation;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.IcySequenceToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.sequence.SequenceItem;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class IcySequenceToCytominePanelController {
    private IcySequenceToCytominePanel panel;
    private ViewController viewController;
    private Set<ActionListener> closeListeners;
    private ExecutorService transferService;

    public IcySequenceToCytominePanelController(IcySequenceToCytominePanel panel, ViewController viewController) {
        this.panel = panel;
        this.viewController = viewController;
        this.closeListeners = new HashSet<ActionListener>();
        this.setHandlers();
        this.setDisplayInformation();
    }

    private void setAvailableSequences() {
        ArrayList sequences = Icy.getMainInterface().getSequences();
        sequences.add(0, null);
        SequenceItem[] items = (SequenceItem[])sequences.stream().map(seq -> new SequenceItem((Sequence)seq)).toArray(SequenceItem[]::new);
        this.panel.getSequenceComboBox().setModel(new DefaultComboBoxModel<SequenceItem>(items));
        this.panel.getSequenceComboBox().setSelectedItem(items[0]);
    }

    private void setHandlers() {
        this.panel.getSendButton().addActionListener(this.getSendButtonHandler());
        this.panel.getCancelButton().addActionListener(this.getCancelButtonHandler());
    }

    private ActionListener getSendButtonHandler() {
        return event -> {
            try {
                this.cancelPreviousRequest();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)e.getMessage(), (int)0);
                e.printStackTrace();
                return;
            }
            Sequence sequence = ((SequenceItem)this.panel.getSequenceComboBox().getSelectedItem()).getSequence();
            boolean selectedRois = this.panel.getRoiSelectionCheckBox().isSelected();
            this.sendAnnotations(sequence, selectedRois);
        };
    }

    private synchronized void sendAnnotations(Sequence sequence, boolean selectedRois) {
        if (sequence == null) {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)"No sequence selected", (int)0);
        } else {
            this.panel.getSendButton().setEnabled(false);
            this.transferService = Executors.newSingleThreadExecutor();
            this.transferService.submit(this.getTransferHandler(sequence, selectedRois));
            this.transferService.shutdown();
        }
    }

    private Runnable getTransferHandler(Sequence sequence, boolean selectedRois) {
        return () -> {
            try {
                RoiAnnotationSender sender = new RoiAnnotationSender(this.viewController.getImageInformation(), sequence, selectedRois);
                sender.addProgressListener(this.getProgressHandler());
                List<Annotation> createdAnnotations = sender.send();
                this.viewController.getImageInformation().getAnnotations(false).addAll(createdAnnotations);
                this.notifySuccess(createdAnnotations);
                this.notifyCloseListener();
            }
            catch (Exception e) {
                this.notifyFailure(e);
            }
            finally {
                this.panel.getSendButton().setEnabled(true);
            }
        };
    }

    private ProgressListener getProgressHandler() {
        return (pos, len) -> {
            this.setProgress(pos / len);
            return true;
        };
    }

    private void setProgress(double progress) {
        EventQueue.invokeLater(() -> this.panel.getTransferProgressBar().setValue((int)(progress * 100.0)));
    }

    private void notifySuccess(List<Annotation> createdAnnotations) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setProgress(0.0);
        try {
            this.viewController.getViewProvider().updateAnnotations(false);
            this.viewController.refreshView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)String.format("Transfer complete: %d annotations sent", createdAnnotations.size()), (int)1);
    }

    private void notifyFailure(Exception e) {
        if (e instanceof CytomineException) {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)((CytomineException)e).getMsg(), (int)0);
        } else {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)e.getMessage(), (int)0);
        }
        e.printStackTrace();
    }

    private void cancelPreviousRequest() throws InterruptedException, RuntimeException {
        if (this.transferService != null) {
            ExecutorService t = this.transferService;
            this.transferService = null;
            t.shutdownNow();
            if (!t.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not stop transfer service");
            }
        }
    }

    private ActionListener getCancelButtonHandler() {
        return event -> {
            try {
                this.cancelPreviousRequest();
            }
            catch (InterruptedException | RuntimeException e) {
                e.printStackTrace();
            }
            this.notifyCloseListener();
        };
    }

    private void notifyCloseListener() {
        this.closeListeners.forEach(l -> l.actionPerformed(null));
    }

    private void setDisplayInformation() {
        this.setAvailableSequences();
    }

    public void addCloseListener(ActionListener listener) {
        this.closeListeners.add(listener);
    }

    public void close() {
        try {
            this.cancelPreviousRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"Error on closing dialog - Icytomine", (String)e.getMessage(), (int)0);
        }
    }

    public static interface RoiTransferStartListener {
        public void startTransfer(Sequence var1);
    }

    public static interface RoiTransferCancellationListener {
        public void cancelTransfer();
    }
}

