/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.core.InternalCache;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.Eh107CacheMXBean;
import org.ehcache.jsr107.Eh107CacheManager;
import org.ehcache.jsr107.Eh107CacheStatisticsMXBean;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.jsr107.EventListenerAdaptors;
import org.ehcache.jsr107.ListenerResources;
import org.ehcache.jsr107.MultiCacheException;
import org.ehcache.jsr107.NullCompletionListener;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoadingException;
import org.ehcache.spi.loaderwriter.CacheWritingException;

class Eh107Cache<K, V>
implements Cache<K, V> {
    private final InternalCache<K, V> ehCache;
    private final Jsr107Cache<K, V> jsr107Cache;
    private final Eh107CacheManager cacheManager;
    private final String name;
    private final AtomicBoolean hypotheticallyClosed = new AtomicBoolean();
    private final CacheResources<K, V> cacheResources;
    private final Eh107CacheMXBean managementBean;
    private final Eh107CacheStatisticsMXBean statisticsBean;
    private final Eh107Configuration<K, V> config;
    private final Jsr107CacheLoaderWriter<? super K, V> cacheLoaderWriter;
    private static final Object UNDEFINED = new Object();

    Eh107Cache(String name, Eh107Configuration<K, V> config, CacheResources<K, V> cacheResources, InternalCache<K, V> ehCache, Eh107CacheManager cacheManager) {
        this.cacheLoaderWriter = cacheResources.getCacheLoaderWriter();
        this.config = config;
        this.ehCache = ehCache;
        this.cacheManager = cacheManager;
        this.name = name;
        this.cacheResources = cacheResources;
        this.managementBean = new Eh107CacheMXBean(name, cacheManager.getURI(), config);
        this.statisticsBean = new Eh107CacheStatisticsMXBean(name, cacheManager.getURI(), cacheManager.getEhCacheManager().getServiceProvider().getService(StatisticsService.class));
        for (Map.Entry<CacheEntryListenerConfiguration<K, V>, ListenerResources<K, V>> entry : cacheResources.getListenerResources().entrySet()) {
            this.registerEhcacheListeners(entry.getKey(), entry.getValue());
        }
        this.jsr107Cache = ehCache.getJsr107Cache();
    }

    @Override
    public V get(K key) {
        this.checkClosed();
        try {
            return this.ehCache.get(key);
        }
        catch (CacheLoadingException e) {
            throw Eh107Cache.jsr107CacheLoaderException(e);
        }
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkClosed();
        try {
            return this.jsr107Cache.getAll(keys);
        }
        catch (CacheLoadingException e) {
            throw Eh107Cache.jsr107CacheLoaderException(e);
        }
    }

    @Override
    public boolean containsKey(K key) {
        this.checkClosed();
        return this.ehCache.containsKey(key);
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.checkClosed();
        if (keys == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        CompletionListener completionListener2 = completionListener = completionListener != null ? completionListener : NullCompletionListener.INSTANCE;
        if (this.cacheLoaderWriter == null) {
            completionListener.onCompletion();
            return;
        }
        try {
            this.jsr107Cache.loadAll(keys, replaceExistingValues, new Function<Iterable<? extends K>, Map<K, V>>(){

                @Override
                public Map<K, V> apply(Iterable<? extends K> keys) {
                    try {
                        Map loadResult = Eh107Cache.this.cacheLoaderWriter.loadAllAlways(keys);
                        HashMap resultMap = new HashMap();
                        for (Object key : keys) {
                            resultMap.put(key, loadResult.get(key));
                        }
                        return resultMap;
                    }
                    catch (Exception e) {
                        CacheLoaderException cle = e instanceof CacheLoaderException ? (CacheLoaderException)e : (e.getCause() instanceof CacheLoaderException ? (CacheLoaderException)e.getCause() : new CacheLoaderException(e));
                        throw cle;
                    }
                }
            });
        }
        catch (Exception e) {
            CacheLoaderException cle = e instanceof CacheLoaderException ? (CacheLoaderException)e : (e.getCause() instanceof CacheLoaderException ? (CacheLoaderException)e.getCause() : new CacheLoaderException(e));
            completionListener.onException(cle);
            return;
        }
        completionListener.onCompletion();
    }

    @Override
    public void put(K key, V value) {
        this.checkClosed();
        try {
            this.ehCache.put(key, value);
        }
        catch (CacheWritingException cwe) {
            throw Eh107Cache.jsr107CacheWriterException(cwe);
        }
    }

    @Override
    public V getAndPut(K key, V value) {
        this.checkClosed();
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try {
            return this.jsr107Cache.getAndPut(key, value);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkClosed();
        try {
            this.ehCache.putAll(map);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        this.checkClosed();
        try {
            this.cacheResources.getExpiryPolicy().enableShortCircuitAccessCalls();
            boolean bl = this.ehCache.putIfAbsent(key, value) == null;
            return bl;
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
        finally {
            this.cacheResources.getExpiryPolicy().disableShortCircuitAccessCalls();
        }
    }

    @Override
    public boolean remove(K key) {
        this.checkClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            return this.jsr107Cache.remove(key);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public boolean remove(K key, V oldValue) {
        this.checkClosed();
        try {
            return this.ehCache.remove(key, oldValue);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public V getAndRemove(K key) {
        this.checkClosed();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            return this.jsr107Cache.getAndRemove(key);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.checkClosed();
        try {
            return this.ehCache.replace(key, oldValue, newValue);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public boolean replace(K key, V value) {
        this.checkClosed();
        try {
            return this.ehCache.replace(key, value) != null;
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public V getAndReplace(K key, V value) {
        try {
            this.checkClosed();
            return this.ehCache.replace(key, value);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public void removeAll(Set<? extends K> keys) {
        this.checkClosed();
        try {
            this.ehCache.removeAll(keys);
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public void removeAll() {
        this.checkClosed();
        try {
            this.jsr107Cache.removeAll();
        }
        catch (CacheWritingException e) {
            throw Eh107Cache.jsr107CacheWriterException(e);
        }
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    private void clear(boolean checkClosed) {
        if (checkClosed) {
            this.checkClosed();
        }
        this.ehCache.clear();
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        this.checkClosed();
        return (C)((Configuration)this.config.unwrap(clazz));
    }

    @Override
    public <T> T invoke(K key, final EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) throws EntryProcessorException {
        this.checkClosed();
        if (key == null || entryProcessor == null) {
            throw new NullPointerException();
        }
        final AtomicReference mutableEntryRef = new AtomicReference();
        final AtomicReference invokeResult = new AtomicReference();
        this.jsr107Cache.compute(key, new BiFunction<K, V, V>(){

            @Override
            public V apply(K mappedKey, V mappedValue) {
                Object processResult;
                MutableEntry mutableEntry = new MutableEntry(mappedKey, mappedValue);
                mutableEntryRef.set(mutableEntry);
                try {
                    processResult = entryProcessor.process(mutableEntry, arguments);
                }
                catch (Exception e) {
                    if (e instanceof EntryProcessorException) {
                        throw new StorePassThroughException(e);
                    }
                    throw new StorePassThroughException(new EntryProcessorException(e));
                }
                invokeResult.set(processResult);
                return mutableEntry.apply(Eh107Cache.this.config.isWriteThrough(), Eh107Cache.this.cacheLoaderWriter);
            }
        }, new NullaryFunction<Boolean>(){

            @Override
            public Boolean apply() {
                MutableEntry mutableEntry = (MutableEntry)mutableEntryRef.get();
                return mutableEntry.shouldReplace();
            }
        }, new NullaryFunction<Boolean>(){

            @Override
            public Boolean apply() {
                MutableEntry mutableEntry = (MutableEntry)mutableEntryRef.get();
                return mutableEntry.shouldInvokeWriter();
            }
        }, new NullaryFunction<Boolean>(){

            @Override
            public Boolean apply() {
                MutableEntry mutableEntry = (MutableEntry)mutableEntryRef.get();
                return mutableEntry.shouldGenerateEvent();
            }
        });
        return (T)invokeResult.get();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.checkClosed();
        if (keys == null || entryProcessor == null) {
            throw new NullPointerException();
        }
        for (K key : keys) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        HashMap<K, EntryProcessorResult<T>> results = new HashMap<K, EntryProcessorResult<T>>(keys.size());
        for (K key : keys) {
            EntryProcessorResult<T> result = null;
            try {
                T invokeResult = this.invoke(key, entryProcessor, arguments);
                if (invokeResult != null) {
                    result = Eh107Cache.newEntryProcessorResult(invokeResult);
                }
            }
            catch (Exception e) {
                result = Eh107Cache.newErrorThrowingEntryProcessorResult(e);
            }
            if (result == null) continue;
            results.put(key, result);
        }
        return results;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void close() {
        MultiCacheException closeException = new MultiCacheException();
        this.cacheManager.close(this, closeException);
        closeException.throwIfNotEmpty();
    }

    @Override
    public boolean isClosed() {
        return this.syncedIsClose();
    }

    void closeInternal(MultiCacheException closeException) {
        this.closeInternal(false, closeException);
    }

    private void closeInternal(boolean destroy, MultiCacheException closeException) {
        if (this.hypotheticallyClosed.compareAndSet(false, true)) {
            if (destroy) {
                try {
                    this.clear(false);
                }
                catch (Throwable t) {
                    closeException.addThrowable(t);
                }
            }
            this.cacheResources.closeResources(closeException);
        }
    }

    private boolean syncedIsClose() {
        if (this.ehCache.getStatus() == Status.UNINITIALIZED && !this.hypotheticallyClosed.get()) {
            this.close();
        }
        return this.hypotheticallyClosed.get();
    }

    void destroy(MultiCacheException destroyException) {
        this.closeInternal(true, destroyException);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this, this.ehCache);
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkClosed();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException();
        }
        ListenerResources<K, V> resources = this.cacheResources.registerCacheEntryListener(cacheEntryListenerConfiguration);
        this.config.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        this.registerEhcacheListeners(cacheEntryListenerConfiguration, resources);
    }

    private void registerEhcacheListeners(CacheEntryListenerConfiguration<K, V> config, ListenerResources<K, V> resources) {
        boolean synchronous = config.isSynchronous();
        EventOrdering ordering = synchronous ? EventOrdering.ORDERED : EventOrdering.UNORDERED;
        EventFiring firing = synchronous ? EventFiring.SYNCHRONOUS : EventFiring.ASYNCHRONOUS;
        boolean requestsOld = config.isOldValueRequired();
        for (EventListenerAdaptors.EventListenerAdaptor<K, V> ehcacheListener : resources.getEhcacheListeners(this, requestsOld)) {
            this.ehCache.getRuntimeConfiguration().registerCacheEventListener(ehcacheListener, ordering, firing, EnumSet.of(ehcacheListener.getEhcacheEventType()));
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkClosed();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException();
        }
        ListenerResources<K, V> resources = this.cacheResources.deregisterCacheEntryListener(cacheEntryListenerConfiguration);
        if (resources != null) {
            this.config.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            for (EventListenerAdaptors.EventListenerAdaptor<K, V> ehListener : resources.getEhcacheListeners(this, cacheEntryListenerConfiguration.isOldValueRequired())) {
                this.ehCache.getRuntimeConfiguration().deregisterCacheEventListener(ehListener);
            }
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.checkClosed();
        final Iterator<Cache.Entry<K, V>> specIterator = this.jsr107Cache.specIterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                Eh107Cache.this.checkClosed();
                return specIterator.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                Eh107Cache.this.checkClosed();
                Cache.Entry next = (Cache.Entry)specIterator.next();
                return next == null ? null : new WrappedEhcacheEntry(next);
            }

            @Override
            public void remove() {
                Eh107Cache.this.checkClosed();
                specIterator.remove();
            }
        };
    }

    private void checkClosed() {
        if (this.syncedIsClose()) {
            throw new IllegalStateException("Cache[" + this.name + "] is closed");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    Eh107MXBean getManagementMBean() {
        return this.managementBean;
    }

    Eh107MXBean getStatisticsMBean() {
        return this.statisticsBean;
    }

    void setStatisticsEnabled(boolean enabled) {
        this.config.setStatisticsEnabled(enabled);
    }

    void setManagementEnabled(boolean enabled) {
        this.config.setManagementEnabled(enabled);
    }

    private static CacheLoaderException jsr107CacheLoaderException(CacheLoadingException e) {
        if (e.getCause() instanceof CacheLoaderException) {
            return (CacheLoaderException)e.getCause();
        }
        return new CacheLoaderException(e);
    }

    private static CacheWriterException jsr107CacheWriterException(CacheWritingException e) {
        if (e.getCause() instanceof CacheWriterException) {
            return (CacheWriterException)e.getCause();
        }
        throw new CacheWriterException(e);
    }

    private static <T> EntryProcessorResult<T> newEntryProcessorResult(final T result) {
        if (result == null) {
            throw new NullPointerException();
        }
        return new EntryProcessorResult<T>(){

            @Override
            public T get() throws EntryProcessorException {
                return result;
            }
        };
    }

    private static <T> EntryProcessorResult<T> newErrorThrowingEntryProcessorResult(final Exception e) {
        return new EntryProcessorResult<T>(){

            @Override
            public T get() throws EntryProcessorException {
                if (e instanceof EntryProcessorException) {
                    throw (EntryProcessorException)e;
                }
                throw new EntryProcessorException(e);
            }
        };
    }

    private class MutableEntry
    implements javax.cache.processor.MutableEntry<K, V> {
        private final K key;
        private final V initialValue;
        private volatile V finalValue = this.undefined();
        private volatile MutableEntryOperation operation = MutableEntryOperation.NONE;

        MutableEntry(K key, V initialValue) {
            this.key = key;
            this.initialValue = initialValue;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            if (this.finalValue == UNDEFINED) {
                if (this.initialValue == null && Eh107Cache.this.config.isReadThrough() && Eh107Cache.this.cacheLoaderWriter != null) {
                    this.finalValue = this.tryLoad();
                    if (this.finalValue != null) {
                        this.operation = MutableEntryOperation.LOAD;
                    }
                } else {
                    this.finalValue = this.initialValue;
                    this.operation = MutableEntryOperation.ACCESS;
                }
            }
            return this.finalValue;
        }

        private V tryLoad() {
            try {
                return Eh107Cache.this.cacheLoaderWriter.load(this.key);
            }
            catch (Exception e) {
                if (e instanceof CacheLoaderException) {
                    throw (CacheLoaderException)e;
                }
                throw new CacheLoaderException(e);
            }
        }

        @Override
        public boolean exists() {
            if (this.finalValue == UNDEFINED) {
                return this.initialValue != null;
            }
            return this.finalValue != null;
        }

        @Override
        public void remove() {
            this.operation = this.operation == MutableEntryOperation.CREATE ? MutableEntryOperation.NONE : MutableEntryOperation.REMOVE;
            this.finalValue = null;
        }

        @Override
        public void setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.operation = this.initialValue == null ? MutableEntryOperation.CREATE : MutableEntryOperation.UPDATE;
            this.finalValue = value;
        }

        V apply(boolean isWriteThrough, CacheLoaderWriter<? super K, ? super V> cacheLoaderWriter) {
            switch (this.operation) {
                case NONE: 
                case ACCESS: {
                    return this.initialValue;
                }
                case LOAD: 
                case CREATE: 
                case UPDATE: {
                    return this.finalValue;
                }
                case REMOVE: {
                    return null;
                }
            }
            throw new AssertionError((Object)("unhandled case: " + (Object)((Object)this.operation)));
        }

        boolean shouldReplace() {
            switch (this.operation) {
                case NONE: 
                case ACCESS: {
                    return false;
                }
                case LOAD: 
                case CREATE: 
                case UPDATE: 
                case REMOVE: {
                    return true;
                }
            }
            throw new AssertionError((Object)("unhandled case: " + (Object)((Object)this.operation)));
        }

        boolean shouldGenerateEvent() {
            switch (this.operation) {
                case NONE: 
                case ACCESS: 
                case LOAD: {
                    return false;
                }
                case CREATE: 
                case UPDATE: 
                case REMOVE: {
                    return true;
                }
            }
            throw new AssertionError((Object)("unhandled case: " + (Object)((Object)this.operation)));
        }

        boolean shouldInvokeWriter() {
            switch (this.operation) {
                case NONE: 
                case ACCESS: 
                case LOAD: {
                    return false;
                }
                case CREATE: 
                case UPDATE: 
                case REMOVE: {
                    return true;
                }
            }
            throw new AssertionError((Object)("unhandled case: " + (Object)((Object)this.operation)));
        }

        private V undefined() {
            return UNDEFINED;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            throw new IllegalArgumentException();
        }
    }

    private static enum MutableEntryOperation {
        NONE,
        ACCESS,
        CREATE,
        LOAD,
        REMOVE,
        UPDATE;

    }

    private static class WrappedEhcacheEntry<K, V>
    implements Cache.Entry<K, V> {
        private final Cache.Entry<K, V> ehEntry;

        WrappedEhcacheEntry(Cache.Entry<K, V> ehEntry) {
            this.ehEntry = ehEntry;
        }

        @Override
        public K getKey() {
            return this.ehEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.ehEntry.getValue();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return Unwrap.unwrap(clazz, this, this.ehEntry);
        }
    }
}

