/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.logging.Level;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class WrappingCoordinateFilter
implements GeometryComponentFilter {
    static final int EAST_TO_WEST = 0;
    static final int WEST_TO_EAST = 1;
    static final int NOWRAP = 2;
    final double wrapLimit;
    final double offset;
    final MathTransform mt;
    final int ordinateIdx;

    public WrappingCoordinateFilter(double wrapLimit, double offset, MathTransform mt, boolean wrapOnY) {
        this.wrapLimit = wrapLimit;
        this.offset = offset;
        this.mt = mt;
        this.ordinateIdx = wrapOnY ? 1 : 0;
    }

    public void filter(Geometry geom) {
        if (geom instanceof LineString) {
            LineString ls = (LineString)geom;
            CoordinateSequence cs = ls.getCoordinateSequence();
            int direction = this.getDisconinuityDirection(cs);
            if (direction == 2) {
                return;
            }
            boolean ring = geom instanceof LinearRing || cs.getCoordinate(0).equals((Object)cs.getCoordinate(cs.size() - 1));
            this.applyOffset(cs, direction == 0 ? 0.0 : this.wrapLimit * 2.0, ring);
        }
    }

    private int getDisconinuityDirection(CoordinateSequence cs) {
        double lastOrdinate = cs.getOrdinate(0, this.ordinateIdx);
        for (int i = 0; i < cs.size(); ++i) {
            double ordinate = cs.getOrdinate(i, this.ordinateIdx);
            if (Math.abs(ordinate - lastOrdinate) > this.wrapLimit) {
                if (ordinate > lastOrdinate) {
                    return 1;
                }
                if (ordinate < lastOrdinate) {
                    return 0;
                }
            }
            lastOrdinate = ordinate;
        }
        return 2;
    }

    private void applyOffset(CoordinateSequence cs, double offset, boolean ring) {
        double maxWrap = this.wrapLimit * 1.9;
        double lastOrdinate = cs.getOrdinate(0, this.ordinateIdx);
        int last = ring ? cs.size() - 1 : cs.size();
        for (int i = 0; i < last; ++i) {
            double ordinate = cs.getOrdinate(i, this.ordinateIdx);
            double distance = Math.abs(ordinate - lastOrdinate);
            if (distance > this.wrapLimit) {
                boolean wraps;
                boolean bl = wraps = distance < maxWrap;
                if (!wraps && this.mt != null) {
                    double[] src = this.ordinateIdx == 0 ? new double[]{lastOrdinate, cs.getY(i - 1), ordinate, cs.getY(i)} : new double[]{cs.getX(i - i), lastOrdinate, cs.getX(i), ordinate};
                    double[] dest = new double[4];
                    try {
                        this.mt.transform(src, 0, dest, 0, 2);
                        src[0] = Math.min(dest[0], dest[2]) + Math.abs(dest[2] - dest[0]) / 2.0;
                        src[1] = Math.min(dest[1], dest[3]) + Math.abs(dest[3] - dest[1]) / 2.0;
                        this.mt.inverse().transform(src, 0, dest, 0, 1);
                        wraps = !(dest[this.ordinateIdx] > Math.min(lastOrdinate, ordinate)) || !(dest[this.ordinateIdx] < Math.max(lastOrdinate, ordinate));
                    }
                    catch (TransformException ex) {
                        Logging.getLogger((String)"org.geotools.rendering").log(Level.WARNING, "Unable to perform transform to detect dateline wrapping", ex);
                    }
                }
                if (wraps) {
                    offset = offset != 0.0 ? 0.0 : this.wrapLimit * 2.0;
                }
            }
            if (offset != 0.0) {
                cs.setOrdinate(i, this.ordinateIdx, ordinate + offset);
            }
            lastOrdinate = ordinate;
        }
        if (ring) {
            cs.setOrdinate(last, this.ordinateIdx, cs.getOrdinate(0, this.ordinateIdx));
        }
    }
}

