/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ContrastMethodStrategy;
import org.geotools.styling.StyleVisitor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ContrastMethod;

public class ContrastEnhancementImpl
implements ContrastEnhancement {
    private FilterFactory filterFactory;
    private Expression gamma;
    private Expression type;
    private ContrastMethod method;
    private Map<String, Expression> options;

    public ContrastEnhancementImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public ContrastEnhancementImpl(FilterFactory factory) {
        this(factory, null);
    }

    public ContrastEnhancementImpl(FilterFactory factory, ContrastMethod method) {
        this.filterFactory = factory;
        this.method = method;
    }

    public ContrastEnhancementImpl(org.opengis.style.ContrastEnhancement contrastEnhancement) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        ContrastMethod meth = contrastEnhancement.getMethod();
        if (meth != null) {
            this.method = ContrastMethod.valueOf((String)meth.name());
        }
        this.gamma = contrastEnhancement.getGammaValue();
    }

    public ContrastEnhancementImpl(FilterFactory2 factory, Expression gamma, ContrastMethod method) {
        this.filterFactory = factory;
        this.gamma = gamma;
        this.method = method;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
    }

    public Expression getGammaValue() {
        return this.gamma;
    }

    public void setGammaValue(Expression gamma) {
        this.gamma = gamma;
    }

    public ContrastMethod getMethod() {
        return this.method;
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object extraData) {
        return visitor.visit((org.opengis.style.ContrastEnhancement)this, extraData);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((ContrastEnhancement)this);
    }

    static ContrastEnhancementImpl cast(org.opengis.style.ContrastEnhancement enhancement) {
        if (enhancement == null) {
            return null;
        }
        if (enhancement instanceof ContrastEnhancementImpl) {
            return (ContrastEnhancementImpl)enhancement;
        }
        ContrastEnhancementImpl copy = new ContrastEnhancementImpl();
        copy.setGammaValue(enhancement.getGammaValue());
        copy.setMethod(enhancement.getMethod());
        return copy;
    }

    public void setMethod(ContrastMethod method) {
        this.method = method;
    }

    public Map<String, Expression> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        return this.options;
    }

    public boolean hasOption(String key) {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        return this.options.containsKey(key);
    }

    public Expression getOption(String key) {
        return this.options.get(key);
    }

    public void addOption(String key, Expression value) {
        if (this.options == null) {
            this.options = new HashMap<String, Expression>();
        }
        this.options.put(key, value);
    }

    public void setOptions(Map<String, Expression> options) {
        this.options = options;
    }

    public void setMethod(ContrastMethodStrategy method) {
        this.method = method.getMethod();
        this.options = method.getOptions();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gamma == null ? 0 : this.gamma.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContrastEnhancementImpl)) {
            return false;
        }
        ContrastEnhancementImpl other = (ContrastEnhancementImpl)obj;
        if (this.gamma == null ? other.gamma != null : !this.gamma.equals(other.gamma)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals((Object)other.method)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

