/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import org.japura.gui.event.PriorityComboBoxEvent;
import org.japura.gui.event.PriorityComboBoxListener;
import org.japura.gui.model.PriorityComboBoxModel;

public class DefaultPriorityComboBoxModel
extends AbstractListModel
implements PriorityComboBoxModel {
    private static final long serialVersionUID = 3463014910762087126L;
    private List<Object> items = new ArrayList<Object>();
    private List<Object> priorityItems = new ArrayList<Object>();
    private Object selectedItem;
    private int priorityItemsCapacity = 3;
    private int minimalSizeForPriority;
    private boolean increasePriorityOnSelection;

    public DefaultPriorityComboBoxModel(Object[] objects) {
        this();
        this.addAll(objects);
    }

    public DefaultPriorityComboBoxModel(List<?> objects) {
        this();
        this.addAll(objects);
    }

    public DefaultPriorityComboBoxModel() {
        this.setMinimalSizeForPriority(10);
        this.increasePriorityOnSelection = true;
    }

    private void addAll(Object ... objects) {
        for (Object obj : objects) {
            this.items.add(obj);
        }
    }

    @Override
    public void addElement(Object item, boolean priorityItem) {
        if (!this.items.contains(item)) {
            this.items.add(item);
            int i = this.items.size() - 1;
            if (priorityItem) {
                this.addToPriority(item);
            }
            this.fireContentsChanged(this, i, i);
            if (this.selectedItem == null) {
                this.selectedItem = item;
            }
        }
    }

    public PriorityComboBoxListener[] getPriorityComboBoxListeners() {
        return (PriorityComboBoxListener[])this.listenerList.getListeners(PriorityComboBoxListener.class);
    }

    @Override
    public void addPriorityComboBoxListener(PriorityComboBoxListener listener) {
        this.listenerList.add(PriorityComboBoxListener.class, listener);
    }

    @Override
    public void removePriorityComboBoxListener(PriorityComboBoxListener listener) {
        this.listenerList.remove(PriorityComboBoxListener.class, listener);
    }

    protected void firePriorityComboBoxListeners() {
        PriorityComboBoxListener[] array;
        PriorityComboBoxEvent event = new PriorityComboBoxEvent(this);
        for (PriorityComboBoxListener listener : array = this.getPriorityComboBoxListeners()) {
            listener.priorityChanged(event);
        }
    }

    @Override
    public List<Object> getPriorityItems() {
        return new ArrayList<Object>(this.priorityItems);
    }

    @Override
    public int getPriorityItemsCapacity() {
        return this.priorityItemsCapacity;
    }

    @Override
    public void setPriorityItemsCapacity(int capacity) {
        this.priorityItemsCapacity = Math.max(1, capacity);
        while (this.priorityItems.size() > this.getPriorityItemsCapacity()) {
            int i = this.priorityItems.size() - 1;
            this.priorityItems.remove(i);
            this.fireIntervalRemoved(this, i, i);
        }
        this.firePriorityComboBoxListeners();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (this.items.contains(anItem)) {
            this.selectedItem = anItem;
            if (this.isIncreasePriorityOnSelection() && anItem != null) {
                this.addToPriority(anItem);
            }
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index < 0 || index >= this.getSize()) {
            return null;
        }
        if (this.isPriorityAvailable()) {
            if (index < this.priorityItems.size()) {
                return this.priorityItems.get(index);
            }
            index -= this.priorityItems.size();
        }
        return this.items.get(index);
    }

    @Override
    public int getSize() {
        if (this.isPriorityAvailable()) {
            return this.items.size() + this.priorityItems.size();
        }
        return this.items.size();
    }

    @Override
    public void addToPriority(Object obj) {
        int index;
        if (this.priorityItems.contains(obj)) {
            index = this.priorityItems.indexOf(obj);
            if (index > 0) {
                this.priorityItems.remove(index);
                this.priorityItems.add(index - 1, obj);
            }
        } else {
            if (this.priorityItems.size() == this.getPriorityItemsCapacity()) {
                this.priorityItems.remove(this.priorityItems.size() - 1);
            }
            this.priorityItems.add(obj);
        }
        if (this.isPriorityAvailable()) {
            index = this.priorityItems.indexOf(obj);
            this.fireContentsChanged(this, index, index);
        }
        this.firePriorityComboBoxListeners();
    }

    @Override
    public void removeFromPriority(Object obj) {
        if (this.priorityItems.contains(obj)) {
            int index = this.priorityItems.indexOf(obj);
            boolean fire = this.isPriorityAvailable();
            this.priorityItems.remove(index);
            if (fire) {
                this.fireContentsChanged(this, index, index);
            }
        }
    }

    public void addElement(Object item) {
        this.addElement(item, false);
    }

    public void insertElementAt(Object item, int index) {
        if (!this.items.contains(item)) {
            if (this.isPriorityAvailable()) {
                index -= this.priorityItems.size();
            }
            if (index >= 0 && index <= this.items.size()) {
                this.items.add(index, item);
            }
        }
    }

    @Override
    public void removeElement(Object obj) {
        if (obj == null) {
            return;
        }
        this.priorityItems.remove(obj);
        int index = this.items.indexOf(obj);
        if (this.items.remove(obj)) {
            int i = index;
            if (this.isPriorityAvailable()) {
                i += this.getPriorityItemsSize();
            }
            this.fireIntervalRemoved(this, i, i);
            if (this.priorityItems.remove(obj)) {
                this.firePriorityComboBoxListeners();
            }
        }
        if (this.selectedItem.equals(obj)) {
            this.selectedItem = this.getSize() > 0 ? this.getElementAt(0) : null;
        }
    }

    @Override
    public void removeElementAt(int index) {
        Object obj = this.getElementAt(index);
        this.removeElement(obj);
    }

    @Override
    public boolean isIncreasePriorityOnSelection() {
        return this.increasePriorityOnSelection;
    }

    @Override
    public void setIncreasePriorityOnSelection(boolean enable) {
        this.increasePriorityOnSelection = enable;
    }

    @Override
    public int getPriorityItemsSize() {
        return this.priorityItems.size();
    }

    @Override
    public void clearPriorities() {
        this.priorityItems.clear();
        this.firePriorityComboBoxListeners();
    }

    @Override
    public int getMinimalSizeForPriority() {
        return this.minimalSizeForPriority;
    }

    @Override
    public boolean isPriorityAvailable() {
        return this.items.size() >= this.getMinimalSizeForPriority();
    }

    @Override
    public void setMinimalSizeForPriority(int size) {
        this.minimalSizeForPriority = Math.max(1, size);
    }

    @Override
    public boolean isPriorityItem(Object obj) {
        return this.priorityItems.contains(obj);
    }
}

