/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.icytomine;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.bioimageanalysis.icy.icytomine.command.CommandProcessor;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.connection.persistence.Preferences;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ExplorerFrame;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.login.LoginFrame;
import org.bioimageanalysis.icy.icytomine.ui.core.login.LoginPanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.ViewerFrame;

public class IcytomineExplorer
extends PluginActionable {
    public void run() {
        System.out.println("Reading Preferences...");
        try {
            Preferences.loadOrDefault();
        }
        catch (IOException e) {
            if (!Icy.getMainInterface().isHeadLess()) {
                MessageDialog.showDialog((String)"Error - Icytomine", (String)e.getMessage(), (int)0);
            }
            e.printStackTrace();
        }
        if (Icy.getMainInterface().isHeadLess()) {
            try {
                CommandProcessor processor = new CommandProcessor();
                processor.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            System.out.println("Showing Login...");
            LoginFrame loginFrame = new LoginFrame();
            loginFrame.getLoginPanel().addLoginListener(this.getLoginHandler(loginFrame));
            loginFrame.setVisible(true);
        }
    }

    private LoginPanelController.LoginListener getLoginHandler(LoginFrame loginFrame) {
        return client -> {
            try {
                String username = client.getCurrentUser().getName().orElse("not specified");
                System.out.println("Logged in as " + username);
                ExplorerFrame explorerFrame = new ExplorerFrame();
                explorerFrame.setClient(client);
                explorerFrame.addOpenViewerListener(this.getViewerOpenRequestHandler());
                explorerFrame.setVisible(true);
                loginFrame.setVisible(false);
                loginFrame.dispose();
                System.out.println("Login done");
            }
            catch (CytomineClientException e) {
                MessageDialog.showDialog((String)"Icytomine: Error", (String)e.getMessage(), (int)0);
            }
        };
    }

    private ImagePanel.ImageSelectionListener getViewerOpenRequestHandler() {
        return imageInformation -> {
            ViewerFrame viewer = this.openViewer();
            final Future<Void> futureLoad = this.startLoadingImageOnViewer(viewer, imageInformation);
            viewer.addFrameListener((IcyFrameListener)new IcyFrameAdapter(){

                public void icyFrameClosed(IcyFrameEvent e) {
                    futureLoad.cancel(true);
                }
            });
        };
    }

    private ViewerFrame openViewer() {
        ViewerFrame viewer = new ViewerFrame();
        viewer.setVisible(true);
        return viewer;
    }

    private Future<Void> startLoadingImageOnViewer(ViewerFrame viewer, Image imageInformation) {
        return CompletableFuture.runAsync(() -> {
            try {
                viewer.setImageInstance(imageInformation);
            }
            catch (RuntimeException e) {
                MessageDialog.showDialog((String)"Icytomine - Error loading image", (String)e.getMessage(), (int)0);
                e.printStackTrace();
            }
        });
    }
}

