/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.roi;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.plugin.abstract_.Plugin;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.rectangle.Rectangle5D;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;

public class CropSequenceToROI
extends Plugin
implements ROIBlock {
    VarSequence input = new VarSequence("Sequence to crop", null);
    VarROIArray rois = new VarROIArray("List of ROI");
    VarGenericArray<Sequence[]> output = new VarGenericArray("List of crops", Sequence[].class, (Object)new Sequence[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Sequence seq = (Sequence)this.input.getValue(true);
        int nbROIs = ((ROI[])this.rois.getValue(true)).length;
        ArrayList<Sequence> crops = new ArrayList<Sequence>(nbROIs);
        int cpt = 1;
        int digitSize = 1 + (int)Math.log10(nbROIs);
        for (ROI roi : (ROI[])this.rois.getValue()) {
            int endT;
            int startT;
            int endZ;
            int startZ;
            Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)seq.getOMEXMLMetadata()));
            Rectangle5D.Integer region = roi.getBounds5D().toInteger();
            Rectangle region2d = region.toRectangle2D().getBounds();
            if (region.isInfiniteZ()) {
                startZ = 0;
                endZ = seq.getSizeZ();
            } else {
                startZ = Math.max(0, region.z);
                endZ = Math.min(seq.getSizeZ(), region.z + region.sizeZ);
            }
            if (region.isInfiniteT()) {
                startT = 0;
                endT = seq.getSizeT();
            } else {
                startT = Math.max(0, region.t);
                endT = (int)Math.min((long)seq.getSizeT(), (long)region.t + (long)region.sizeT);
            }
            result.beginUpdate();
            try {
                for (int t = startT; t < endT; ++t) {
                    for (int z = startZ; z < endZ; ++z) {
                        IcyBufferedImage img = seq.getImage(t, z);
                        if (img != null) {
                            img = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)img, (Rectangle)region2d, (int)region.c, (int)region.sizeC);
                        }
                        result.setImage(t - startT, z - startZ, (BufferedImage)img);
                    }
                }
            }
            finally {
                result.endUpdate();
            }
            result.setName(seq.getName() + "_crop" + StringUtil.toString((int)cpt, (int)digitSize));
            crops.add(result);
            ++cpt;
        }
        this.output.setValue((Object)crops.toArray(new Sequence[crops.size()]));
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("sequence to crop", (Var<?>)this.input);
        inputMap.add("list of ROI", (Var<?>)this.rois);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("list of crops", (Var<?>)this.output);
    }
}

