/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.link;

import icy.resource.ResourceUtil;
import icy.sequence.Sequence;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.protocols.gui.link.DragZone;
import plugins.adufour.protocols.gui.link.DropZone;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.util.MutableType;
import plugins.adufour.vars.util.TypeChangeListener;
import plugins.adufour.vars.util.VarListener;

public abstract class DragDropZone
extends JButton
implements VarListener<Boolean>,
TypeChangeListener {
    protected static final int DRAGnDROP_ACTION = 0x40000000;
    public static final int DEFAULT_ICON_SIZE = 13;
    public static final Image LINK_RIGHT = ResourceUtil.getAlphaIconAsImage((String)"round_arrow_right.png");
    public static final Image LINK_LEFT = ResourceUtil.getAlphaIconAsImage((String)"round_arrow_left.png");
    public static final Image PIN_LEFT = ResourceUtil.getAlphaIconAsImage((String)"pin_map_left.png");
    public static final Image PIN_RIGHT = ResourceUtil.getAlphaIconAsImage((String)"pin_map_right.png");
    public static final Image BUTTON = ResourceUtil.getAlphaIconAsImage((String)"round.png");
    private final Var<?> variable;
    private final int iconSize = 13;
    private Icon defaultIcon;
    private final Icon errorIcon;
    private final Icon emptyIcon = new ImageIcon(ResourceUtil.ICON_NULL);

    public static <T> DragDropZone createDropZone(Image image, WorkFlow workFlow, BlockDescriptor block, Var<T> input) {
        return new DropZone<T>(image, workFlow, block, input);
    }

    public static <T> DragDropZone createDragZone(Image image, WorkFlow workFlow, BlockDescriptor block, Var<T> variable) {
        return new DragZone<T>(image, workFlow, block, variable);
    }

    protected DragDropZone(String toolTipText, Image image, Var<?> variable) {
        super("");
        this.variable = variable;
        if (variable instanceof MutableType) {
            ((MutableType)variable).addTypeChangeListener((TypeChangeListener)this);
        }
        this.setToolTipText("<html><h4>" + toolTipText.replace("\n", "<br/>") + "</h4></html>");
        this.setDefaultLinkIcon();
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.errorIcon = this.getLinkIcon(Color.red);
        this.updateDefaultIcon();
        this.setDefaultLinkIcon();
        this.setPreferredSize(new Dimension(13, 13));
        this.setMinimumSize(this.getPreferredSize());
    }

    private void updateDefaultIcon() {
        Class dataType = null;
        if (this.variable != null) {
            dataType = this.variable.getType();
        }
        if (dataType != null) {
            if (this.variable instanceof VarGenericArray) {
                VarGenericArray array = (VarGenericArray)this.variable;
                dataType = array.getInnerType();
            } else if (dataType.isArray()) {
                dataType = dataType.getComponentType();
            }
        }
        this.defaultIcon = this.getLinkIcon(DragDropZone.getColor(dataType));
    }

    public Icon getLinkIcon(Color color) {
        BufferedImage myImage = new BufferedImage(13, 13, 2);
        Graphics2D g = (Graphics2D)((Image)myImage).getGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(color);
        g.fillOval(0, 0, 13, 13);
        g.setColor(Color.white);
        Path2D.Float arrow = new Path2D.Float();
        arrow.moveTo(2.5f, 5.0f);
        arrow.lineTo(6.0f, 5.0f);
        arrow.lineTo(6.0f, 2.5f);
        arrow.lineTo(11.0f, 6.5f);
        arrow.lineTo(6.0f, 10.5f);
        arrow.lineTo(6.0f, 8.0f);
        arrow.lineTo(2.5f, 8.0f);
        arrow.closePath();
        g.fill(arrow);
        return new ImageIcon(myImage);
    }

    public void setEmptyIcon() {
        this.setIcon(this.emptyIcon);
    }

    public void setDefaultLinkIcon() {
        this.setIcon(this.defaultIcon);
    }

    public void setErrorLinkIcon() {
        this.setIcon(this.errorIcon);
    }

    public void setIconSize(int size) {
        this.setDefaultLinkIcon();
    }

    public void dispose() {
        if (this.variable instanceof MutableType) {
            ((MutableType)this.variable).removeTypeChangeListener((TypeChangeListener)this);
        }
    }

    public void valueChanged(Var<Boolean> source, Boolean oldValue, Boolean newValue) {
        this.setDefaultLinkIcon();
    }

    public void referenceChanged(Var<Boolean> source, Var<? extends Boolean> oldReference, Var<? extends Boolean> newReference) {
        this.setDefaultLinkIcon();
    }

    public void typeChanged(Object source, Class<?> oldType, Class<?> newType) {
        this.updateDefaultIcon();
        this.setDefaultLinkIcon();
    }

    public static Color getColor(Class<?> type) {
        if (type == null) {
            return Color.gray;
        }
        if (type == Sequence.class) {
            return Color.blue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Color.orange.darker().darker();
        }
        if (type.isPrimitive() || Number.class.isAssignableFrom(type)) {
            return Color.magenta.darker().darker();
        }
        return Color.black;
    }
}

