/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.AbstractRoisPanel;
import icy.gui.component.button.IcyButton;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROIDescriptor;
import icy.roi.ROIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RoiSettingPanel
extends JPanel
implements ActionListener {
    private JScrollPane scrollPaneView;
    private JScrollPane scrollPaneExport;
    private JTable tableView;
    private JTable tableExport;
    private JPanel panelExportTop;
    private JLabel lblColumnSelectionFor;
    private JLabel lblNewLabel;
    private IcyButton upViewBtn;
    private IcyButton downViewBtn;
    private IcyButton upExportBtn;
    private IcyButton downExportBtn;
    List<AbstractRoisPanel.BaseColumnInfo> idsView;
    List<AbstractRoisPanel.BaseColumnInfo> idsExport;
    private AbstractTableModel viewModel;
    private AbstractTableModel exportModel;
    private final XMLPreferences prefView;
    private final XMLPreferences prefExport;

    public RoiSettingPanel(XMLPreferences viewPreferences, XMLPreferences exportPreferences) {
        this.prefView = viewPreferences;
        this.prefExport = exportPreferences;
        Set<ROIDescriptor> descriptors = ROIUtil.getROIDescriptors().keySet();
        this.idsView = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        this.idsExport = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (ROIDescriptor descriptor : descriptors) {
            this.idsView.add(new AbstractRoisPanel.BaseColumnInfo(descriptor, this.prefView, false));
            this.idsExport.add(new AbstractRoisPanel.BaseColumnInfo(descriptor, this.prefExport, true));
        }
        this.sortLists();
        this.initialize();
        this.viewModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Column name";
                    }
                    case 1: {
                        return "Visible";
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return RoiSettingPanel.this.idsView.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return RoiSettingPanel.this.idsView.get((int)rowIndex).descriptor.getName();
                    }
                    case 1: {
                        return RoiSettingPanel.this.idsView.get((int)rowIndex).visible;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    RoiSettingPanel.this.idsView.get((int)rowIndex).visible = (Boolean)aValue;
                }
            }
        };
        this.exportModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Column name";
                    }
                    case 1: {
                        return "Visible";
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return RoiSettingPanel.this.idsExport.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return RoiSettingPanel.this.idsExport.get((int)rowIndex).descriptor.getName();
                    }
                    case 1: {
                        return RoiSettingPanel.this.idsExport.get((int)rowIndex).visible;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    RoiSettingPanel.this.idsExport.get((int)rowIndex).visible = (Boolean)aValue;
                }
            }
        };
        this.tableView.setModel(this.viewModel);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(150);
        column.setMinWidth(80);
        column = columnModel.getColumn(1);
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
        this.tableExport.setModel(this.exportModel);
        columnModel = this.tableExport.getColumnModel();
        column = columnModel.getColumn(0);
        column.setPreferredWidth(150);
        column.setMinWidth(80);
        column = columnModel.getColumn(1);
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
        this.upViewBtn.addActionListener(this);
        this.downViewBtn.addActionListener(this);
        this.upExportBtn.addActionListener(this);
        this.downExportBtn.addActionListener(this);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        this.add((Component)splitPane, "Center");
        JPanel panelView = new JPanel();
        splitPane.setLeftComponent(panelView);
        panelView.setLayout(new BorderLayout(0, 0));
        this.scrollPaneView = new JScrollPane();
        panelView.add((Component)this.scrollPaneView, "Center");
        this.tableView = new JTable();
        this.tableView.setSelectionMode(1);
        this.tableView.setRowSelectionAllowed(true);
        this.scrollPaneView.setViewportView(this.tableView);
        JPanel panelViewTop = new JPanel();
        panelView.add((Component)panelViewTop, "North");
        GridBagLayout gbl_panelViewTop = new GridBagLayout();
        gbl_panelViewTop.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelViewTop.rowHeights = new int[]{14, 0};
        gbl_panelViewTop.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelViewTop.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelViewTop.setLayout(gbl_panelViewTop);
        this.lblColumnSelectionFor = new JLabel("Columns to display");
        GridBagConstraints gbc_lblColumnSelectionFor = new GridBagConstraints();
        gbc_lblColumnSelectionFor.insets = new Insets(0, 0, 0, 5);
        gbc_lblColumnSelectionFor.gridx = 0;
        gbc_lblColumnSelectionFor.gridy = 0;
        panelViewTop.add((Component)this.lblColumnSelectionFor, gbc_lblColumnSelectionFor);
        this.upViewBtn = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_UP));
        this.upViewBtn.setToolTipText("Change order of selected column(s)");
        this.upViewBtn.setFlat(true);
        GridBagConstraints gbc_upViewBtn = new GridBagConstraints();
        gbc_upViewBtn.insets = new Insets(0, 0, 0, 5);
        gbc_upViewBtn.gridx = 1;
        gbc_upViewBtn.gridy = 0;
        panelViewTop.add((Component)this.upViewBtn, gbc_upViewBtn);
        this.downViewBtn = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_DOWN));
        this.downViewBtn.setToolTipText("Change order of selected column(s)");
        this.downViewBtn.setFlat(true);
        GridBagConstraints gbc_downViewBtn = new GridBagConstraints();
        gbc_downViewBtn.gridx = 2;
        gbc_downViewBtn.gridy = 0;
        panelViewTop.add((Component)this.downViewBtn, gbc_downViewBtn);
        JPanel panelExport = new JPanel();
        splitPane.setRightComponent(panelExport);
        panelExport.setLayout(new BorderLayout(0, 0));
        this.scrollPaneExport = new JScrollPane();
        panelExport.add((Component)this.scrollPaneExport, "Center");
        this.tableExport = new JTable();
        this.tableExport.setSelectionMode(1);
        this.tableExport.setRowSelectionAllowed(true);
        this.scrollPaneExport.setViewportView(this.tableExport);
        this.panelExportTop = new JPanel();
        panelExport.add((Component)this.panelExportTop, "North");
        GridBagLayout gbl_panelExportTop = new GridBagLayout();
        gbl_panelExportTop.columnWidths = new int[]{0, 0, 0, 0};
        gbl_panelExportTop.rowHeights = new int[]{14, 0};
        gbl_panelExportTop.columnWeights = new double[]{1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panelExportTop.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelExportTop.setLayout(gbl_panelExportTop);
        this.lblNewLabel = new JLabel("Columns to export (XLS or CSV)");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.panelExportTop.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.upExportBtn = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_UP));
        this.upExportBtn.setToolTipText("Change order of selected column(s)");
        this.upExportBtn.setFlat(true);
        GridBagConstraints gbc_upExportBtn = new GridBagConstraints();
        gbc_upExportBtn.insets = new Insets(0, 0, 0, 5);
        gbc_upExportBtn.gridx = 1;
        gbc_upExportBtn.gridy = 0;
        this.panelExportTop.add((Component)this.upExportBtn, gbc_upExportBtn);
        this.downExportBtn = new IcyButton(new IcyIcon(ResourceUtil.ICON_ARROW_DOWN));
        this.downExportBtn.setToolTipText("Change order of selected column(s)");
        this.downExportBtn.setFlat(true);
        GridBagConstraints gbc_downExportBtn = new GridBagConstraints();
        gbc_downExportBtn.gridx = 2;
        gbc_downExportBtn.gridy = 0;
        this.panelExportTop.add((Component)this.downExportBtn, gbc_downExportBtn);
    }

    void fixOrders() {
        int order = 0;
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsView) {
            columnInfo.order = order++;
        }
        order = 0;
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsExport) {
            columnInfo.order = order++;
        }
    }

    void sortLists() {
        Collections.sort(this.idsView);
        Collections.sort(this.idsExport);
        this.fixOrders();
    }

    public void save() {
        this.sortLists();
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsView) {
            columnInfo.save(this.prefView);
        }
        for (AbstractRoisPanel.BaseColumnInfo columnInfo : this.idsExport) {
            columnInfo.save(this.prefExport);
        }
    }

    List<AbstractRoisPanel.BaseColumnInfo> getSelected(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos) {
        int[] selected;
        ArrayList<AbstractRoisPanel.BaseColumnInfo> result = new ArrayList<AbstractRoisPanel.BaseColumnInfo>();
        for (int index : selected = table.getSelectedRows()) {
            result.add(columnInfos.get(index));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreSelected(JTable table, List<AbstractRoisPanel.BaseColumnInfo> columnInfos, List<AbstractRoisPanel.BaseColumnInfo> selected) {
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        try {
            selectionModel.clearSelection();
            for (AbstractRoisPanel.BaseColumnInfo bci : selected) {
                int index = columnInfos.indexOf(bci);
                if (index < 0) continue;
                selectionModel.addSelectionInterval(index, index);
            }
        }
        finally {
            selectionModel.setValueIsAdjusting(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<AbstractRoisPanel.BaseColumnInfo> columnInfos;
        JTable table;
        Object source = e.getSource();
        if (source == this.upViewBtn || source == this.downViewBtn) {
            table = this.tableView;
            columnInfos = this.idsView;
        } else if (source == this.upExportBtn || source == this.downExportBtn) {
            table = this.tableExport;
            columnInfos = this.idsExport;
        } else {
            table = null;
            columnInfos = null;
        }
        int v = source == this.upViewBtn || source == this.upExportBtn ? -1 : (source == this.downViewBtn || source == this.downExportBtn ? 1 : 0);
        if (table != null && columnInfos != null) {
            List<AbstractRoisPanel.BaseColumnInfo> selected = this.getSelected(table, columnInfos);
            for (AbstractRoisPanel.BaseColumnInfo bci : selected) {
                bci.order += v;
            }
            if (v == -1) {
                int firstSelected = table.getSelectionModel().getMinSelectionIndex();
                if (firstSelected != -1 && firstSelected > 0) {
                    columnInfos.get((int)(firstSelected - 1)).order += table.getSelectedRowCount();
                }
            } else {
                int lastSelected = table.getSelectionModel().getMaxSelectionIndex();
                if (lastSelected != -1 && lastSelected < columnInfos.size() - 1) {
                    columnInfos.get((int)(lastSelected + 1)).order -= table.getSelectedRowCount();
                }
            }
            this.sortLists();
            this.restoreSelected(table, columnInfos, selected);
            this.viewModel.fireTableRowsUpdated(0, this.idsView.size() - 1);
            this.exportModel.fireTableRowsUpdated(0, this.idsExport.size() - 1);
        }
    }
}

