/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.plugin.PluginDescriptor;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import plugins.kernel.canvas.Canvas2DPlugin;

@Deprecated
public class PluginErrorReportPanel
extends JPanel {
    private static final long serialVersionUID = -2875740914347175762L;
    JTextPane errorMessageTextPane;
    JLabel label;
    JTextPane commentTextPane;
    JButton reportButton;
    JButton closeButton;
    JPanel bottomPanel;
    JScrollPane messageScrollPane;
    JPanel commentPanel;
    JPanel messagePanel;
    final PluginDescriptor plugin;
    final String devId;
    final String title;
    final String message;

    public PluginErrorReportPanel(PluginDescriptor plugin, String devId, String title, String message) {
        this.plugin = plugin;
        this.devId = devId;
        this.title = message;
        this.message = message;
        this.initialize();
        String str = plugin != null ? "<html><br>The plugin named <b>" + plugin.getName() + "</b> has encountered a problem" : "<html><br>The plugin from the developer <b>" + devId + "</b> has encountered a problem";
        str = StringUtil.isEmpty(title) ? str + ".<br><br>" : str + " :<br><i>" + title + "</i><br><br>";
        str = str + "Reporting this problem is anonymous and will help improving this plugin.<br><br></html>";
        this.label.setText(str);
        try {
            this.errorMessageTextPane.getStyledDocument().insertString(this.errorMessageTextPane.getStyledDocument().getLength(), message, new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            System.err.println("PluginErrorReport(...) error :");
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        this.errorMessageTextPane.setCaretPosition(0);
        final Document doc = this.commentTextPane.getDocument();
        try {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            StyleConstants.setItalic(attributes, true);
            StyleConstants.setForeground(attributes, Color.GRAY);
            doc.insertString(0, "Please type here your comment", attributes);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.commentTextPane.addMouseListener(new MouseAdapter(){
            boolean firstClickDone = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!this.firstClickDone) {
                    PluginErrorReportPanel.this.commentTextPane.setText("");
                    SimpleAttributeSet attributes = new SimpleAttributeSet();
                    StyleConstants.setItalic(attributes, false);
                    StyleConstants.setForeground(attributes, Color.BLACK);
                    try {
                        doc.insertString(0, " ", attributes);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    this.firstClickDone = true;
                }
            }
        });
    }

    PluginErrorReportPanel() {
        this(new PluginDescriptor(Canvas2DPlugin.class), null, null, "Error !!");
    }

    private void initialize() {
        this.label = this.plugin != null ? new JLabel("", this.plugin.getIcon(), 0) : new JLabel("", 0);
        this.errorMessageTextPane = new JTextPane();
        this.errorMessageTextPane.setEditable(false);
        this.errorMessageTextPane.setContentType("text/html");
        this.messageScrollPane = new JScrollPane(this.errorMessageTextPane);
        this.messagePanel = new JPanel();
        this.messagePanel.setBorder(new TitledBorder(null, "Message", 4, 2, null, null));
        this.messagePanel.setLayout(new BorderLayout(0, 0));
        this.messagePanel.add((Component)this.messageScrollPane, "Center");
        this.commentTextPane = new JTextPane();
        this.commentTextPane.setEditable(true);
        this.commentTextPane.setToolTipText("Give here some informations about the context or how to reproduce the bug to help the developer in resolving the issue");
        JScrollPane scComment = new JScrollPane(this.commentTextPane);
        scComment.setPreferredSize(new Dimension(23, 60));
        scComment.setMinimumSize(new Dimension(23, 60));
        this.commentPanel = new JPanel();
        this.commentPanel.setBorder(new TitledBorder(null, "Comment", 4, 2, null, null));
        this.commentPanel.setLayout(new BorderLayout(0, 0));
        this.commentPanel.add((Component)scComment, "Center");
        this.reportButton = new JButton("Report");
        this.closeButton = new JButton("Close");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.reportButton);
        buttonsPanel.add(this.closeButton);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout(0, 0));
        this.bottomPanel.add((Component)this.commentPanel, "Center");
        this.bottomPanel.add((Component)buttonsPanel, "South");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.label, "North");
        this.add((Component)this.messagePanel, "Center");
        this.add((Component)this.bottomPanel, "South");
    }
}

