/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.exception.TooLargeArrayException;
import icy.common.listener.ChangeListener;
import icy.file.FileUtil;
import icy.file.SequenceFileGroupImporter;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageEvent;
import icy.image.IcyBufferedImageListener;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageProvider;
import icy.image.colormap.IcyColorMap;
import icy.image.colormodel.IcyColorModel;
import icy.image.colormodel.IcyColorModelEvent;
import icy.image.colormodel.IcyColorModelListener;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.math.MathUtil;
import icy.math.Scaler;
import icy.math.UnitUtil;
import icy.painter.Overlay;
import icy.painter.OverlayEvent;
import icy.painter.OverlayListener;
import icy.painter.OverlayWrapper;
import icy.painter.Painter;
import icy.preferences.GeneralPreferences;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.DimensionId;
import icy.sequence.MetaDataUtil;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.sequence.SequenceModel;
import icy.sequence.SequencePersistent;
import icy.sequence.SequencePrefetcher;
import icy.sequence.SequenceUtil;
import icy.sequence.VolumetricImage;
import icy.sequence.edit.DataSequenceEdit;
import icy.sequence.edit.DefaultSequenceEdit;
import icy.sequence.edit.MetadataSequenceEdit;
import icy.sequence.edit.ROIAddSequenceEdit;
import icy.sequence.edit.ROIAddsSequenceEdit;
import icy.sequence.edit.ROIRemoveSequenceEdit;
import icy.sequence.edit.ROIRemovesSequenceEdit;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.CollectionUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.dimension.Dimension5D;
import icy.type.rectangle.Rectangle5D;
import icy.undo.IcyUndoManager;
import icy.undo.IcyUndoableEdit;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.OMEXMLMetadata;
import org.w3c.dom.Node;

public class Sequence
implements SequenceModel,
IcyColorModelListener,
IcyBufferedImageListener,
ChangeListener,
ROIListener,
OverlayListener {
    public static final String DEFAULT_NAME = "no name";
    @Deprecated
    public static final int TYPE_BYTE = 0;
    @Deprecated
    public static final int TYPE_DOUBLE = 5;
    @Deprecated
    public static final int TYPE_FLOAT = 4;
    @Deprecated
    public static final int TYPE_INT = 3;
    @Deprecated
    public static final int TYPE_SHORT = 2;
    @Deprecated
    public static final int TYPE_UNDEFINED = 32;
    public static final String ID_ID = "id";
    public static final String ID_NAME = "name";
    public static final String ID_POSITION_X = "positionX";
    public static final String ID_POSITION_Y = "positionY";
    public static final String ID_POSITION_Z = "positionZ";
    public static final String ID_POSITION_T = "positionT";
    public static final String ID_POSITION_T_OFFSET = "positionTOffset";
    public static final String ID_PIXEL_SIZE_X = "pixelSizeX";
    public static final String ID_PIXEL_SIZE_Y = "pixelSizeY";
    public static final String ID_PIXEL_SIZE_Z = "pixelSizeZ";
    public static final String ID_TIME_INTERVAL = "timeInterval";
    public static final String ID_CHANNEL_NAME = "channelName";
    public static final String ID_VIRTUAL = "virtual";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_POSITION_X = "positionX";
    public static final String PROPERTY_POSITION_Y = "positionY";
    public static final String PROPERTY_POSITION_Z = "positionZ";
    public static final String PROPERTY_POSITION_T = "positionT";
    public static final String PROPERTY_POSITION_T_OFFSET = "positionTOffset";
    public static final String PROPERTY_PIXEL_SIZE_X = "pixelSizeX";
    public static final String PROPERTY_PIXEL_SIZE_Y = "pixelSizeY";
    public static final String PROPERTY_PIXEL_SIZE_Z = "pixelSizeZ";
    public static final String PROPERTY_TIME_INTERVAL = "timeInterval";
    public static final String PROPERTY_CHANNEL_NAME = "channelName";
    public static final String PROPERTY_VIRTUAL = "virtual";
    protected static int id_gen = 1;
    protected final TreeMap<Integer, VolumetricImage> volumetricImages;
    protected final Set<Overlay> overlays;
    protected final Set<ROI> rois;
    protected final int id;
    protected IcyColorModel colorModel;
    protected LUT defaultLut;
    protected LUT userLut;
    protected String filename;
    protected ImageProvider imageProvider;
    protected int originResolution;
    protected Rectangle originXYRegion;
    protected int originZMin;
    protected int originZMax;
    protected int originTMin;
    protected int originTMax;
    protected int originChannel;
    protected final Map<String, String> properties;
    protected OMEXMLMetadata metaData;
    protected boolean autoUpdateChannelBounds;
    protected final SequencePersistent persistent;
    protected final IcyUndoManager undoManager;
    protected final UpdateEventHandler updater;
    protected final List<SequenceListener> listeners;
    protected final List<SequenceModel.SequenceModelListener> modelListeners;
    protected boolean channelBoundsInvalid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence(OMEXMLMetadata meta, String name) {
        Class<Sequence> clazz = Sequence.class;
        synchronized (Sequence.class) {
            double result;
            this.id = id_gen++;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.metaData = meta == null ? MetaDataUtil.createMetadata(name) : meta;
            if (!StringUtil.isEmpty(name)) {
                MetaDataUtil.setName(this.metaData, 0, name);
            } else if (StringUtil.isEmpty(MetaDataUtil.getName(this.metaData, 0))) {
                MetaDataUtil.setName(this.metaData, 0, DEFAULT_NAME + StringUtil.toString(this.id, 3));
            }
            this.filename = null;
            this.imageProvider = null;
            this.originResolution = 0;
            this.originXYRegion = null;
            this.originZMin = -1;
            this.originZMax = -1;
            this.originTMin = -1;
            this.originTMax = -1;
            this.originChannel = -1;
            this.properties = new HashMap<String, String>();
            if (Double.isNaN(MetaDataUtil.getPixelSizeX(this.metaData, 0, Double.NaN))) {
                MetaDataUtil.setPixelSizeX(this.metaData, 0, 1.0);
            }
            if (Double.isNaN(MetaDataUtil.getPixelSizeY(this.metaData, 0, Double.NaN))) {
                MetaDataUtil.setPixelSizeY(this.metaData, 0, 1.0);
            }
            if (Double.isNaN(MetaDataUtil.getPixelSizeZ(this.metaData, 0, Double.NaN))) {
                MetaDataUtil.setPixelSizeZ(this.metaData, 0, 1.0);
            }
            if (Double.isNaN(MetaDataUtil.getTimeInterval(this.metaData, 0, Double.NaN))) {
                double ti = MetaDataUtil.getTimeIntervalFromTimePositions(this.metaData, 0);
                if (ti != 0.0) {
                    MetaDataUtil.setTimeInterval(this.metaData, 0, ti);
                } else {
                    MetaDataUtil.setTimeInterval(this.metaData, 0, 1.0);
                }
            }
            if ((result = MetaDataUtil.getTimeInterval(this.metaData, 0, 0.0)) == 0.0 && (result = MetaDataUtil.getTimeIntervalFromTimePositions(this.metaData, 0)) != 0.0) {
                MetaDataUtil.setTimeInterval(this.metaData, 0, result);
            }
            this.volumetricImages = new TreeMap();
            this.overlays = new HashSet<Overlay>();
            this.rois = new HashSet<ROI>();
            this.persistent = new SequencePersistent(this);
            this.undoManager = new IcyUndoManager(this, GeneralPreferences.getHistorySize());
            this.updater = new UpdateEventHandler(this, false);
            this.listeners = new ArrayList<SequenceListener>();
            this.modelListeners = new ArrayList<SequenceModel.SequenceModelListener>();
            this.colorModel = null;
            this.defaultLut = null;
            this.userLut = null;
            this.channelBoundsInvalid = false;
            this.autoUpdateChannelBounds = true;
            return;
        }
    }

    @Deprecated
    public Sequence(OMEXMLMetadataImpl meta, String name) {
        this((OMEXMLMetadata)meta, name);
    }

    public Sequence(String name, IcyBufferedImage image) {
        this(name, (BufferedImage)image);
    }

    public Sequence(String name, BufferedImage image) {
        this((OMEXMLMetadata)null, name);
        this.addImage(image);
    }

    @Deprecated
    public Sequence(OMEXMLMetadataImpl meta) {
        this((OMEXMLMetadata)meta);
    }

    public Sequence(OMEXMLMetadata meta) {
        this(meta, null);
    }

    public Sequence(IcyBufferedImage image) {
        this((BufferedImage)image);
    }

    public Sequence(BufferedImage image) {
        this((OMEXMLMetadata)null, null);
        this.addImage(image);
    }

    public Sequence(String name) {
        this((OMEXMLMetadata)null, name);
    }

    public Sequence() {
        this((OMEXMLMetadata)null, null);
    }

    protected void finalize() throws Throwable {
        SequencePrefetcher.cancel(this);
        try {
            if (this.imageProvider != null && this.imageProvider instanceof Closeable) {
                ((Closeable)((Object)this.imageProvider)).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.finalize();
    }

    public void close() {
        Icy.getMainInterface().closeSequence(this);
    }

    public void closed() {
        SequencePrefetcher.cancel(this);
        while (!ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                if (GeneralPreferences.getSequencePersistence()) {
                    Sequence.this.saveXMLData();
                }
            }
        })) {
            ThreadUtil.sleep(10L);
        }
        this.fireClosedEvent();
    }

    public void copyFrom(Sequence source, boolean copyName) {
        this.copyDataFrom(source);
        this.copyMetaDataFrom(source, copyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDataFrom(Sequence source) {
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        this.beginUpdate();
        try {
            this.removeAllImages();
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    IcyBufferedImage img = source.getImage(t, z);
                    if (img != null) {
                        this.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.getCopy(img));
                        continue;
                    }
                    source.setImage(t, z, null);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void copyMetaDataFrom(Sequence source, boolean copyName) {
        this.metaData = OMEUtil.createOMEXMLMetadata(source.getOMEXMLMetadata());
        if (copyName) {
            this.setName(source.getName());
        }
        this.metaChanged(null);
    }

    public boolean createUndoPoint(String name) {
        try {
            this.undoManager.addEdit(new DefaultSequenceEdit(SequenceUtil.getCopy(this, false, false, false), this));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean createUndoDataPoint(String name) {
        try {
            this.undoManager.addEdit(new DataSequenceEdit(SequenceUtil.getCopy(this, false, false, false), this, name));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean createUndoMetadataPoint(String name) {
        try {
            this.undoManager.addEdit(new MetadataSequenceEdit(OMEUtil.createOMEXMLMetadata(this.metaData), this, name));
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean addUndoableEdit(IcyUndoableEdit edit) {
        if (edit != null) {
            return this.undoManager.addEdit(edit);
        }
        return false;
    }

    public boolean undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
            return true;
        }
        return false;
    }

    public boolean redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
            return true;
        }
        return false;
    }

    public void clearUndoManager() {
        this.getUndoManager().discardAllEdits();
    }

    protected void setColorModel(IcyColorModel cm) {
        if (this.colorModel != null) {
            this.colorModel.removeListener(this);
        }
        this.colorModel = cm;
        if (cm != null) {
            cm.addListener(this);
        }
        this.typeChanged();
        this.componentBoundsChanged(cm, -1);
        this.colormapChanged(cm, -1);
    }

    @Deprecated
    public Sequence convertToType(DataType dataType, boolean rescale) {
        return SequenceUtil.convertToType(this, dataType, rescale);
    }

    @Deprecated
    public Sequence convertToType(DataType dataType, Scaler scaler) {
        return SequenceUtil.convertToType(this, dataType, scaler);
    }

    @Deprecated
    public Sequence convertToType(int dataType, boolean signed, boolean rescale) {
        return this.convertToType(DataType.getDataType(dataType, signed), rescale);
    }

    @Deprecated
    public Sequence extractChannel(int channelNumber) {
        return SequenceUtil.extractChannel(this, channelNumber);
    }

    @Deprecated
    public Sequence extractChannels(List<Integer> channelNumbers) {
        return SequenceUtil.extractChannels(this, channelNumbers);
    }

    @Deprecated
    public Sequence extractBand(int bandNumber) {
        return this.extractChannel(bandNumber);
    }

    @Deprecated
    public Sequence extractBands(List<Integer> bandNumbers) {
        return this.extractChannels(bandNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<Integer, VolumetricImage> getVolumetricImages() {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            return new TreeMap<Integer, VolumetricImage>((SortedMap<Integer, VolumetricImage>)this.volumetricImages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<VolumetricImage> getAllVolumetricImage() {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            return new ArrayList<VolumetricImage>(this.volumetricImages.values());
        }
    }

    public Viewer getFirstViewer() {
        return Icy.getMainInterface().getFirstViewer(this);
    }

    public ArrayList<Viewer> getViewers() {
        return Icy.getMainInterface().getViewers(this);
    }

    public void setVolatile(boolean value) throws OutOfMemoryError, UnsupportedOperationException {
        boolean vol = this.isVolatile();
        try {
            for (IcyBufferedImage image : this.getAllImage()) {
                if (image == null) continue;
                image.setVolatile(value);
            }
            if (vol != value) {
                this.metaChanged("virtual");
            }
        }
        catch (OutOfMemoryError e) {
            for (IcyBufferedImage image : this.getAllImage()) {
                if (image == null) continue;
                image.setVolatile(!value);
            }
            throw e;
        }
    }

    public void setVirtual(boolean value) throws OutOfMemoryError, UnsupportedOperationException {
        this.setVolatile(value);
    }

    public boolean isVolatile() {
        IcyBufferedImage img = this.getFirstNonNullImage();
        if (img != null) {
            return img.isVolatile();
        }
        return false;
    }

    public boolean isVirtual() {
        return this.isVolatile();
    }

    public int getId() {
        return this.id;
    }

    public void setName(String value) {
        if (this.getName() != value) {
            MetaDataUtil.setName(this.metaData, 0, value);
            this.metaChanged("name");
        }
    }

    public String getName() {
        return MetaDataUtil.getName(this.metaData, 0);
    }

    public String getFilename(int t, int z, int c) {
        ImageProvider importer = this.getImageProvider();
        if (importer instanceof SequenceFileGroupImporter) {
            return ((SequenceFileGroupImporter)importer).getPath(z, t, c);
        }
        return this.filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        if (this.filename != filename) {
            this.filename = filename;
        }
    }

    public ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageProvider(ImageProvider value) {
        try {
            if (this.imageProvider != null && this.imageProvider instanceof Closeable) {
                ((Closeable)((Object)this.imageProvider)).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.imageProvider = value;
    }

    public String getOutputBaseName(String folderExt) {
        String result = this.getFilename();
        if (StringUtil.isEmpty(result)) {
            return "";
        }
        result = FileUtil.isDirectory(result = FileUtil.cleanPath(result)) ? result + "/" + folderExt : FileUtil.setExtension(result, "");
        return result;
    }

    public String getOutputExtension() {
        int channel;
        Rectangle xyRegion;
        int resolution;
        String result = "";
        int serieNum = this.getSeries();
        if (serieNum != 0) {
            result = result + "_S" + serieNum;
        }
        if ((resolution = this.getOriginResolution()) != 0) {
            result = result + "_R" + resolution;
        }
        if ((xyRegion = this.getOriginXYRegion()) != null) {
            result = result + "_XY(" + xyRegion.x + "," + xyRegion.y + "-" + xyRegion.width + "," + xyRegion.height + ")";
        }
        int zMin = this.getOriginZMin();
        int zMax = this.getOriginZMax();
        if (zMin != -1 || zMax != -1) {
            result = zMin == zMax ? result + "_Z" + zMin : result + "_Z(" + zMin + "-" + zMax + ")";
        }
        int tMin = this.getOriginTMin();
        int tMax = this.getOriginTMax();
        if (tMin != -1 || tMax != -1) {
            result = tMin == tMax ? result + "_T" + tMin : result + "_T(" + tMin + "-" + tMax + ")";
        }
        if ((channel = this.getOriginChannel()) != -1) {
            result = result + "_C" + channel;
        }
        return result;
    }

    public String getOutputFilename(boolean withExtension) {
        String result = this.getFilename();
        if (StringUtil.isEmpty(result)) {
            return "";
        }
        String ext = FileUtil.getFileExtension(result, true);
        result = this.getOutputBaseName(FileUtil.getFileName(result, false)) + this.getOutputExtension();
        if (withExtension) {
            result = result + ext;
        }
        return result;
    }

    public int getOriginResolution() {
        return this.originResolution;
    }

    public void setOriginResolution(int value) {
        this.originResolution = value;
    }

    public Rectangle getOriginXYRegion() {
        return this.originXYRegion;
    }

    public void setOriginXYRegion(Rectangle value) {
        this.originXYRegion = value != null ? new Rectangle(value) : null;
    }

    public int getOriginZMin() {
        return this.originZMin;
    }

    public void setOriginZMin(int value) {
        this.originZMin = value;
    }

    public int getOriginZMax() {
        return this.originZMax;
    }

    public void setOriginZMax(int value) {
        this.originZMax = value;
    }

    public int getOriginTMin() {
        return this.originTMin;
    }

    public void setOriginTMin(int value) {
        this.originTMin = value;
    }

    public int getOriginTMax() {
        return this.originTMax;
    }

    public void setOriginTMax(int value) {
        this.originTMax = value;
    }

    public int getOriginChannel() {
        return this.originChannel;
    }

    public void setOriginChannel(int value) {
        this.originChannel = value;
    }

    public void resetOriginInformation() {
        this.setSeries(0);
        this.setOriginChannel(-1);
        this.setOriginResolution(0);
        this.setOriginTMin(-1);
        this.setOriginTMax(-1);
        this.setOriginZMin(-1);
        this.setOriginZMax(-1);
        this.setOriginXYRegion(null);
    }

    public int getSeries() {
        String[] serieNums;
        String id = MetaDataUtil.getImageID(this.getOMEXMLMetadata(), 0);
        if (id.startsWith("Image:") && (serieNums = id.substring(6).split(":")).length > 0) {
            return StringUtil.parseInt(serieNums[0], 0);
        }
        return 0;
    }

    public void setSeries(int value) {
        String id = MetaDataUtil.getImageID(this.getOMEXMLMetadata(), 0);
        if (id.startsWith("Image:")) {
            MetaDataUtil.setImageID(this.getOMEXMLMetadata(), 0, "Image:" + value);
        }
    }

    @Deprecated
    public int getSerieIndex() {
        return this.getSeries();
    }

    public OMEXMLMetadata getOMEXMLMetadata() {
        return this.metaData;
    }

    public void setMetaData(OMEXMLMetadata metaData) {
        if (this.metaData != metaData) {
            this.metaData = metaData;
            this.metaChanged(null);
        }
    }

    @Deprecated
    public OMEXMLMetadataImpl getMetadata() {
        return (OMEXMLMetadataImpl)this.getOMEXMLMetadata();
    }

    @Deprecated
    public void setMetaData(OMEXMLMetadataImpl metaData) {
        this.setMetaData((OMEXMLMetadata)metaData);
    }

    public double[] getPosition() {
        return new double[]{this.getPositionX(), this.getPositionY(), this.getPositionZ()};
    }

    public double getPositionX() {
        return MetaDataUtil.getPositionX(this.metaData, 0, 0, 0, 0, 0.0);
    }

    public double getPositionY() {
        return MetaDataUtil.getPositionY(this.metaData, 0, 0, 0, 0, 0.0);
    }

    public double getPositionZ() {
        return MetaDataUtil.getPositionZ(this.metaData, 0, 0, 0, 0, 0.0);
    }

    public long getPositionT() {
        return this.getTimeStamp();
    }

    public long getTimeStamp() {
        return MetaDataUtil.getTimeStamp(this.metaData, 0, 0L);
    }

    public double getPositionTOffset(int t, int z, int c) {
        return MetaDataUtil.getPositionTOffset(this.metaData, 0, t, z, c, 0.0);
    }

    public void setPositionX(double value) {
        if (this.getPositionX() != value) {
            MetaDataUtil.setPositionX(this.metaData, 0, 0, 0, 0, value);
            this.metaChanged("positionX");
        }
    }

    public void setPositionY(double value) {
        if (this.getPositionY() != value) {
            MetaDataUtil.setPositionY(this.metaData, 0, 0, 0, 0, value);
            this.metaChanged("positionY");
        }
    }

    public void setPositionZ(double value) {
        if (this.getPositionZ() != value) {
            MetaDataUtil.setPositionZ(this.metaData, 0, 0, 0, 0, value);
            this.metaChanged("positionZ");
        }
    }

    public void setPositionT(long value) {
        this.setTimeStamp(value);
    }

    public void setTimeStamp(long value) {
        if (this.getTimeStamp() != value) {
            MetaDataUtil.setTimeStamp(this.metaData, 0, value);
            this.metaChanged("positionT");
        }
    }

    public void setPositionTOffset(int t, int z, int c, double value) {
        if (this.getPositionTOffset(t, z, c) != value) {
            MetaDataUtil.setPositionTOffset(this.metaData, 0, t, z, c, value);
            this.metaChanged("positionTOffset", t);
        }
    }

    public double[] getPixelSize() {
        return new double[]{this.getPixelSizeX(), this.getPixelSizeY(), this.getPixelSizeZ()};
    }

    public double getPixelSizeX() {
        return MetaDataUtil.getPixelSizeX(this.metaData, 0, 1.0);
    }

    public double getPixelSizeY() {
        return MetaDataUtil.getPixelSizeY(this.metaData, 0, 1.0);
    }

    public double getPixelSizeZ() {
        return MetaDataUtil.getPixelSizeZ(this.metaData, 0, 1.0);
    }

    public double getTimeInterval() {
        double result = MetaDataUtil.getTimeInterval(this.metaData, 0, 0.0);
        if (result == 0.0 && (result = MetaDataUtil.getTimeIntervalFromTimePositions(this.metaData, 0)) != 0.0) {
            MetaDataUtil.setTimeInterval(this.metaData, 0, result);
        }
        return result;
    }

    public void setPixelSizeX(double value) {
        if (this.getPixelSizeX() != value) {
            MetaDataUtil.setPixelSizeX(this.metaData, 0, value);
            this.metaChanged("pixelSizeX");
        }
    }

    public void setPixelSizeY(double value) {
        if (this.getPixelSizeY() != value) {
            MetaDataUtil.setPixelSizeY(this.metaData, 0, value);
            this.metaChanged("pixelSizeY");
        }
    }

    public void setPixelSizeZ(double value) {
        if (this.getPixelSizeZ() != value) {
            MetaDataUtil.setPixelSizeZ(this.metaData, 0, value);
            this.metaChanged("pixelSizeZ");
        }
    }

    public void setTimeInterval(double value) {
        if (MetaDataUtil.getTimeInterval(this.metaData, 0, 0.0) != value) {
            MetaDataUtil.setTimeInterval(this.metaData, 0, value);
            this.metaChanged("timeInterval");
        }
    }

    public double getPixelSizeScaling(int dimCompute, int dimResult) {
        double result;
        switch (dimCompute) {
            case 0: {
                return 0.0;
            }
            case 1: {
                result = this.getPixelSizeX();
                break;
            }
            case 2: {
                result = this.getPixelSizeX() * this.getPixelSizeY();
                break;
            }
            default: {
                result = this.getPixelSizeX() * this.getPixelSizeY() * this.getPixelSizeZ();
            }
        }
        result = Math.pow(result, (double)dimResult / (double)dimCompute);
        return result;
    }

    public UnitUtil.UnitPrefix getBestPixelSizeUnit(int dimCompute, int dimResult) {
        switch (dimResult) {
            case 0: {
                return UnitUtil.UnitPrefix.MICRO;
            }
            case 1: {
                return UnitUtil.getBestUnit(this.getPixelSizeScaling(dimCompute, dimResult) * 10.0, UnitUtil.UnitPrefix.MICRO, dimResult);
            }
            case 2: {
                return UnitUtil.getBestUnit(this.getPixelSizeScaling(dimCompute, dimResult) * 100.0, UnitUtil.UnitPrefix.MICRO, dimResult);
            }
        }
        return UnitUtil.getBestUnit(this.getPixelSizeScaling(dimCompute, dimResult) * 1000.0, UnitUtil.UnitPrefix.MICRO, dimResult);
    }

    public double calculateSize(double pixelNumber, int dimCompute, int dimResult) {
        return pixelNumber * this.getPixelSizeScaling(dimCompute, dimResult);
    }

    public double calculateSizeBestUnit(double pixelNumber, int dimCompute, int dimResult) {
        double value = this.calculateSize(pixelNumber, dimCompute, dimResult);
        UnitUtil.UnitPrefix unit = this.getBestPixelSizeUnit(dimCompute, dimResult);
        return UnitUtil.getValueInUnit(value, UnitUtil.UnitPrefix.MICRO, unit, dimResult);
    }

    public String calculateSize(double pixelNumber, int dimCompute, int dimResult, int significantDigit) {
        double value = this.calculateSize(pixelNumber, dimCompute, dimResult);
        String postFix = dimResult > 1 ? StringUtil.toString(dimResult) : "";
        UnitUtil.UnitPrefix unit = UnitUtil.getBestUnit(value, UnitUtil.UnitPrefix.MICRO, dimResult);
        value = UnitUtil.getValueInUnit(value, UnitUtil.UnitPrefix.MICRO, unit, dimResult);
        if (significantDigit != 0) {
            value = MathUtil.roundSignificant(value, significantDigit);
        }
        return StringUtil.toString(value) + " " + unit.toString() + "m" + postFix;
    }

    public String getDefaultChannelName(int index) {
        return MetaDataUtil.getDefaultChannelName(index);
    }

    public String getChannelName(int index) {
        return MetaDataUtil.getChannelName(this.metaData, 0, index);
    }

    public void setChannelName(int index, String value) {
        if (!StringUtil.equals(this.getChannelName(index), value)) {
            MetaDataUtil.setChannelName(this.metaData, 0, index, value);
            this.metaChanged("channelName", index);
        }
    }

    @Deprecated
    public boolean isComponentAbsBoundsAutoUpdate() {
        return this.getAutoUpdateChannelBounds();
    }

    @Deprecated
    public void setComponentAbsBoundsAutoUpdate(boolean value) {
    }

    public boolean getAutoUpdateChannelBounds() {
        return this.autoUpdateChannelBounds;
    }

    public void setAutoUpdateChannelBounds(boolean value) {
        if (this.autoUpdateChannelBounds != value) {
            if (value) {
                this.updateChannelsBounds(false);
            }
            this.autoUpdateChannelBounds = value;
        }
    }

    @Deprecated
    public boolean isComponentUserBoundsAutoUpdate() {
        return this.getAutoUpdateChannelBounds();
    }

    @Deprecated
    public void setComponentUserBoundsAutoUpdate(boolean value) {
        this.setAutoUpdateChannelBounds(value);
    }

    @Deprecated
    public boolean isAWTDispatching() {
        return this.updater.isAwtDispatch();
    }

    @Deprecated
    public void setAWTDispatching(boolean value) {
        this.updater.setAwtDispatch(value);
    }

    public void addListener(SequenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SequenceListener listener) {
        this.listeners.remove(listener);
    }

    public SequenceListener[] getListeners() {
        return this.listeners.toArray(new SequenceListener[0]);
    }

    @Override
    public void addSequenceModelListener(SequenceModel.SequenceModelListener listener) {
        this.modelListeners.add(listener);
    }

    @Override
    public void removeSequenceModelListener(SequenceModel.SequenceModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public IcyUndoManager getUndoManager() {
        return this.undoManager;
    }

    @Deprecated
    public boolean contains(Painter painter) {
        return this.getOverlay(painter) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Overlay overlay) {
        if (overlay == null) {
            return false;
        }
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            return this.overlays.contains(overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ROI roi) {
        if (roi == null) {
            return false;
        }
        Set<ROI> set = this.rois;
        synchronized (set) {
            return this.rois.contains(roi);
        }
    }

    @Deprecated
    public boolean hasPainter() {
        return this.hasOverlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ArrayList<Painter> getPainters() {
        ArrayList<Painter> result = new ArrayList<Painter>(this.overlays.size());
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (overlay instanceof OverlayWrapper) {
                    result.add(((OverlayWrapper)overlay).getPainter());
                    continue;
                }
                result.add(overlay);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HashSet<Painter> getPainterSet() {
        HashSet<Painter> result = new HashSet<Painter>(this.overlays.size());
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (overlay instanceof OverlayWrapper) {
                    result.add(((OverlayWrapper)overlay).getPainter());
                    continue;
                }
                result.add(overlay);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<Painter> getPainters(Class<? extends Painter> painterClass) {
        ArrayList<Painter> result = new ArrayList<Painter>(this.overlays.size());
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (overlay instanceof OverlayWrapper) {
                    if (!painterClass.isInstance(((OverlayWrapper)overlay).getPainter())) continue;
                    result.add(overlay);
                    continue;
                }
                if (!painterClass.isInstance(overlay)) continue;
                result.add(overlay);
            }
        }
        return result;
    }

    public boolean hasOverlay() {
        return this.overlays.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Overlay> getOverlays() {
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            return new ArrayList<Overlay>(this.overlays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Overlay> getOverlaySet() {
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            return new HashSet<Overlay>(this.overlays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOverlay(Class<? extends Overlay> overlayClass) {
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (!overlayClass.isInstance(overlay)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Overlay> List<T> getOverlays(Class<T> overlayClass) {
        ArrayList<Overlay> result = new ArrayList<Overlay>(this.overlays.size());
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (!overlayClass.isInstance(overlay)) continue;
                result.add(overlay);
            }
        }
        return result;
    }

    public boolean hasROI() {
        return this.rois.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI> getROIs(boolean sorted) {
        ArrayList<ROI> result;
        Set<ROI> set = this.rois;
        synchronized (set) {
            result = new ArrayList<ROI>(this.rois);
        }
        if (sorted) {
            Collections.sort(result, ROI.idComparator);
        }
        return result;
    }

    public ArrayList<ROI> getROIs() {
        return (ArrayList)this.getROIs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ROI> getROISet() {
        Set<ROI> set = this.rois;
        synchronized (set) {
            return new HashSet<ROI>(this.rois);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI2D> getROI2Ds(boolean sorted) {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI2D)) continue;
                result.add((ROI2D)roi);
            }
        }
        if (sorted) {
            Collections.sort(result, ROI.idComparator);
        }
        return result;
    }

    public ArrayList<ROI2D> getROI2Ds() {
        return (ArrayList)this.getROI2Ds(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI3D> getROI3Ds(boolean sorted) {
        ArrayList<ROI3D> result = new ArrayList<ROI3D>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI3D)) continue;
                result.add((ROI3D)roi);
            }
        }
        if (sorted) {
            Collections.sort(result, ROI.idComparator);
        }
        return result;
    }

    public ArrayList<ROI3D> getROI3Ds() {
        return (ArrayList)this.getROI3Ds(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasROI(Class<? extends ROI> roiClass) {
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roiClass.isInstance(roi)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ROI> List<T> getROIs(Class<T> roiClass, boolean sorted) {
        ArrayList<ROI> result = new ArrayList<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roiClass.isInstance(roi)) continue;
                result.add(roi);
            }
        }
        if (sorted) {
            Collections.sort(result, ROI.idComparator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<ROI> getROIs(Class<? extends ROI> roiClass) {
        ArrayList<ROI> result = new ArrayList<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roiClass.isInstance(roi)) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getROICount(Class<? extends ROI> roiClass) {
        int result = 0;
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roiClass.isInstance(roi)) continue;
                ++result;
            }
        }
        return result;
    }

    public boolean hasSelectedROI() {
        return this.getSelectedROI() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI getSelectedROI() {
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected()) continue;
                return roi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI2D getSelectedROI2D() {
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI2D) || !roi.isSelected()) continue;
                return (ROI2D)roi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3D getSelectedROI3D() {
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI3D) || !roi.isSelected()) continue;
                return (ROI3D)roi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ROI> getSelectedROISet(Class<? extends ROI> roiClass, boolean wantReadOnly) {
        HashSet<ROI> result = new HashSet<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected() || !roiClass.isInstance(roi) || !wantReadOnly && roi.isReadOnly()) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ROI> Set<T> getSelectedROISet(Class<T> roiClass) {
        HashSet<ROI> result = new HashSet<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected() || !roiClass.isInstance(roi)) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ROI> getSelectedROISet() {
        HashSet<ROI> result = new HashSet<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected()) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ROI> List<T> getSelectedROIs(Class<T> roiClass, boolean sorted, boolean wantReadOnly) {
        ArrayList<ROI> result = new ArrayList<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected() || !roiClass.isInstance(roi)) continue;
                result.add(roi);
            }
        }
        if (sorted) {
            Collections.sort(result, ROI.idComparator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ROI> getSelectedROIs(Class<? extends ROI> roiClass, boolean wantReadOnly) {
        ArrayList<ROI> result = new ArrayList<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected() || !roiClass.isInstance(roi) || !wantReadOnly && roi.isReadOnly()) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ROI> getSelectedROIs() {
        ArrayList<ROI> result = new ArrayList<ROI>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isSelected()) continue;
                result.add(roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ROI2D> getSelectedROI2Ds() {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI2D) || !roi.isSelected()) continue;
                result.add((ROI2D)roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ROI3D> getSelectedROI3Ds() {
        ArrayList<ROI3D> result = new ArrayList<ROI3D>(this.rois.size());
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!(roi instanceof ROI3D) || !roi.isSelected()) continue;
                result.add((ROI3D)roi);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI getFocusedROI() {
        Set<ROI> set = this.rois;
        synchronized (set) {
            for (ROI roi : this.rois) {
                if (!roi.isFocused()) continue;
                return roi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSelectedROI(ROI roi) {
        this.beginUpdate();
        try {
            Set<ROI> set = this.rois;
            synchronized (set) {
                for (ROI currentRoi : this.rois) {
                    if (currentRoi == roi) continue;
                    currentRoi.setSelected(false);
                }
            }
            if (this.contains(roi)) {
                roi.setSelected(true);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.endUpdate();
        }
        return false;
    }

    @Deprecated
    public boolean setSelectedROI(ROI roi, boolean exclusive) {
        if (exclusive) {
            return this.setSelectedROI(roi);
        }
        if (this.contains(roi)) {
            roi.setSelected(true);
            return true;
        }
        return false;
    }

    @Deprecated
    public void setSelectedROIs(ArrayList<ROI> selected) {
        this.setSelectedROIs((List<? extends ROI>)selected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedROIs(List<? extends ROI> selected) {
        ArrayList<ROI> oldSelected = this.getSelectedROIs();
        int newSelectedSize = selected == null ? 0 : selected.size();
        int oldSelectedSize = oldSelected.size();
        if (newSelectedSize == 0 && oldSelectedSize == 0) {
            return;
        }
        HashSet<Object> newSelected = selected != null ? new HashSet<ROI>(selected) : new HashSet();
        if (!CollectionUtil.equals(oldSelected, newSelected)) {
            this.beginUpdate();
            try {
                if (newSelectedSize > 0) {
                    for (ROI roi : this.getROIs()) {
                        roi.setSelected(newSelected.contains(roi));
                    }
                } else {
                    for (ROI roi : this.getROIs()) {
                        roi.setSelected(false);
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFocusedROI(ROI roi) {
        HashSet<ROI> listRoi = this.getROISet();
        this.beginUpdate();
        try {
            for (ROI currentRoi : listRoi) {
                if (currentRoi == roi) continue;
                currentRoi.internalUnfocus();
            }
            if (listRoi.contains(roi)) {
                roi.internalFocus();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.endUpdate();
        }
        return false;
    }

    public boolean addROIs(Collection<? extends ROI> rois, boolean canUndo) {
        if (!rois.isEmpty()) {
            ArrayList<ROI> addedRois = new ArrayList<ROI>();
            for (ROI rOI : rois) {
                if (!this.addROI(rOI, false)) continue;
                addedRois.add(rOI);
            }
            if (canUndo && !addedRois.isEmpty()) {
                this.addUndoableEdit(new ROIAddsSequenceEdit(this, addedRois));
            }
            return addedRois.size() == rois.size();
        }
        return true;
    }

    public boolean addROI(ROI roi) {
        return this.addROI(roi, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addROI(ROI roi, boolean canUndo) {
        if (roi == null || this.contains(roi)) {
            return false;
        }
        Set<ROI> set = this.rois;
        synchronized (set) {
            this.rois.add(roi);
        }
        roi.addListener(this);
        this.roiChanged(roi, SequenceEvent.SequenceEventType.ADDED);
        this.addOverlay(roi.getOverlay());
        if (canUndo) {
            this.addUndoableEdit(new ROIAddSequenceEdit(this, roi));
        }
        return true;
    }

    public boolean removeROI(ROI roi) {
        return this.removeROI(roi, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeROI(ROI roi, boolean canUndo) {
        if (this.contains(roi)) {
            this.removeOverlay(roi.getOverlay());
            Set<ROI> set = this.rois;
            synchronized (set) {
                this.rois.remove(roi);
            }
            roi.removeListener(this);
            this.roiChanged(roi, SequenceEvent.SequenceEventType.REMOVED);
            if (canUndo) {
                this.addUndoableEdit(new ROIRemoveSequenceEdit(this, roi));
            }
            return true;
        }
        return false;
    }

    public boolean removeROIs(Collection<? extends ROI> rois, boolean canUndo) {
        if (!rois.isEmpty()) {
            ArrayList<ROI> removedRois = new ArrayList<ROI>();
            for (ROI rOI : rois) {
                if (!this.removeROI(rOI, false)) continue;
                removedRois.add(rOI);
            }
            if (canUndo && !removedRois.isEmpty()) {
                this.addUndoableEdit(new ROIRemovesSequenceEdit(this, removedRois));
            }
            return removedRois.size() == rois.size();
        }
        return true;
    }

    public boolean removeSelectedROIs(boolean removeReadOnly) {
        return this.removeSelectedROIs(removeReadOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSelectedROIs(boolean removeReadOnly, boolean canUndo) {
        ArrayList<ROI> undoList = new ArrayList<ROI>();
        this.beginUpdate();
        try {
            Set<ROI> set = this.rois;
            synchronized (set) {
                for (ROI roi : this.getROIs()) {
                    if (!roi.isSelected() || !removeReadOnly && roi.isReadOnly()) continue;
                    this.removeOverlay(roi.getOverlay());
                    this.rois.remove(roi);
                    roi.removeListener(this);
                    this.roiChanged(roi, SequenceEvent.SequenceEventType.REMOVED);
                    undoList.add(roi);
                }
            }
            if (canUndo) {
                this.undoManager.addEdit(new ROIRemovesSequenceEdit(this, undoList));
            }
        }
        finally {
            this.endUpdate();
        }
        return !undoList.isEmpty();
    }

    public void removeAllROI() {
        this.removeAllROI(false);
    }

    public void removeAllROI(boolean canUndo) {
        if (!this.rois.isEmpty()) {
            ArrayList<ROI> allROIs = this.getROIs();
            for (ROI roi : allROIs) {
                this.removeROI(roi, false);
            }
            if (canUndo) {
                this.addUndoableEdit(new ROIRemovesSequenceEdit(this, allROIs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Overlay getOverlay(Painter painter) {
        if (painter instanceof Overlay) {
            return (Overlay)painter;
        }
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            for (Overlay overlay : this.overlays) {
                if (!(overlay instanceof OverlayWrapper) || ((OverlayWrapper)overlay).getPainter() != painter) continue;
                return overlay;
            }
        }
        return null;
    }

    @Deprecated
    public boolean addPainter(Painter painter) {
        if (painter instanceof Overlay) {
            return this.addOverlay((Overlay)painter);
        }
        if (painter == null || this.contains(painter)) {
            return false;
        }
        this.addOverlay(new OverlayWrapper(painter, "Overlay wrapper"));
        return true;
    }

    @Deprecated
    public boolean removePainter(Painter painter) {
        if (painter instanceof Overlay) {
            return this.removeOverlay((Overlay)painter);
        }
        return this.removeOverlay(this.getOverlay(painter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOverlay(Overlay overlay) {
        if (overlay == null || this.contains(overlay)) {
            return false;
        }
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            this.overlays.add(overlay);
        }
        overlay.addOverlayListener(this);
        this.overlayChanged(overlay, SequenceEvent.SequenceEventType.ADDED);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOverlay(Overlay overlay) {
        boolean result;
        Set<Overlay> set = this.overlays;
        synchronized (set) {
            result = this.overlays.remove(overlay);
        }
        if (result) {
            overlay.removeOverlayListener(this);
            this.overlayChanged(overlay, SequenceEvent.SequenceEventType.REMOVED);
        }
        return result;
    }

    public boolean isDataLoaded(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z, false);
        return img != null && img.isDataInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumetricImage getVolumetricImage(int t) {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            return this.volumetricImages.get(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VolumetricImage getFirstVolumetricImage() {
        Map.Entry<Integer, VolumetricImage> entry;
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            entry = this.volumetricImages.firstEntry();
        }
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VolumetricImage getLastVolumetricImage() {
        Map.Entry<Integer, VolumetricImage> entry;
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            entry = this.volumetricImages.lastEntry();
        }
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public VolumetricImage addVolumetricImage() {
        return this.setVolumetricImage(this.getSizeT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VolumetricImage setVolumetricImage(int t) {
        this.removeAllImages(t);
        VolumetricImage volImg = new VolumetricImage(this);
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            this.volumetricImages.put(t, volImg);
        }
        return volImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumetricImage addVolumetricImage(int t, VolumetricImage volImg) {
        if (volImg != null) {
            VolumetricImage result;
            this.beginUpdate();
            try {
                result = this.setVolumetricImage(t);
                for (Map.Entry<Integer, IcyBufferedImage> entry : volImg.getImages().entrySet()) {
                    this.setImage(t, (int)entry.getKey(), (BufferedImage)entry.getValue());
                }
            }
            finally {
                this.endUpdate();
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public boolean removeVolumetricImage(int t) {
        return this.removeAllImages(t);
    }

    public IcyBufferedImage getLastImage(int t) {
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg != null) {
            return volImg.getLastImage();
        }
        return null;
    }

    public IcyBufferedImage getFirstImage() {
        VolumetricImage volImg = this.getFirstVolumetricImage();
        if (volImg != null) {
            return volImg.getFirstImage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyBufferedImage getFirstNonNullImage() {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                IcyBufferedImage img = volImg.getFirstNonNullImage();
                if (img == null) continue;
                return img;
            }
        }
        return null;
    }

    public IcyBufferedImage getLastImage() {
        VolumetricImage volImg = this.getLastVolumetricImage();
        if (volImg != null) {
            return volImg.getLastImage();
        }
        return null;
    }

    @Override
    public IcyBufferedImage getImage(int t, int z, int c) {
        IcyBufferedImage src = this.getImage(t, z);
        if (src == null || c == -1) {
            return src;
        }
        return src.getImage(c);
    }

    protected IcyBufferedImage getImage(int t, int z, boolean loadData) {
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg != null) {
            IcyBufferedImage result = volImg.getImage(z);
            if (result != null && loadData) {
                result.loadData();
            }
            return result;
        }
        return null;
    }

    @Override
    public IcyBufferedImage getImage(int t, int z) {
        int i;
        IcyBufferedImage result = this.getImage(t, z, false);
        int sizeZ = this.getSizeZ();
        int sizeT = this.getSizeT();
        int prefetchRange = 2;
        for (i = -2; i <= 2; ++i) {
            int pt = t + i;
            if (pt == t || pt < 0 || pt >= sizeT) continue;
            SequencePrefetcher.prefetch(this, pt, z);
        }
        if (z > 0) {
            for (i = -2; i <= 2; ++i) {
                int pz = z + i;
                if (pz == z || pz < 0 || pz >= sizeZ) continue;
                SequencePrefetcher.prefetch(this, t, pz);
            }
        }
        return result;
    }

    public ArrayList<IcyBufferedImage> getImages(int t) {
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg != null) {
            return volImg.getAllImage();
        }
        return new ArrayList<IcyBufferedImage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<IcyBufferedImage> getAllImage() {
        ArrayList<IcyBufferedImage> result = new ArrayList<IcyBufferedImage>();
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                result.addAll(volImg.getAllImage());
            }
        }
        return result;
    }

    protected void setImage(VolumetricImage volImg, int z, BufferedImage image) throws IllegalArgumentException {
        if (volImg != null && volImg.getImage(z) != image) {
            IcyColorModel cm = this.colorModel;
            if (image == null) {
                volImg.removeImage(z);
            } else {
                boolean typeChange;
                IcyBufferedImage icyImg = image instanceof IcyBufferedImage ? (IcyBufferedImage)image : IcyBufferedImage.createFrom(image);
                boolean bl = typeChange = cm == null || this.isEmpty() || this.getNumImage() == 1 && volImg.getImage(z) != null;
                if (!typeChange && !this.isCompatible(icyImg)) {
                    throw new IllegalArgumentException("Sequence.setImage: image is not compatible !");
                }
                if (cm != null) {
                    icyImg.getIcyColorModel().setColorSpace(cm.getIcyColorSpace());
                }
                icyImg.setAutoUpdateChannelBounds(this.getAutoUpdateChannelBounds());
                volImg.setImage(z, icyImg);
                if (typeChange) {
                    this.metaChanged("virtual");
                }
            }
        }
    }

    public void setImage(int t, int z, BufferedImage image) throws IllegalArgumentException {
        boolean volImgCreated;
        if (image == null) {
            return;
        }
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg == null) {
            volImg = this.setVolumetricImage(t);
            volImgCreated = true;
        } else {
            volImgCreated = false;
        }
        try {
            this.setImage(volImg, z, image);
        }
        catch (IllegalArgumentException e) {
            if (volImgCreated) {
                this.removeAllImages(t);
            }
            throw e;
        }
    }

    public void addImage(BufferedImage image) throws IllegalArgumentException {
        int t = Math.max(this.getSizeT() - 1, 0);
        this.setImage(t, this.getSizeZ(t), image);
    }

    public void addImage(int t, BufferedImage image) throws IllegalArgumentException {
        this.setImage(t, this.getSizeZ(t), image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeImage(int t, int z) {
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg != null) {
            boolean result;
            this.beginUpdate();
            try {
                result = volImg.removeImage(z);
                if (volImg.isEmpty()) {
                    this.removeAllImages(t);
                }
            }
            finally {
                this.endUpdate();
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllImages(int t) {
        VolumetricImage volImg;
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            volImg = this.volumetricImages.remove(t);
        }
        if (volImg != null) {
            volImg.clear();
        }
        return volImg != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllImages() {
        this.beginUpdate();
        try {
            TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
            synchronized (treeMap) {
                while (!this.volumetricImages.isEmpty()) {
                    VolumetricImage volImg = this.volumetricImages.pollFirstEntry().getValue();
                    if (volImg == null) continue;
                    volImg.clear();
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public boolean removeAllImage(int t) {
        return this.removeAllImages(t);
    }

    @Deprecated
    public void removeAllImage() {
        this.removeAllImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packImageList() {
        this.beginUpdate();
        try {
            TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
            synchronized (treeMap) {
                for (Map.Entry<Integer, VolumetricImage> entry : this.volumetricImages.entrySet()) {
                    VolumetricImage volImg = entry.getValue();
                    int t = entry.getKey();
                    if (volImg == null) {
                        this.removeAllImages(t);
                        continue;
                    }
                    volImg.pack();
                    if (!volImg.isEmpty()) continue;
                    this.removeAllImages(t);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumImage() {
        int result = 0;
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                if (volImg == null) continue;
                result += volImg.getNumImage();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                if (volImg == null || volImg.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDefaultName() {
        return this.getName().startsWith(DEFAULT_NAME);
    }

    public boolean isDefaultChannelName(int index) {
        return StringUtil.equals(this.getChannelName(index), this.getDefaultChannelName(index));
    }

    @Deprecated
    public int getLength() {
        return this.getSizeT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSizeT() {
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            if (this.volumetricImages.isEmpty()) {
                return 0;
            }
            return this.volumetricImages.lastKey() + 1;
        }
    }

    @Deprecated
    public int getDepth() {
        return this.getSizeZ();
    }

    @Override
    public int getSizeZ() {
        int sizeT = this.getSizeT();
        int result = 0;
        for (int i = 0; i < sizeT; ++i) {
            result = Math.max(result, this.getSizeZ(i));
        }
        return result;
    }

    public int getSizeZ(int t) {
        if (t == -1) {
            return this.getSizeZ();
        }
        VolumetricImage volImg = this.getVolumetricImage(t);
        if (volImg != null) {
            return volImg.getSize();
        }
        return 0;
    }

    @Deprecated
    public int getNumComponents() {
        return this.getSizeC();
    }

    @Override
    public int getSizeC() {
        IcyColorModel cm = this.colorModel;
        if (cm != null) {
            return cm.getNumComponents();
        }
        return MetaDataUtil.getSizeC(this.metaData, 0);
    }

    public int getHeight() {
        return this.getSizeY();
    }

    @Override
    public int getSizeY() {
        IcyBufferedImage img = this.getFirstNonNullImage();
        if (img != null) {
            return img.getHeight();
        }
        return MetaDataUtil.getSizeY(this.metaData, 0);
    }

    public int getWidth() {
        return this.getSizeX();
    }

    @Override
    public int getSizeX() {
        IcyBufferedImage img = this.getFirstNonNullImage();
        if (img != null) {
            return img.getWidth();
        }
        return MetaDataUtil.getSizeX(this.metaData, 0);
    }

    public int getSize(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getSizeX();
            }
            case Y: {
                return this.getSizeY();
            }
            case C: {
                return this.getSizeC();
            }
            case Z: {
                return this.getSizeZ();
            }
            case T: {
                return this.getSizeT();
            }
        }
        return 0;
    }

    public Dimension getDimension2D() {
        return new Dimension(this.getSizeX(), this.getSizeY());
    }

    public Dimension5D.Integer getDimension5D() {
        return new Dimension5D.Integer(this.getSizeX(), this.getSizeY(), this.getSizeZ(), this.getSizeT(), this.getSizeC());
    }

    @Deprecated
    public Dimension getDimension() {
        return this.getDimension2D();
    }

    public Rectangle getBounds2D() {
        return new Rectangle(this.getSizeX(), this.getSizeY());
    }

    public Rectangle5D.Integer getBounds5D() {
        return new Rectangle5D.Integer(0, 0, 0, 0, 0, this.getSizeX(), this.getSizeY(), this.getSizeZ(), this.getSizeT(), this.getSizeC());
    }

    @Deprecated
    public Rectangle getBounds() {
        return this.getBounds2D();
    }

    public int getNumSample() {
        return this.getSizeX() * this.getSizeY() * this.getSizeC() * this.getSizeZ() * this.getSizeT();
    }

    public boolean isCompatible(IcyBufferedImage image) {
        if (this.colorModel == null || this.isEmpty()) {
            return true;
        }
        return image.getWidth() == this.getWidth() && image.getHeight() == this.getHeight() && this.isCompatible(image.getIcyColorModel());
    }

    public boolean isCompatible(IcyColorModel cm) {
        IcyColorModel currentCM = this.colorModel;
        if (currentCM == null) {
            return true;
        }
        return currentCM.isCompatible(cm);
    }

    public boolean isLutCompatible(LUT lut) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            cm = IcyColorModel.createInstance();
        }
        return lut.isCompatible(cm);
    }

    public IcyColorModel getColorModel() {
        return this.colorModel;
    }

    public LUT getDefaultLUT() {
        if (this.defaultLut == null || this.colorModel != null && !this.defaultLut.isCompatible(this.colorModel)) {
            this.defaultLut = this.createCompatibleLUT();
        }
        return this.defaultLut;
    }

    public boolean hasUserLUT() {
        return this.userLut != null;
    }

    public LUT getUserLUT() {
        if (this.userLut == null || this.colorModel != null && !this.userLut.isCompatible(this.colorModel)) {
            this.userLut = this.getDefaultLUT();
        }
        return this.userLut;
    }

    public void setUserLUT(LUT lut) {
        if (this.colorModel == null || lut.isCompatible(this.colorModel)) {
            this.userLut = lut;
        }
    }

    public LUT createCompatibleLUT() {
        IcyColorModel cm = this.colorModel;
        IcyColorModel result = cm == null ? IcyColorModel.createInstance() : IcyColorModel.createInstance(cm, true, true);
        return new LUT(result);
    }

    public IcyColorMap getDefaultColorMap(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm != null) {
            return cm.getColorMap(channel);
        }
        return this.getDefaultLUT().getLutChannel(channel).getColorMap();
    }

    public void setDefaultColormap(int channel, IcyColorMap map, boolean setAlpha) {
        IcyColorModel cm = this.colorModel;
        if (cm != null) {
            cm.setColorMap(channel, map, setAlpha);
        }
    }

    public void setDefaultColormap(int channel, IcyColorMap map) {
        this.setDefaultColormap(channel, map, map.isAlpha());
    }

    public IcyColorMap getColorMap(int channel) {
        LUT lut = this.getUserLUT();
        if (channel < lut.getNumChannel()) {
            return lut.getLutChannel(channel).getColorMap();
        }
        return null;
    }

    public void setColormap(int channel, IcyColorMap map, boolean setAlpha) {
        LUT lut = this.getUserLUT();
        if (channel < lut.getNumChannel()) {
            lut.getLutChannel(channel).setColorMap(map, setAlpha);
        }
    }

    public void setColormap(int channel, IcyColorMap map) {
        this.setColormap(channel, map, map.isAlpha());
    }

    public DataType getDataType_() {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return DataType.UNDEFINED;
        }
        return cm.getDataType_();
    }

    @Deprecated
    public int getDataType() {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return 32;
        }
        return cm.getDataType();
    }

    public boolean isFloatDataType() {
        return this.getDataType_().isFloat();
    }

    public boolean isSignedDataType() {
        return this.getDataType_().isSigned();
    }

    private static double[][] adjustBounds(double[][] curBounds, double[][] bounds) {
        if (bounds == null) {
            return curBounds;
        }
        for (int comp = 0; comp < bounds.length; ++comp) {
            double[] curCompBounds = curBounds[comp];
            double[] compBounds = bounds[comp];
            if (curCompBounds[0] < compBounds[0]) {
                compBounds[0] = curCompBounds[0];
            }
            if (!(curCompBounds[1] > compBounds[1])) continue;
            compBounds[1] = curCompBounds[1];
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recalculateAllImageChannelsBounds() {
        if (this.colorModel == null || this.isEmpty()) {
            return;
        }
        ArrayList<VolumetricImage> volumes = this.getAllVolumetricImage();
        this.beginUpdate();
        try {
            for (VolumetricImage volImg : volumes) {
                for (IcyBufferedImage img : volImg.getAllImage()) {
                    img.updateChannelsBounds();
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdateChannelsBounds() {
        IcyColorModel cm = this.colorModel;
        if (cm == null || this.isEmpty()) {
            return;
        }
        double[][] bounds = null;
        TreeMap<Integer, VolumetricImage> treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                for (IcyBufferedImage img : volImg.getAllImage()) {
                    if (img == null) continue;
                    bounds = Sequence.adjustBounds(img.getChannelsTypeBounds(), bounds);
                }
            }
        }
        cm.setComponentsAbsBounds(bounds);
        bounds = null;
        treeMap = this.volumetricImages;
        synchronized (treeMap) {
            for (VolumetricImage volImg : this.volumetricImages.values()) {
                for (IcyBufferedImage img : volImg.getAllImage()) {
                    if (img == null) continue;
                    bounds = Sequence.adjustBounds(img.getChannelsBounds(), bounds);
                }
            }
        }
        cm.setComponentsUserBounds(bounds);
    }

    public void updateChannelsBounds(boolean forceRecalculation) {
        if (forceRecalculation) {
            this.recalculateAllImageChannelsBounds();
        }
        this.internalUpdateChannelsBounds();
    }

    public void updateChannelsBounds() {
        this.updateChannelsBounds(true);
    }

    @Deprecated
    public void updateComponentsBounds(boolean forceRecalculation, boolean adjustByteToo) {
        this.updateChannelsBounds(forceRecalculation);
    }

    @Deprecated
    public void updateComponentsBounds(boolean forceRecalculation) {
        this.updateChannelsBounds(forceRecalculation);
    }

    @Deprecated
    public void updateComponentsBounds() {
        this.updateChannelsBounds(true);
    }

    public double getDataTypeMin() {
        return this.getDataType_().getMinValue();
    }

    public double getDataTypeMax() {
        return this.getDataType_().getMaxValue();
    }

    public double[] getDataTypeBounds() {
        return new double[]{this.getDataTypeMin(), this.getDataTypeMax()};
    }

    public double getChannelTypeMin(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return 0.0;
        }
        return cm.getComponentAbsMinValue(channel);
    }

    public double getChannelTypeMax(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return 0.0;
        }
        return cm.getComponentAbsMaxValue(channel);
    }

    public double[] getChannelTypeBounds(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return new double[]{0.0, 0.0};
        }
        return cm.getComponentAbsBounds(channel);
    }

    public double[][] getChannelsTypeBounds() {
        int sizeC = this.getSizeC();
        double[][] result = new double[sizeC][];
        for (int c = 0; c < sizeC; ++c) {
            result[c] = this.getChannelTypeBounds(c);
        }
        return result;
    }

    public double[] getChannelsGlobalTypeBounds() {
        int sizeC = this.getSizeC();
        double[] result = this.getChannelTypeBounds(0);
        for (int c = 1; c < sizeC; ++c) {
            double[] bounds = this.getChannelTypeBounds(c);
            result[0] = Math.min(bounds[0], result[0]);
            result[1] = Math.max(bounds[1], result[1]);
        }
        return result;
    }

    @Deprecated
    public double[] getChannelTypeGlobalBounds() {
        return this.getChannelsGlobalTypeBounds();
    }

    @Deprecated
    public double[] getGlobalChannelTypeBounds() {
        return this.getChannelTypeGlobalBounds();
    }

    @Deprecated
    public double getComponentAbsMinValue(int component) {
        return this.getChannelTypeMin(component);
    }

    @Deprecated
    public double getComponentAbsMaxValue(int component) {
        return this.getChannelTypeMax(component);
    }

    @Deprecated
    public double[] getComponentAbsBounds(int component) {
        return this.getChannelTypeBounds(component);
    }

    @Deprecated
    public double[][] getComponentsAbsBounds() {
        return this.getChannelsTypeBounds();
    }

    @Deprecated
    public double[] getGlobalComponentAbsBounds() {
        return this.getChannelsGlobalTypeBounds();
    }

    public double getChannelMin(int channel) {
        if (this.colorModel == null) {
            return 0.0;
        }
        return this.colorModel.getComponentUserMinValue(channel);
    }

    public double getChannelMax(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return 0.0;
        }
        return cm.getComponentUserMaxValue(channel);
    }

    public double[] getChannelBounds(int channel) {
        IcyColorModel cm = this.colorModel;
        if (cm == null) {
            return new double[]{0.0, 0.0};
        }
        if (this.channelBoundsInvalid) {
            this.channelBoundsInvalid = false;
            this.internalUpdateChannelsBounds();
        }
        return cm.getComponentUserBounds(channel);
    }

    public double[][] getChannelsBounds() {
        int sizeC = this.getSizeC();
        double[][] result = new double[sizeC][];
        for (int c = 0; c < sizeC; ++c) {
            result[c] = this.getChannelBounds(c);
        }
        return result;
    }

    public double[] getChannelsGlobalBounds() {
        int sizeC = this.getSizeC();
        double[] result = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        for (int c = 0; c < sizeC; ++c) {
            double[] bounds = this.getChannelBounds(c);
            if (bounds[0] < result[0]) {
                result[0] = bounds[0];
            }
            if (!(bounds[1] > result[1])) continue;
            result[1] = bounds[1];
        }
        return result;
    }

    @Deprecated
    public double getComponentUserMinValue(int component) {
        return this.getChannelMin(component);
    }

    @Deprecated
    public double getComponentUserMaxValue(int component) {
        return this.getChannelMax(component);
    }

    @Deprecated
    public double[] getComponentUserBounds(int component) {
        return this.getChannelBounds(component);
    }

    @Deprecated
    public double[][] getComponentsUserBounds() {
        return this.getChannelsBounds();
    }

    public void loadAllData() {
        for (IcyBufferedImage image : this.getAllImage()) {
            if (image == null) continue;
            image.loadData();
        }
    }

    public double getData(int t, int z, int c, int y, int x) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getData(x, y, c);
        }
        return 0.0;
    }

    public double getDataInterpolated(int t, double z, int c, double y, double x) {
        double ratioCurZ;
        int zi = (int)z;
        double ratioNextZ = z - (double)zi;
        double result = 0.0;
        IcyBufferedImage img = this.getImage(t, zi);
        if (img != null && (ratioCurZ = 1.0 - ratioNextZ) > 0.0) {
            result += img.getDataInterpolated(x, y, c) * ratioCurZ;
        }
        if ((img = this.getImage(t, zi + 1)) != null && ratioNextZ > 0.0) {
            result += img.getDataInterpolated(x, y, c) * ratioNextZ;
        }
        return result;
    }

    public Object getDataXYCZT() {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYCZTAsByte();
            }
            case SHORT: {
                return this.getDataXYCZTAsShort();
            }
            case INT: {
                return this.getDataXYCZTAsInt();
            }
            case FLOAT: {
                return this.getDataXYCZTAsFloat();
            }
            case DOUBLE: {
                return this.getDataXYCZTAsDouble();
            }
        }
        return null;
    }

    public Object getDataXYCZ(int t) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYCZAsByte(t);
            }
            case SHORT: {
                return this.getDataXYCZAsShort(t);
            }
            case INT: {
                return this.getDataXYCZAsInt(t);
            }
            case FLOAT: {
                return this.getDataXYCZAsFloat(t);
            }
            case DOUBLE: {
                return this.getDataXYCZAsDouble(t);
            }
        }
        return null;
    }

    public Object getDataXYC(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYC();
        }
        return null;
    }

    public Object getDataXY(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXY(c);
        }
        return null;
    }

    public Object getDataXYZT(int c) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYZTAsByte(c);
            }
            case SHORT: {
                return this.getDataXYZTAsShort(c);
            }
            case INT: {
                return this.getDataXYZTAsInt(c);
            }
            case FLOAT: {
                return this.getDataXYZTAsFloat(c);
            }
            case DOUBLE: {
                return this.getDataXYZTAsDouble(c);
            }
        }
        return null;
    }

    public Object getDataXYZ(int t, int c) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataXYZAsByte(t, c);
            }
            case SHORT: {
                return this.getDataXYZAsShort(t, c);
            }
            case INT: {
                return this.getDataXYZAsInt(t, c);
            }
            case FLOAT: {
                return this.getDataXYZAsFloat(t, c);
            }
            case DOUBLE: {
                return this.getDataXYZAsDouble(t, c);
            }
        }
        return null;
    }

    public Object getDataCopyXYCZT() {
        return this.getDataCopyXYCZT(null, 0);
    }

    public Object getDataCopyXYCZT(Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYCZTAsByte((byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyXYCZTAsShort((short[])out, off);
            }
            case INT: {
                return this.getDataCopyXYCZTAsInt((int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyXYCZTAsFloat((float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyXYCZTAsDouble((double[])out, off);
            }
        }
        return null;
    }

    public Object getDataCopyXYCZ(int t) {
        return this.getDataCopyXYCZ(t, null, 0);
    }

    public Object getDataCopyXYCZ(int t, Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYCZAsByte(t, (byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyXYCZAsShort(t, (short[])out, off);
            }
            case INT: {
                return this.getDataCopyXYCZAsInt(t, (int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyXYCZAsFloat(t, (float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyXYCZAsDouble(t, (double[])out, off);
            }
        }
        return null;
    }

    public Object getDataCopyXYC(int t, int z) {
        return this.getDataCopyXYC(t, z, null, 0);
    }

    public Object getDataCopyXYC(int t, int z, Object out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYC(out, off);
        }
        return out;
    }

    public Object getDataCopyXY(int t, int z, int c) {
        return this.getDataCopyXY(t, z, c, null, 0);
    }

    public Object getDataCopyXY(int t, int z, int c, Object out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXY(c, out, off);
        }
        return out;
    }

    public Object getDataCopyCXYZT() {
        return this.getDataCopyCXYZT(null, 0);
    }

    public Object getDataCopyCXYZT(Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyCXYZTAsByte((byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyCXYZTAsShort((short[])out, off);
            }
            case INT: {
                return this.getDataCopyCXYZTAsInt((int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyCXYZTAsFloat((float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyCXYZTAsDouble((double[])out, off);
            }
        }
        return null;
    }

    public Object getDataCopyCXYZ(int t) {
        return this.getDataCopyCXYZ(t, null, 0);
    }

    public Object getDataCopyCXYZ(int t, Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyCXYZAsByte(t, (byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyCXYZAsShort(t, (short[])out, off);
            }
            case INT: {
                return this.getDataCopyCXYZAsInt(t, (int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyCXYZAsFloat(t, (float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyCXYZAsDouble(t, (double[])out, off);
            }
        }
        return null;
    }

    public Object getDataCopyCXY(int t, int z) {
        return this.getDataCopyCXY(t, z, null, 0);
    }

    public Object getDataCopyCXY(int t, int z, Object out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXY(out, off);
        }
        return out;
    }

    public Object getDataCopyC(int t, int z, int x, int y) {
        return this.getDataCopyC(t, z, x, y, null, 0);
    }

    public Object getDataCopyC(int t, int z, int x, int y, Object out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyC(x, y, out, off);
        }
        return out;
    }

    public Object getDataCopyXYZT(int c) {
        return this.getDataCopyXYZT(c, null, 0);
    }

    public Object getDataCopyXYZT(int c, Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYZTAsByte(c, (byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyXYZTAsShort(c, (short[])out, off);
            }
            case INT: {
                return this.getDataCopyXYZTAsInt(c, (int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyXYZTAsFloat(c, (float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyXYZTAsDouble(c, (double[])out, off);
            }
        }
        return null;
    }

    public Object getDataCopyXYZ(int t, int c) {
        return this.getDataCopyXYZ(t, c, null, 0);
    }

    public Object getDataCopyXYZ(int t, int c, Object out, int off) {
        switch (this.getDataType_().getJavaType()) {
            case BYTE: {
                return this.getDataCopyXYZAsByte(t, c, (byte[])out, off);
            }
            case SHORT: {
                return this.getDataCopyXYZAsShort(t, c, (short[])out, off);
            }
            case INT: {
                return this.getDataCopyXYZAsInt(t, c, (int[])out, off);
            }
            case FLOAT: {
                return this.getDataCopyXYZAsFloat(t, c, (float[])out, off);
            }
            case DOUBLE: {
                return this.getDataCopyXYZAsDouble(t, c, (double[])out, off);
            }
        }
        return null;
    }

    public byte[][][][] getDataXYCZTAsByte() {
        int sizeT = this.getSizeT();
        byte[][][][] result = new byte[sizeT][][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYCZAsByte(t);
        }
        return result;
    }

    public short[][][][] getDataXYCZTAsShort() {
        int sizeT = this.getSizeT();
        short[][][][] result = new short[sizeT][][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYCZAsShort(t);
        }
        return result;
    }

    public int[][][][] getDataXYCZTAsInt() {
        int sizeT = this.getSizeT();
        int[][][][] result = new int[sizeT][][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYCZAsInt(t);
        }
        return result;
    }

    public float[][][][] getDataXYCZTAsFloat() {
        int sizeT = this.getSizeT();
        float[][][][] result = new float[sizeT][][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYCZAsFloat(t);
        }
        return result;
    }

    public double[][][][] getDataXYCZTAsDouble() {
        int sizeT = this.getSizeT();
        double[][][][] result = new double[sizeT][][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYCZAsDouble(t);
        }
        return result;
    }

    public byte[][][] getDataXYCZAsByte(int t) {
        int sizeZ = this.getSizeZ(t);
        byte[][][] result = new byte[sizeZ][][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYCAsByte(t, z);
        }
        return result;
    }

    public short[][][] getDataXYCZAsShort(int t) {
        int sizeZ = this.getSizeZ(t);
        short[][][] result = new short[sizeZ][][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYCAsShort(t, z);
        }
        return result;
    }

    public int[][][] getDataXYCZAsInt(int t) {
        int sizeZ = this.getSizeZ(t);
        int[][][] result = new int[sizeZ][][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYCAsInt(t, z);
        }
        return result;
    }

    public float[][][] getDataXYCZAsFloat(int t) {
        int sizeZ = this.getSizeZ(t);
        float[][][] result = new float[sizeZ][][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYCAsFloat(t, z);
        }
        return result;
    }

    public double[][][] getDataXYCZAsDouble(int t) {
        int sizeZ = this.getSizeZ(t);
        double[][][] result = new double[sizeZ][][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYCAsDouble(t, z);
        }
        return result;
    }

    public byte[][] getDataXYCAsByte(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYCAsByte();
        }
        return null;
    }

    public short[][] getDataXYCAsShort(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYCAsShort();
        }
        return null;
    }

    public int[][] getDataXYCAsInt(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYCAsInt();
        }
        return null;
    }

    public float[][] getDataXYCAsFloat(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYCAsFloat();
        }
        return null;
    }

    public double[][] getDataXYCAsDouble(int t, int z) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYCAsDouble();
        }
        return null;
    }

    public byte[] getDataXYAsByte(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYAsByte(c);
        }
        return null;
    }

    public short[] getDataXYAsShort(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYAsShort(c);
        }
        return null;
    }

    public int[] getDataXYAsInt(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYAsInt(c);
        }
        return null;
    }

    public float[] getDataXYAsFloat(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYAsFloat(c);
        }
        return null;
    }

    public double[] getDataXYAsDouble(int t, int z, int c) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataXYAsDouble(c);
        }
        return null;
    }

    public byte[][][] getDataXYZTAsByte(int c) {
        int sizeT = this.getSizeT();
        byte[][][] result = new byte[sizeT][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYZAsByte(t, c);
        }
        return result;
    }

    public short[][][] getDataXYZTAsShort(int c) {
        int sizeT = this.getSizeT();
        short[][][] result = new short[sizeT][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYZAsShort(t, c);
        }
        return result;
    }

    public int[][][] getDataXYZTAsInt(int c) {
        int sizeT = this.getSizeT();
        int[][][] result = new int[sizeT][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYZAsInt(t, c);
        }
        return result;
    }

    public float[][][] getDataXYZTAsFloat(int c) {
        int sizeT = this.getSizeT();
        float[][][] result = new float[sizeT][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYZAsFloat(t, c);
        }
        return result;
    }

    public double[][][] getDataXYZTAsDouble(int c) {
        int sizeT = this.getSizeT();
        double[][][] result = new double[sizeT][][];
        for (int t = 0; t < sizeT; ++t) {
            result[t] = this.getDataXYZAsDouble(t, c);
        }
        return result;
    }

    public byte[][] getDataXYZAsByte(int t, int c) {
        int sizeZ = this.getSizeZ(t);
        byte[][] result = new byte[sizeZ][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYAsByte(t, z, c);
        }
        return result;
    }

    public short[][] getDataXYZAsShort(int t, int c) {
        int sizeZ = this.getSizeZ(t);
        short[][] result = new short[sizeZ][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYAsShort(t, z, c);
        }
        return result;
    }

    public int[][] getDataXYZAsInt(int t, int c) {
        int sizeZ = this.getSizeZ(t);
        int[][] result = new int[sizeZ][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYAsInt(t, z, c);
        }
        return result;
    }

    public float[][] getDataXYZAsFloat(int t, int c) {
        int sizeZ = this.getSizeZ(t);
        float[][] result = new float[sizeZ][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYAsFloat(t, z, c);
        }
        return result;
    }

    public double[][] getDataXYZAsDouble(int t, int c) {
        int sizeZ = this.getSizeZ(t);
        double[][] result = new double[sizeZ][];
        for (int z = 0; z < sizeZ; ++z) {
            result[z] = this.getDataXYAsDouble(t, z, c);
        }
        return result;
    }

    public byte[] getDataCopyXYCZTAsByte() {
        return this.getDataCopyXYCZTAsByte(null, 0);
    }

    public byte[] getDataCopyXYCZTAsByte(byte[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYCZAsByte(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public short[] getDataCopyXYCZTAsShort() {
        return this.getDataCopyXYCZTAsShort(null, 0);
    }

    public short[] getDataCopyXYCZTAsShort(short[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYCZAsShort(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public int[] getDataCopyXYCZTAsInt() {
        return this.getDataCopyXYCZTAsInt(null, 0);
    }

    public int[] getDataCopyXYCZTAsInt(int[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYCZAsInt(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public float[] getDataCopyXYCZTAsFloat() {
        return this.getDataCopyXYCZTAsFloat(null, 0);
    }

    public float[] getDataCopyXYCZTAsFloat(float[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYCZAsFloat(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public double[] getDataCopyXYCZTAsDouble() {
        return this.getDataCopyXYCZTAsDouble(null, 0);
    }

    public double[] getDataCopyXYCZTAsDouble(double[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYCZAsDouble(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public byte[] getDataCopyXYCZAsByte(int t) {
        return this.getDataCopyXYCZAsByte(t, null, 0);
    }

    public byte[] getDataCopyXYCZAsByte(int t, byte[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYCAsByte(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public short[] getDataCopyXYCZAsShort(int t) {
        return this.getDataCopyXYCZAsShort(t, null, 0);
    }

    public short[] getDataCopyXYCZAsShort(int t, short[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYCAsShort(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public int[] getDataCopyXYCZAsInt(int t) {
        return this.getDataCopyXYCZAsInt(t, null, 0);
    }

    public int[] getDataCopyXYCZAsInt(int t, int[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYCAsInt(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public float[] getDataCopyXYCZAsFloat(int t) {
        return this.getDataCopyXYCZAsFloat(t, null, 0);
    }

    public float[] getDataCopyXYCZAsFloat(int t, float[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYCAsFloat(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public double[] getDataCopyXYCZAsDouble(int t) {
        return this.getDataCopyXYCZAsDouble(t, null, 0);
    }

    public double[] getDataCopyXYCZAsDouble(int t, double[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYCAsDouble(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public byte[] getDataCopyXYCAsByte(int t, int z) {
        return this.getDataCopyXYCAsByte(t, z, null, 0);
    }

    public byte[] getDataCopyXYCAsByte(int t, int z, byte[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYCAsByte(out, off);
        }
        return out;
    }

    public short[] getDataCopyXYCAsShort(int t, int z) {
        return this.getDataCopyXYCAsShort(t, z, null, 0);
    }

    public short[] getDataCopyXYCAsShort(int t, int z, short[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYCAsShort(out, off);
        }
        return out;
    }

    public int[] getDataCopyXYCAsInt(int t, int z) {
        return this.getDataCopyXYCAsInt(t, z, null, 0);
    }

    public int[] getDataCopyXYCAsInt(int t, int z, int[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYCAsInt(out, off);
        }
        return out;
    }

    public float[] getDataCopyXYCAsFloat(int t, int z) {
        return this.getDataCopyXYCAsFloat(t, z, null, 0);
    }

    public float[] getDataCopyXYCAsFloat(int t, int z, float[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYCAsFloat(out, off);
        }
        return out;
    }

    public double[] getDataCopyXYCAsDouble(int t, int z) {
        return this.getDataCopyXYCAsDouble(t, z, null, 0);
    }

    public double[] getDataCopyXYCAsDouble(int t, int z, double[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYCAsDouble(out, off);
        }
        return out;
    }

    public byte[] getDataCopyXYAsByte(int t, int z, int c) {
        return this.getDataCopyXYAsByte(t, z, c, null, 0);
    }

    public byte[] getDataCopyXYAsByte(int t, int z, int c, byte[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYAsByte(c, out, off);
        }
        return out;
    }

    public short[] getDataCopyXYAsShort(int t, int z, int c) {
        return this.getDataCopyXYAsShort(t, z, c, null, 0);
    }

    public short[] getDataCopyXYAsShort(int t, int z, int c, short[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYAsShort(c, out, off);
        }
        return out;
    }

    public int[] getDataCopyXYAsInt(int t, int z, int c) {
        return this.getDataCopyXYAsInt(t, z, c, null, 0);
    }

    public int[] getDataCopyXYAsInt(int t, int z, int c, int[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYAsInt(c, out, off);
        }
        return out;
    }

    public float[] getDataCopyXYAsFloat(int t, int z, int c) {
        return this.getDataCopyXYAsFloat(t, z, c, null, 0);
    }

    public float[] getDataCopyXYAsFloat(int t, int z, int c, float[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYAsFloat(c, out, off);
        }
        return out;
    }

    public double[] getDataCopyXYAsDouble(int t, int z, int c) {
        return this.getDataCopyXYAsDouble(t, z, c, null, 0);
    }

    public double[] getDataCopyXYAsDouble(int t, int z, int c, double[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyXYAsDouble(c, out, off);
        }
        return out;
    }

    public byte[] getDataCopyCXYZTAsByte() {
        return this.getDataCopyCXYZTAsByte(null, 0);
    }

    public byte[] getDataCopyCXYZTAsByte(byte[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyCXYZAsByte(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public short[] getDataCopyCXYZTAsShort() {
        return this.getDataCopyCXYZTAsShort(null, 0);
    }

    public short[] getDataCopyCXYZTAsShort(short[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyCXYZAsShort(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public int[] getDataCopyCXYZTAsInt() {
        return this.getDataCopyCXYZTAsInt(null, 0);
    }

    public int[] getDataCopyCXYZTAsInt(int[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyCXYZAsInt(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public float[] getDataCopyCXYZTAsFloat() {
        return this.getDataCopyCXYZTAsFloat(null, 0);
    }

    public float[] getDataCopyCXYZTAsFloat(float[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyCXYZAsFloat(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public double[] getDataCopyCXYZTAsDouble() {
        return this.getDataCopyCXYZTAsDouble(null, 0);
    }

    public double[] getDataCopyCXYZTAsDouble(double[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyCXYZAsDouble(t, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public byte[] getDataCopyCXYZAsByte(int t) {
        return this.getDataCopyCXYZAsByte(t, null, 0);
    }

    public byte[] getDataCopyCXYZAsByte(int t, byte[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyCXYAsByte(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public short[] getDataCopyCXYZAsShort(int t) {
        return this.getDataCopyCXYZAsShort(t, null, 0);
    }

    public short[] getDataCopyCXYZAsShort(int t, short[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyCXYAsShort(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public int[] getDataCopyCXYZAsInt(int t) {
        return this.getDataCopyCXYZAsInt(t, null, 0);
    }

    public int[] getDataCopyCXYZAsInt(int t, int[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyCXYAsInt(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public float[] getDataCopyCXYZAsFloat(int t) {
        return this.getDataCopyCXYZAsFloat(t, null, 0);
    }

    public float[] getDataCopyCXYZAsFloat(int t, float[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyCXYAsFloat(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public double[] getDataCopyCXYZAsDouble(int t) {
        return this.getDataCopyCXYZAsDouble(t, null, 0);
    }

    public double[] getDataCopyCXYZAsDouble(int t, double[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeC();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyCXYAsDouble(t, z, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public byte[] getDataCopyCXYAsByte(int t, int z) {
        return this.getDataCopyCXYAsByte(t, z, null, 0);
    }

    public byte[] getDataCopyCXYAsByte(int t, int z, byte[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXYAsByte(out, off);
        }
        return out;
    }

    public short[] getDataCopyCXYAsShort(int t, int z) {
        return this.getDataCopyCXYAsShort(t, z, null, 0);
    }

    public short[] getDataCopyCXYAsShort(int t, int z, short[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXYAsShort(out, off);
        }
        return out;
    }

    public int[] getDataCopyCXYAsInt(int t, int z) {
        return this.getDataCopyCXYAsInt(t, z, null, 0);
    }

    public int[] getDataCopyCXYAsInt(int t, int z, int[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXYAsInt(out, off);
        }
        return out;
    }

    public float[] getDataCopyCXYAsFloat(int t, int z) {
        return this.getDataCopyCXYAsFloat(t, z, null, 0);
    }

    public float[] getDataCopyCXYAsFloat(int t, int z, float[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXYAsFloat(out, off);
        }
        return out;
    }

    public double[] getDataCopyCXYAsDouble(int t, int z) {
        return this.getDataCopyCXYAsDouble(t, z, null, 0);
    }

    public double[] getDataCopyCXYAsDouble(int t, int z, double[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCXYAsDouble(out, off);
        }
        return out;
    }

    public byte[] getDataCopyCAsByte(int t, int z, int x, int y) {
        return this.getDataCopyCAsByte(t, z, x, y, null, 0);
    }

    public byte[] getDataCopyCAsByte(int t, int z, int x, int y, byte[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCAsByte(x, y, out, off);
        }
        return out;
    }

    public short[] getDataCopyCAsShort(int t, int z, int x, int y) {
        return this.getDataCopyCAsShort(t, z, x, y, null, 0);
    }

    public short[] getDataCopyCAsShort(int t, int z, int x, int y, short[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCAsShort(x, y, out, off);
        }
        return out;
    }

    public int[] getDataCopyCAsInt(int t, int z, int x, int y) {
        return this.getDataCopyCAsInt(t, z, x, y, null, 0);
    }

    public int[] getDataCopyCAsInt(int t, int z, int x, int y, int[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCAsInt(x, y, out, off);
        }
        return out;
    }

    public float[] getDataCopyCAsFloat(int t, int z, int x, int y) {
        return this.getDataCopyCAsFloat(t, z, x, y, null, 0);
    }

    public float[] getDataCopyCAsFloat(int t, int z, int x, int y, float[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCAsFloat(x, y, out, off);
        }
        return out;
    }

    public double[] getDataCopyCAsDouble(int t, int z, int x, int y) {
        return this.getDataCopyCAsDouble(t, z, x, y, null, 0);
    }

    public double[] getDataCopyCAsDouble(int t, int z, int x, int y, double[] out, int off) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            return img.getDataCopyCAsDouble(x, y, out, off);
        }
        return out;
    }

    public byte[] getDataCopyXYZTAsByte(int c) {
        return this.getDataCopyXYZTAsByte(c, null, 0);
    }

    public byte[] getDataCopyXYZTAsByte(int c, byte[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYZAsByte(t, c, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public short[] getDataCopyXYZTAsShort(int c) {
        return this.getDataCopyXYZTAsShort(c, null, 0);
    }

    public short[] getDataCopyXYZTAsShort(int c, short[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYZAsShort(t, c, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public int[] getDataCopyXYZTAsInt(int c) {
        return this.getDataCopyXYZTAsInt(c, null, 0);
    }

    public int[] getDataCopyXYZTAsInt(int c, int[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYZAsInt(t, c, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public float[] getDataCopyXYZTAsFloat(int c) {
        return this.getDataCopyXYZTAsFloat(c, null, 0);
    }

    public float[] getDataCopyXYZTAsFloat(int c, float[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYZAsFloat(t, c, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public double[] getDataCopyXYZTAsDouble(int c) {
        return this.getDataCopyXYZTAsDouble(c, null, 0);
    }

    public double[] getDataCopyXYZTAsDouble(int c, double[] out, int off) {
        long sizeT = this.getSizeT();
        long len = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getSizeZ();
        if (len * sizeT >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeT));
        int offset = off;
        int t = 0;
        while ((long)t < sizeT) {
            this.getDataCopyXYZAsDouble(t, c, result, offset);
            offset = (int)((long)offset + len);
            ++t;
        }
        return result;
    }

    public byte[] getDataCopyXYZAsByte(int t, int c) {
        return this.getDataCopyXYZAsByte(t, c, null, 0);
    }

    public byte[] getDataCopyXYZAsByte(int t, int c, byte[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        byte[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYAsByte(t, z, c, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public short[] getDataCopyXYZAsShort(int t, int c) {
        return this.getDataCopyXYZAsShort(t, c, null, 0);
    }

    public short[] getDataCopyXYZAsShort(int t, int c, short[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        short[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYAsShort(t, z, c, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public int[] getDataCopyXYZAsInt(int t, int c) {
        return this.getDataCopyXYZAsInt(t, c, null, 0);
    }

    public int[] getDataCopyXYZAsInt(int t, int c, int[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        int[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYAsInt(t, z, c, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public float[] getDataCopyXYZAsFloat(int t, int c) {
        return this.getDataCopyXYZAsFloat(t, c, null, 0);
    }

    public float[] getDataCopyXYZAsFloat(int t, int c, float[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        float[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYAsFloat(t, z, c, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public double[] getDataCopyXYZAsDouble(int t, int c) {
        return this.getDataCopyXYZAsDouble(t, c, null, 0);
    }

    public double[] getDataCopyXYZAsDouble(int t, int c, double[] out, int off) {
        long sizeZ = this.getSizeZ();
        long len = (long)this.getSizeX() * (long)this.getSizeY();
        if (len * sizeZ >= Integer.MAX_VALUE) {
            throw new TooLargeArrayException();
        }
        double[] result = Array1DUtil.allocIfNull(out, (int)(len * sizeZ));
        int offset = off;
        int z = 0;
        while ((long)z < sizeZ) {
            this.getDataCopyXYAsDouble(t, z, c, result, offset);
            offset = (int)((long)offset + len);
            ++z;
        }
        return result;
    }

    public void setDataXY(int t, int z, int c, Object value) {
        IcyBufferedImage img = this.getImage(t, z);
        if (img != null) {
            img.setDataXY(c, value);
        }
    }

    @Deprecated
    public Sequence getSubSequence(int startX, int startY, int startZ, int startT, int sizeX, int sizeY, int sizeZ, int sizeT) {
        return SequenceUtil.getSubSequence(this, startX, startY, startZ, startT, sizeX, sizeY, sizeZ, sizeT);
    }

    @Deprecated
    public Sequence getCopy() {
        return SequenceUtil.getCopy(this);
    }

    @Deprecated
    public void setT(int t) {
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            if (viewer.getSequence() != this) continue;
            viewer.setT(t);
        }
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String adjName = name.toLowerCase();
        if (StringUtil.equals(adjName, "id")) {
            return Integer.toString(this.getId());
        }
        if (StringUtil.equals(adjName, "name")) {
            return this.getName();
        }
        if (StringUtil.equals(adjName, "positionX")) {
            return Double.toString(this.getPositionX());
        }
        if (StringUtil.equals(adjName, "positionY")) {
            return Double.toString(this.getPositionY());
        }
        if (StringUtil.equals(adjName, "positionZ")) {
            return Double.toString(this.getPositionZ());
        }
        if (StringUtil.equals(adjName, "positionT")) {
            return Long.toString(this.getPositionT());
        }
        if (StringUtil.equals(adjName, "pixelSizeX")) {
            return Double.toString(this.getPixelSizeX());
        }
        if (StringUtil.equals(adjName, "pixelSizeY")) {
            return Double.toString(this.getPixelSizeY());
        }
        if (StringUtil.equals(adjName, "pixelSizeZ")) {
            return Double.toString(this.getPixelSizeZ());
        }
        if (StringUtil.equals(adjName, "timeInterval")) {
            return Double.toString(this.getTimeInterval());
        }
        if (StringUtil.equals(adjName, "virtual")) {
            return Boolean.toString(this.isVirtual());
        }
        if (StringUtil.equals(adjName, "channelName") || StringUtil.equals(adjName, "positionTOffset")) {
            throw new IllegalArgumentException("Cannot return value of property '" + adjName + "' as String");
        }
        Map<String, String> map = this.properties;
        synchronized (map) {
            return this.properties.get(adjName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        if (name == null) {
            return;
        }
        String adjName = name.toLowerCase();
        if (StringUtil.equals(adjName, "name")) {
            this.setName(value);
        }
        if (StringUtil.equals(adjName, "positionX")) {
            this.setPositionX(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "positionY")) {
            this.setPositionY(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "positionZ")) {
            this.setPositionZ(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "positionT")) {
            this.setPositionT(Long.valueOf(value));
        }
        if (StringUtil.equals(adjName, "pixelSizeX")) {
            this.setPixelSizeX(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "pixelSizeY")) {
            this.setPixelSizeY(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "pixelSizeZ")) {
            this.setPixelSizeZ(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "timeInterval")) {
            this.setTimeInterval(Double.valueOf(value));
        }
        if (StringUtil.equals(adjName, "virtual")) {
            this.setVirtual(Boolean.valueOf(value));
        }
        if (StringUtil.equals(adjName, "id") || StringUtil.equals(adjName, "channelName") || StringUtil.equals(adjName, "positionTOffset")) {
            throw new IllegalArgumentException("Cannot return value of property '" + adjName + "' as String");
        }
        Map<String, String> map = this.properties;
        synchronized (map) {
            this.properties.put(adjName, value);
        }
        this.metaChanged(adjName);
    }

    public boolean loadXMLData() {
        return this.persistent.loadXMLData();
    }

    public void refreshXMLData() {
        this.persistent.refreshXMLData();
    }

    public boolean saveXMLData() {
        Exception exc = null;
        for (int retry = 0; retry < 5; ++retry) {
            try {
                return this.persistent.saveXMLData();
            }
            catch (Exception e) {
                exc = e;
                continue;
            }
        }
        System.err.println("Error while saving Sequence XML persistent data :");
        IcyExceptionHandler.showErrorMessage(exc, true);
        return false;
    }

    public Node isNodeExisting(String name) {
        return this.persistent.getNode(name);
    }

    public Node getNode(String name) {
        Node result = this.persistent.getNode(name);
        if (result == null) {
            return this.persistent.setNode(name);
        }
        return result;
    }

    @Deprecated
    public Node setNode(String name) {
        return this.persistent.setNode(name);
    }

    public String toString() {
        return "Sequence: " + this.getName() + " - " + this.getSizeX() + " x " + this.getSizeY() + " x " + this.getSizeZ() + " x " + this.getSizeT() + " - " + this.getSizeC() + " ch (" + (Object)((Object)this.getDataType_()) + ")";
    }

    public void onImageAdded(IcyBufferedImage image) {
        if (this.colorModel == null) {
            this.setColorModel(IcyColorModel.createInstance(image.getIcyColorModel(), true, true));
        }
        image.addListener(this);
        this.dataChanged(image, SequenceEvent.SequenceEventType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImageReplaced(IcyBufferedImage oldImage, IcyBufferedImage newImage) {
        boolean typeChange = this.getNumImage() == 1;
        IcyColorModel cm = this.colorModel;
        this.beginUpdate();
        try {
            if (typeChange) {
                if (!this.isCompatible(newImage.getIcyColorModel())) {
                    this.setColorModel(IcyColorModel.createInstance(newImage.getIcyColorModel(), true, true));
                } else if (oldImage.getSizeX() != newImage.getSizeX() || oldImage.getSizeY() != newImage.getSizeY()) {
                    this.typeChanged();
                }
            }
            if (cm != null) {
                cm.getIcyColorSpace().removeListener(oldImage.getIcyColorModel());
            }
            oldImage.removeListener(this);
            this.dataChanged(oldImage, SequenceEvent.SequenceEventType.REMOVED);
            newImage.addListener(this);
            this.dataChanged(newImage, SequenceEvent.SequenceEventType.ADDED);
        }
        finally {
            this.endUpdate();
        }
    }

    public void onImageRemoved(IcyBufferedImage image) {
        if (this.isEmpty()) {
            this.setColorModel(null);
        }
        if (this.colorModel != null) {
            this.colorModel.getIcyColorSpace().removeListener(image.getIcyColorModel());
        }
        image.removeListener(this);
        this.dataChanged(image, SequenceEvent.SequenceEventType.REMOVED);
    }

    protected void fireChangedEvent(SequenceEvent e) {
        ArrayList<SequenceListener> cachedListeners = new ArrayList<SequenceListener>(this.listeners);
        for (SequenceListener listener : cachedListeners) {
            listener.sequenceChanged(e);
        }
        if (e.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY) {
            Painter painter = e.getSource() instanceof OverlayWrapper ? ((OverlayWrapper)e.getSource()).getPainter() : (Painter)e.getSource();
            SequenceEvent event = new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_PAINTER, painter, e.getType(), e.getParam());
            for (SequenceListener listener : cachedListeners) {
                listener.sequenceChanged(event);
            }
        }
    }

    protected void fireClosedEvent() {
        for (SequenceListener listener : new ArrayList<SequenceListener>(this.listeners)) {
            listener.sequenceClosed(this);
        }
    }

    @Override
    public void fireModelImageChangedEvent() {
        for (SequenceModel.SequenceModelListener listener : new ArrayList<SequenceModel.SequenceModelListener>(this.modelListeners)) {
            listener.imageChanged();
        }
    }

    @Override
    public void fireModelDimensionChangedEvent() {
        for (SequenceModel.SequenceModelListener listener : new ArrayList<SequenceModel.SequenceModelListener>(this.modelListeners)) {
            listener.dimensionChanged();
        }
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
        if (!this.updater.isUpdating() && this.channelBoundsInvalid) {
            this.channelBoundsInvalid = false;
            this.internalUpdateChannelsBounds();
        }
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    public void metaChanged(String metaName) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_META, metaName));
    }

    public void metaChanged(String metaName, int param) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_META, metaName, null, param));
    }

    protected void typeChanged() {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_TYPE));
    }

    protected void colormapChanged(IcyColorModel colorModel, int component) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_COLORMAP, (Object)colorModel, component));
    }

    protected void componentBoundsChanged(IcyColorModel colorModel, int component) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_COMPONENTBOUNDS, (Object)colorModel, component));
    }

    @Deprecated
    public void painterChanged(Painter painter) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY, (Object)this.getOverlay(painter), SequenceEvent.SequenceEventType.CHANGED));
    }

    protected void overlayChanged(Overlay overlay, SequenceEvent.SequenceEventType type) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_OVERLAY, (Object)overlay, type));
    }

    public void overlayChanged(Overlay overlay) {
        if (this.contains(overlay)) {
            this.overlayChanged(overlay, SequenceEvent.SequenceEventType.CHANGED);
        }
    }

    @Override
    public void overlayChanged(OverlayEvent event) {
        if (event.getType() == OverlayEvent.OverlayEventType.PAINTER_CHANGED) {
            this.overlayChanged(event.getSource(), SequenceEvent.SequenceEventType.CHANGED);
        }
    }

    @Deprecated
    public void roiChanged() {
        Iterator<ROI> it = this.rois.iterator();
        while (it.hasNext()) {
            this.roiChanged(it.next(), SequenceEvent.SequenceEventType.CHANGED);
        }
    }

    public void roiChanged(ROI roi) {
        if (this.contains(roi)) {
            this.roiChanged(roi, SequenceEvent.SequenceEventType.CHANGED);
        }
    }

    protected void roiChanged(ROI roi, SequenceEvent.SequenceEventType type) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI, (Object)roi, type));
    }

    public void dataChanged() {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA, null));
    }

    protected void dataChanged(IcyBufferedImage image, SequenceEvent.SequenceEventType type) {
        this.updater.changed(new SequenceEvent(this, SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA, image, type, 0));
    }

    @Override
    public void colorModelChanged(IcyColorModelEvent e) {
        switch (e.getType()) {
            case COLORMAP_CHANGED: {
                this.colormapChanged(e.getColorModel(), e.getComponent());
                break;
            }
            case SCALER_CHANGED: {
                this.componentBoundsChanged(e.getColorModel(), e.getComponent());
            }
        }
    }

    @Override
    public void imageChanged(IcyBufferedImageEvent e) {
        IcyBufferedImage image = e.getImage();
        switch (e.getType()) {
            case BOUNDS_CHANGED: {
                if (!this.autoUpdateChannelBounds) break;
                if (this.isUpdating()) {
                    this.channelBoundsInvalid = true;
                    break;
                }
                this.internalUpdateChannelsBounds();
                break;
            }
            case COLORMAP_CHANGED: {
                break;
            }
            case DATA_CHANGED: {
                this.dataChanged(image, SequenceEvent.SequenceEventType.CHANGED);
            }
        }
    }

    @Override
    public void roiChanged(ROIEvent event) {
        this.roiChanged(event.getSource(), SequenceEvent.SequenceEventType.CHANGED);
    }

    @Override
    public void onChanged(CollapsibleEvent e) {
        SequenceEvent event = (SequenceEvent)e;
        switch (event.getSourceType()) {
            case SEQUENCE_DATA: {
                if (this.autoUpdateChannelBounds) {
                    if (event.getSource() == null) {
                        this.recalculateAllImageChannelsBounds();
                    }
                    this.internalUpdateChannelsBounds();
                }
                this.fireModelImageChangedEvent();
                break;
            }
            case SEQUENCE_TYPE: {
                this.fireModelDimensionChangedEvent();
                break;
            }
            case SEQUENCE_COLORMAP: {
                break;
            }
            case SEQUENCE_COMPONENTBOUNDS: {
                break;
            }
            case SEQUENCE_OVERLAY: {
                break;
            }
        }
        this.fireChangedEvent(event);
    }
}

