/*
 * Decompiled with CFR 0.152.
 */
package icy.update;

import icy.common.listener.ProgressListener;
import icy.file.FileUtil;
import icy.gui.frame.ActionFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.frame.progress.DownloadFrame;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.preferences.ApplicationPreferences;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.update.ElementDescriptor;
import icy.update.Updater;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IcyUpdater {
    private static final int ANNOUNCE_SHOWTIME = 15;
    public static final String PARAM_ARCH = "arch";
    public static final String PARAM_VERSION = "version";
    static boolean wantUpdate = false;
    private static boolean silent;
    private static boolean updating;
    private static boolean checking;
    private static ActionFrame frame;
    private static Runnable checker;

    public static boolean getWantUpdate() {
        return wantUpdate;
    }

    public static boolean isCheckingForUpdate() {
        return checking || ThreadUtil.hasWaitingBgSingleTask(checker);
    }

    public static boolean isUpdating() {
        return IcyUpdater.isCheckingForUpdate() || frame != null && frame.isVisible() || updating;
    }

    public static void checkUpdate(boolean silent) {
        if (!IcyUpdater.isUpdating()) {
            IcyUpdater.silent = silent;
            ThreadUtil.bgRunSingle(checker);
        }
    }

    @Deprecated
    public static void checkUpdate(boolean showProgress, boolean auto) {
        IcyUpdater.checkUpdate(!showProgress || auto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void processCheckUpdate() {
        checking = true;
        try {
            ArrayList<ElementDescriptor> toUpdate;
            wantUpdate = false;
            FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
            String params = "arch=" + SystemUtil.getOSArchIdString() + "&" + PARAM_VERSION + "=" + Icy.version.toShortString();
            try (CancelableProgressFrame checkingFrame = !silent && !Icy.getMainInterface().isHeadLess() ? new CancelableProgressFrame("checking for application update...") : null;){
                if (!IcyUpdater.downloadAndSaveForUpdate(ApplicationPreferences.getUpdateRepositoryBase() + ApplicationPreferences.getUpdateRepositoryFile() + "?" + params, "update.xml", checkingFrame, !silent)) {
                    FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
                    return;
                }
                toUpdate = Updater.getUpdateElements(Updater.getLocalElements());
            }
            boolean needUpdate = toUpdate.isEmpty() ? false : toUpdate.size() != 1 || !toUpdate.get(0).getName().equals("ICY Updater");
            if (needUpdate) {
                if (silent || Icy.getMainInterface().isHeadLess()) {
                    if (IcyUpdater.prepareUpdate(toUpdate, true)) {
                        wantUpdate = true;
                    }
                } else {
                    String mess = toUpdate.size() > 1 ? "Some updates are available..." : "An update is available...";
                    new AnnounceFrame(mess, "View", new Runnable(){

                        @Override
                        public void run() {
                            IcyUpdater.showUpdateAndProcess(toUpdate);
                        }
                    }, 15);
                }
            } else {
                FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
                if (!silent && !Icy.getMainInterface().isHeadLess()) {
                    new AnnounceFrame("No application update available", 10);
                }
            }
        }
        finally {
            checking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void showUpdateAndProcess(final ArrayList<ElementDescriptor> elements) {
        if (frame != null) {
            ActionFrame actionFrame = frame;
            synchronized (actionFrame) {
                if (frame.isVisible()) {
                    return;
                }
                frame.getMainPanel().removeAll();
            }
        } else {
            frame = new ActionFrame("Application update", true);
        }
        frame.setPreferredSize(new Dimension(640, 500));
        frame.getOkBtn().setText("Install");
        frame.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        if (IcyUpdater.prepareUpdate(elements, true)) {
                            wantUpdate = true;
                            Icy.confirmRestart();
                        } else {
                            new FailedAnnounceFrame("An error occured while downloading files (see details in console)", 10000);
                        }
                    }
                });
            }
        });
        JPanel topPanel = GuiUtil.createPageBoxPanel(Box.createVerticalStrut(4), GuiUtil.createCenteredBoldLabel("The following(s) element(s) will be updated"), Box.createVerticalStrut(4));
        final JTextArea changeLogArea = new JTextArea();
        changeLogArea.setEditable(false);
        final JLabel changeLogTitleLabel = GuiUtil.createBoldLabel("Change log :");
        final JList<Object> list = new JList<Object>(elements.toArray());
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (list.getSelectedValue() != null) {
                    ElementDescriptor element = (ElementDescriptor)list.getSelectedValue();
                    String changeLog = element.getChangelog().trim();
                    if (StringUtil.isEmpty(changeLog)) {
                        changeLogArea.setText("no change log");
                    } else {
                        changeLogArea.setText(changeLog);
                    }
                    changeLogArea.setCaretPosition(0);
                    changeLogTitleLabel.setText(element.getName() + " change log");
                }
            }
        });
        list.setSelectedIndex(0);
        JScrollPane medScrollPane = new JScrollPane(list);
        JScrollPane changeLogScrollPane = new JScrollPane(GuiUtil.createTabArea(changeLogArea, 4));
        JPanel bottomPanel = GuiUtil.createPageBoxPanel(Box.createVerticalStrut(4), GuiUtil.createCenteredLabel(changeLogTitleLabel), Box.createVerticalStrut(4), changeLogScrollPane);
        JPanel mainPanel = frame.getMainPanel();
        JSplitPane splitPane = new JSplitPane(0, medScrollPane, bottomPanel);
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)splitPane, "Center");
        frame.pack();
        frame.addToDesktopPane();
        frame.setVisible(true);
        frame.center();
        frame.requestFocus();
        splitPane.setDividerLocation(0.5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prepareUpdate(List<ElementDescriptor> elements, boolean showProgress) {
        updating = true;
        DownloadFrame downloadingFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new DownloadFrame("") : null;
        try {
            int numFile = 0;
            for (ElementDescriptor element : elements) {
                numFile += element.getFiles().size();
            }
            if (downloadingFrame != null) {
                downloadingFrame.setLength(numFile);
            }
            int curFile = 0;
            for (ElementDescriptor element : elements) {
                for (ElementDescriptor.ElementFile elementFile : element.getFiles()) {
                    ++curFile;
                    if (downloadingFrame != null) {
                        downloadingFrame.setMessage("Downloading updates " + curFile + " / " + numFile);
                        String toolTip = "Downloading " + element.getName() + " : " + FileUtil.getFileName(elementFile.getLocalPath());
                        downloadingFrame.setToolTipText(toolTip);
                    }
                    if (elementFile.isLink()) {
                        if (FileUtil.createLink(Updater.UPDATE_DIRECTORY + "/" + elementFile.getLocalPath(), elementFile.getOnlinePath())) continue;
                        FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
                        boolean bl = false;
                        return bl;
                    }
                    if (!Updater.needUpdate(elementFile.getLocalPath(), elementFile.getDateModif()) || IcyUpdater.downloadAndSaveForUpdate(URLUtil.getNetworkURLString(ApplicationPreferences.getUpdateRepositoryBase(), elementFile.getOnlinePath()), elementFile.getLocalPath(), downloadingFrame, showProgress)) continue;
                    FileUtil.delete(Updater.UPDATE_DIRECTORY, true);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (downloadingFrame != null) {
                downloadingFrame.close();
            }
            updating = false;
        }
        return true;
    }

    public static boolean downloadAndSaveForUpdate(String downloadPath, String savePath, ProgressFrame frame, boolean displayError) {
        byte[] data = NetworkUtil.download(downloadPath, (ProgressListener)frame, displayError);
        if (data == null) {
            return false;
        }
        String saveFilename = Updater.UPDATE_DIRECTORY + "/";
        saveFilename = StringUtil.isEmpty(savePath) ? saveFilename + URLUtil.getURLFileName(downloadPath, true) : saveFilename + savePath;
        return FileUtil.save(saveFilename, data, displayError);
    }

    private static boolean canDoUpdate() {
        boolean requiredFilesExist = FileUtil.exists(FileUtil.APPLICATION_DIRECTORY + "/" + "updater.jar");
        return requiredFilesExist &= FileUtil.exists(Updater.UPDATE_DIRECTORY + "/" + "update.xml");
    }

    public static boolean launchUpdater(boolean doUpdate, boolean restart) {
        if (doUpdate) {
            String updateName = Updater.UPDATE_DIRECTORY + "/" + "updater.jar";
            if (FileUtil.exists(updateName) && !FileUtil.rename(updateName, FileUtil.APPLICATION_DIRECTORY + "/" + "updater.jar", true)) {
                System.err.println("Can't update 'Upater.jar', Update process can't continue.");
                return false;
            }
            if (!IcyUpdater.canDoUpdate()) {
                System.err.println("Can't process update : some required files are missing.");
                return false;
            }
        }
        String params = "";
        if (doUpdate) {
            params = params + "-update ";
        }
        if (!restart) {
            params = params + "-nostart ";
        }
        SystemUtil.execJAR("updater.jar", params);
        return true;
    }

    static {
        updating = false;
        checking = false;
        frame = null;
        checker = new Runnable(){

            @Override
            public void run() {
                IcyUpdater.processCheckUpdate();
            }
        };
    }
}

