/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.Formatter;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;

public abstract class AbstractIOServiceProvider
implements IOServiceProvider {
    protected RandomAccessFile raf;
    protected String location;
    protected int rafOrder = 0;
    protected NetcdfFile ncfile;

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.location = raf != null ? raf.getLocation() : null;
        this.ncfile = ncfile;
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void release() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public void reacquire() throws IOException {
        this.raf = RandomAccessFile.acquire(this.location);
        this.raf.order(this.rafOrder);
    }

    @Override
    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array data = this.readData(v2, section);
        return IospHelper.copyToByteChannel(data, channel);
    }

    @Override
    public long readToOutputStream(Variable v2, Section section, OutputStream out) throws IOException, InvalidRangeException {
        Array data = this.readData(v2, section);
        return IospHelper.copyToOutputStream(data, out);
    }

    @Override
    public long streamToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        Array data = this.readData(v2, section);
        return IospHelper.copyToByteChannel(data, channel);
    }

    @Override
    public Array readSection(ParsedSectionSpec cer) throws IOException, InvalidRangeException {
        return IospHelper.readSection(cer);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s2, int bufferSize) throws IOException {
        return null;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message == "RandomAccessFile") {
            return this.raf;
        }
        return null;
    }

    @Override
    public boolean syncExtend() throws IOException {
        return false;
    }

    public long getLastModified() {
        if (this.location != null) {
            File file2 = new File(this.location);
            return file2.lastModified();
        }
        return 0L;
    }

    @Override
    public String toStringDebug(Object o) {
        return "";
    }

    @Override
    public String getDetailInfo() {
        if (this.raf == null) {
            return "";
        }
        try {
            Formatter fout = new Formatter();
            double size = (double)this.raf.length() / 1000000.0;
            fout.format(" raf = %s%n", this.raf.getLocation());
            fout.format(" size= %d (%s Mb)%n%n", this.raf.length(), Format.dfrac(size, 3));
            return fout.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    @Override
    public String getFileTypeVersion() {
        return "N/A";
    }
}

