/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateFormatter {
    private SimpleDateFormat isoDateTimeFormat;
    private SimpleDateFormat isoDateNoSecsFormat;
    private SimpleDateFormat stdDateTimeFormat;
    private SimpleDateFormat stdDateNoSecsFormat;
    private SimpleDateFormat dateOnlyFormat;

    private void isoDateTimeFormat() {
        if (this.isoDateTimeFormat != null) {
            return;
        }
        this.isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void isoDateNoSecsFormat() {
        if (this.isoDateNoSecsFormat != null) {
            return;
        }
        this.isoDateNoSecsFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        this.isoDateNoSecsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void stdDateTimeFormat() {
        if (this.stdDateTimeFormat != null) {
            return;
        }
        this.stdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.stdDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void stdDateNoSecsFormat() {
        if (this.stdDateNoSecsFormat != null) {
            return;
        }
        this.stdDateNoSecsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        this.stdDateNoSecsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private void dateOnlyFormat() {
        if (this.dateOnlyFormat != null) {
            return;
        }
        this.dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateOnlyFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Deprecated
    public Date getISODate(String text) {
        try {
            Date result = this.stdDateTimeFormat(text);
            return result;
        }
        catch (ParseException parseException) {
            try {
                Date result = this.isoDateTimeFormat(text);
                return result;
            }
            catch (ParseException parseException2) {
                try {
                    Date result = this.isoDateNoSecsFormat(text);
                    return result;
                }
                catch (ParseException parseException3) {
                    try {
                        Date result = this.stdDateNoSecsFormat(text);
                        return result;
                    }
                    catch (ParseException parseException4) {
                        try {
                            Date result = this.dateOnlyFormat(text);
                            return result;
                        }
                        catch (ParseException parseException5) {
                            return null;
                        }
                    }
                }
            }
        }
    }

    private Date stdDateTimeFormat(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        this.stdDateTimeFormat();
        return this.stdDateTimeFormat.parse(text);
    }

    private Date stdDateNoSecsFormat(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        this.stdDateNoSecsFormat();
        return this.stdDateNoSecsFormat.parse(text);
    }

    private Date isoDateTimeFormat(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        this.isoDateTimeFormat();
        return this.isoDateTimeFormat.parse(text);
    }

    private Date isoDateNoSecsFormat(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        this.isoDateNoSecsFormat();
        return this.isoDateNoSecsFormat.parse(text);
    }

    private Date dateOnlyFormat(String text) throws ParseException {
        text = text == null ? "" : text.trim();
        this.dateOnlyFormat();
        return this.dateOnlyFormat.parse(text);
    }

    public String getStandardDateOnlyString(Date date) {
        return this.toDateOnlyString(date);
    }

    public String toDateString(Date date) {
        return this.toDateOnlyString(date);
    }

    public String toDateOnlyString(Date date) {
        this.dateOnlyFormat();
        return this.dateOnlyFormat.format(date);
    }

    public String getStandardDateString2(Date date) {
        return this.toDateTimeString(date);
    }

    public String toDateTimeString(Date date) {
        if (date == null) {
            return "Unknown";
        }
        this.stdDateTimeFormat();
        return this.stdDateTimeFormat.format(date) + "Z";
    }

    public String getStandardDateString(Date date) {
        return this.toDateTimeStringISO(date);
    }

    public String toDateTimeStringISO(Date date) {
        this.isoDateTimeFormat();
        return this.isoDateTimeFormat.format(date) + "Z";
    }

    private static void test(String text) {
        DateFormatter formatter = new DateFormatter();
        Date date = formatter.getISODate(text);
        String text2 = formatter.toDateTimeStringISO(date);
        Date date2 = formatter.getISODate(text2);
        assert (date.equals(date2));
        System.out.println(text + " == " + text2);
    }

    public static void main(String[] args) {
        DateFormatter.test("2001-09-11T12:09:20");
        DateFormatter.test("2001-09-11 12:10:12");
        DateFormatter.test("2001-09-11T12:10");
        DateFormatter.test("2001-09-11 12:01");
        DateFormatter.test("2001-09-11");
    }
}

