/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.IImage;
import icy.util.ColorUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Optional;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumbusImage
implements IImage {
    private String version;
    private String id;
    private String state;
    private long bufferNumber;
    private String url;
    private long row;
    private long column;
    private long fieldId;
    private long planeId;
    private long timepointId;
    private long channelId;
    private String channelName;
    private Color channelColor;
    private String channelType;
    private String acquisitionType;
    private double resolutionX;
    private double resolutionY;
    private long sizeX;
    private long sizeY;
    private double positionX;
    private double positionY;
    private double absPositionZ;
    private double positionZ;
    private double time;
    private Date date;
    private double excitationWavelength;
    private double emissionWavelength;

    private ColumbusImage() {
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public long getBufferNumber() {
        return this.bufferNumber;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public long getRow() {
        return this.row;
    }

    @Override
    public long getColumn() {
        return this.column;
    }

    @Override
    public long getFieldId() {
        return this.fieldId;
    }

    @Override
    public long getPlaneId() {
        return this.planeId;
    }

    @Override
    public long getTimepointId() {
        return this.timepointId;
    }

    @Override
    public long getChannelId() {
        return this.channelId;
    }

    public String getChannelName() {
        return this.channelName;
    }

    @Override
    public Color getChannelColor() {
        return this.channelColor;
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    @Override
    public String getAcquisitionType() {
        return this.acquisitionType;
    }

    @Override
    public double getResolutionX() {
        return this.resolutionX;
    }

    @Override
    public double getResolutionY() {
        return this.resolutionY;
    }

    @Override
    public long getSizeX() {
        return this.sizeX;
    }

    @Override
    public long getSizeY() {
        return this.sizeY;
    }

    @Override
    public double getPositionX() {
        return this.positionX;
    }

    @Override
    public double getPositionY() {
        return this.positionY;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.positionX, this.positionY, (double)this.sizeX * this.resolutionX, (double)this.sizeY * this.resolutionY);
    }

    @Override
    public double getAbsPositionZ() {
        return this.absPositionZ;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public double getExcitationWavelength() {
        return this.excitationWavelength;
    }

    @Override
    public double getEmissionWavelength() {
        return this.emissionWavelength;
    }

    public String toString() {
        return "Image [url=" + this.url + ", bufferNumber=" + this.bufferNumber + ", row=" + this.row + ", column=" + this.column + ", resolutionX=" + this.resolutionX + ", resolutionY=" + this.resolutionY + ", sizeX=" + this.sizeX + ", sizeY=" + this.sizeY + ", positionX=" + this.positionX + ", positionY=" + this.positionY + ", positionZ=" + this.positionZ + "]";
    }

    /* synthetic */ ColumbusImage(ColumbusImage columbusImage) {
        this();
    }

    public static class Builder {
        private static final Date DEFAULT_DATE = new Date();

        public static ColumbusImage fromXMLElement(Element imageElement) {
            String imageVersion = XMLUtil.getAttributeValue((Element)imageElement, (String)"Version", (String)"1");
            String imageId = XMLUtil.getElementValue((Node)imageElement, (String)"id", null);
            String imageState = XMLUtil.getElementValue((Node)imageElement, (String)"State", (String)"Ok");
            Element urlElement = XMLUtil.getElement((Node)imageElement, (String)"URL");
            long imageBufferNumber = XMLUtil.getAttributeLongValue((Element)urlElement, (String)"BufferNo", (long)0L);
            String imageURL = urlElement.getTextContent();
            long imageRow = XMLUtil.getElementLongValue((Node)imageElement, (String)"Row", (long)0L);
            long imageColumn = XMLUtil.getElementLongValue((Node)imageElement, (String)"Col", (long)0L);
            long imageFieldId = XMLUtil.getElementLongValue((Node)imageElement, (String)"FieldID", (long)0L);
            long imagePlaneId = XMLUtil.getElementLongValue((Node)imageElement, (String)"PlaneID", (long)0L);
            long imageTimepointId = XMLUtil.getElementLongValue((Node)imageElement, (String)"TimepointID", (long)0L);
            long imageChannelId = XMLUtil.getElementLongValue((Node)imageElement, (String)"ChannelID", (long)0L);
            String imageChannelName = XMLUtil.getElementValue((Node)imageElement, (String)"ChannelName", (String)("Channel " + imageChannelId));
            String imageChannelType = XMLUtil.getElementValue((Node)imageElement, (String)"ChannelType", (String)"Fluorescence");
            String imageAcquisitionType = XMLUtil.getElementValue((Node)imageElement, (String)"AcquisitionType", (String)"SpinningDiskConfocal");
            Element resolutionXElement = XMLUtil.getElement((Node)imageElement, (String)"ImageResolutionX");
            double imageResolutionX = Double.parseDouble(resolutionXElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)resolutionXElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            Element resolutionYElement = XMLUtil.getElement((Node)imageElement, (String)"ImageResolutionY");
            double imageResolutionY = Double.parseDouble(resolutionYElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)resolutionYElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            long imageSizeX = XMLUtil.getElementLongValue((Node)imageElement, (String)"ImageSizeX", (long)0L);
            long imageSizeY = XMLUtil.getElementLongValue((Node)imageElement, (String)"ImageSizeY", (long)0L);
            Element positionXElement = XMLUtil.getElement((Node)imageElement, (String)"PositionX");
            double imagePositionX = Double.parseDouble(positionXElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)positionXElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            Element positionYElement = XMLUtil.getElement((Node)imageElement, (String)"PositionY");
            double imagePositionY = Double.parseDouble(positionYElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)positionYElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            Element positionZElement = XMLUtil.getElement((Node)imageElement, (String)"PositionZ");
            double imagePositionZ = Double.parseDouble(positionZElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)positionZElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            Element absPositionZElement = XMLUtil.getElement((Node)imageElement, (String)"AbsPositionZ");
            double imageAbsPositionZ = Double.parseDouble(absPositionZElement.getTextContent()) * (double)(XMLUtil.getAttributeValue((Element)absPositionZElement, (String)"Unit", (String)"m").equals("m") ? 1000000 : 1);
            Element timeElement = XMLUtil.getElement((Node)imageElement, (String)"MeasurementTimeOffset");
            double imageTime = Double.parseDouble(timeElement.getTextContent());
            Date imageDate = Optional.ofNullable(XMLUtil.getElementValue((Node)imageElement, (String)"AbsTime", null)).flatMap(timeStr -> {
                try {
                    return Optional.of(DatatypeConverter.parseDateTime((String)timeStr).getTime());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Cannot format acquisition date", e);
                }
            }).orElse(DEFAULT_DATE);
            Element excitationElement = XMLUtil.getElement((Node)imageElement, (String)"MainExcitationWavelength");
            double imageExcitationWavelength = Double.parseDouble(excitationElement.getTextContent());
            Element emissionElement = XMLUtil.getElement((Node)imageElement, (String)"MainEmissionWavelength");
            double imageEmissionWavelength = Double.parseDouble(emissionElement.getTextContent());
            ColumbusImage image = new ColumbusImage(null);
            image.version = imageVersion;
            image.id = imageId;
            image.state = imageState;
            image.bufferNumber = imageBufferNumber;
            image.url = imageURL;
            image.row = imageRow;
            image.column = imageColumn;
            image.fieldId = imageFieldId;
            image.planeId = imagePlaneId;
            image.timepointId = imageTimepointId;
            image.channelId = imageChannelId;
            image.channelName = imageChannelName;
            image.channelColor = ColorUtil.getColorFromWavelength((double)imageEmissionWavelength);
            image.channelType = imageChannelType;
            image.acquisitionType = imageAcquisitionType;
            image.resolutionX = imageResolutionX;
            image.resolutionY = imageResolutionY;
            image.sizeX = imageSizeX;
            image.sizeY = imageSizeY;
            image.positionX = imagePositionX;
            image.positionY = -imagePositionY;
            image.positionZ = imagePositionZ;
            image.absPositionZ = imageAbsPositionZ;
            image.time = imageTime;
            image.date = imageDate;
            image.excitationWavelength = imageExcitationWavelength;
            image.emissionWavelength = imageEmissionWavelength;
            return image;
        }
    }
}

