/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.io;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.columbus.ColumbusChannel;
import danyfel80.wells.data.columbus.ColumbusField;
import danyfel80.wells.data.columbus.ColumbusImage;
import danyfel80.wells.data.columbus.ColumbusPlane;
import danyfel80.wells.data.columbus.ColumbusPlate;
import danyfel80.wells.data.columbus.ColumbusTimepoint;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.file.FileUtil;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ByteArrayConvert;
import icy.type.dimension.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import loci.formats.FormatException;
import loci.formats.in.MinimalTiffReader;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.primitives.PositiveInteger;
import plugins.adufour.hcs.io.AbstractWellPlateReader;

public class WellPlateReader_ColumbusOperaFlex
extends AbstractWellPlateReader {
    private static final FileFilter FLEX_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return FileUtil.getFileExtension((String)pathname.getName(), (boolean)false).equalsIgnoreCase("flex");
        }
    };
    private static final FileFilter COLUMBUS_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".meax") || pathname.getName().endsWith(".ColumbusIDX.xml");
        }
    };

    @Override
    public String getSystemName() {
        return "PerkinElmer Columbus Flex";
    }

    @Override
    public boolean isValidPlate(File folder) {
        boolean hasColombusIndexFile;
        boolean containsFlexFiles = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        boolean bl = hasColombusIndexFile = FileUtil.getFiles((String)folder.getPath(), (FileFilter)COLUMBUS_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false).length > 0;
        return containsFlexFiles && hasColombusIndexFile;
    }

    public Future<ColumbusPlate> loadPlateFromFolder(File folder, MessageProgressListener progressListener) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "ColumbusWellPlateReader"));
        Future<ColumbusPlate> future = executor.submit(() -> this.loadPlateFromFolder_internal(folder, progressListener));
        executor.shutdown();
        return future;
    }

    private ColumbusPlate loadPlateFromFolder_internal(File folder, MessageProgressListener progressListener) throws IOException {
        String[] flexFiles = FileUtil.getFiles((String)folder.getPath(), (FileFilter)FLEX_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false);
        if (flexFiles.length == 0) {
            throw new IOException("Invalid folder: " + folder.getPath() + " does not contain any flex file.");
        }
        String[] columbusFiles = FileUtil.getFiles((String)folder.getPath(), (FileFilter)COLUMBUS_FILE_FILTER, (boolean)true, (boolean)false, (boolean)false);
        if (flexFiles.length == 0) {
            throw new IOException("Invalid folder: " + folder.getPath() + " does not contain any columbus xml file.");
        }
        if (progressListener != null) {
            progressListener.notifyProgress(-1.0, "Loading well plate: " + columbusFiles[0]);
        }
        ColumbusPlate plate = new ColumbusPlate.Builder(columbusFiles[0]).progressListener(progressListener).build();
        if (progressListener != null) {
            progressListener.notifyProgress(1.0, "Well plate loaded: " + columbusFiles[0]);
        }
        return plate;
    }

    @Override
    public Future<? extends Sequence> loadField(IPlate plate, IWell well, IField field, Sequence sequence, MessageProgressListener progressListener) {
        CompletableFuture<Sequence> future = new CompletableFuture<Sequence>();
        if (!(field instanceof ColumbusField)) {
            future.completeExceptionally(new ClassCastException("Provided field is not of type " + ColumbusField.class.getName()));
            return future;
        }
        if (!(plate instanceof ColumbusPlate)) {
            future.completeExceptionally(new ClassCastException("Provided field is not of type " + ColumbusField.class.getName()));
            return future;
        }
        if (sequence == null) {
            sequence = new Sequence();
        }
        sequence.beginUpdate();
        ColumbusPlate columbusPlate = (ColumbusPlate)plate;
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        metadata.setPlateName(columbusPlate.getName(), 0);
        metadata.setPlateID(columbusPlate.getMeasurementId(), 0);
        metadata.setPlateRows(new PositiveInteger(Integer.valueOf(columbusPlate.getDimension().height)), 0);
        metadata.setPlateColumns(new PositiveInteger(Integer.valueOf(columbusPlate.getDimension().width)), 0);
        sequence.setPositionX(field.getPosition().getX());
        sequence.setPositionY(field.getPosition().getY());
        Dimension2D.Double pixelSize = new Dimension2D.Double();
        HashMap<Integer, String> channelNames = new HashMap<Integer, String>();
        HashMap<Integer, IcyColorMap> channelColors = new HashMap<Integer, IcyColorMap>();
        try {
            this.loadPlanes(columbusPlate, (ColumbusField)field, sequence, pixelSize, channelNames, channelColors);
            sequence.setPixelSizeX(pixelSize.getSizeX());
            sequence.setPixelSizeY(pixelSize.getSizeY());
            for (Map.Entry entry : channelNames.entrySet()) {
                sequence.setChannelName((Integer)entry.getKey() - 1, (String)entry.getValue());
            }
            for (Map.Entry entry : channelColors.entrySet()) {
                sequence.setColormap((Integer)entry.getKey() - 1, (IcyColorMap)entry.getValue(), true);
            }
        }
        finally {
            sequence.endUpdate();
        }
        future.complete(sequence);
        return future;
    }

    private void loadPlanes(ColumbusPlate plate, ColumbusField field, Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors) {
        List planes = field.getPlanes().values().stream().sorted(Comparator.comparingDouble(ColumbusPlane::getPositionZ)).map(StreamUtils.wrapFunction(plane -> this.loadPlane(sequence, pixelSize, channelNames, channelColors, plate, field, (ColumbusPlane)plane))).collect(Collectors.toList());
        int z = 0;
        for (List planeImages : planes) {
            int t = 0;
            for (IcyBufferedImage image : planeImages) {
                sequence.setImage(t, z, (BufferedImage)image);
                ++t;
            }
            ++z;
        }
    }

    private List<IcyBufferedImage> loadPlane(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, ColumbusPlate plate, ColumbusField field, ColumbusPlane plane) {
        List<IcyBufferedImage> timeImages = plane.getTimepoints().values().stream().sorted(Comparator.comparingLong(ColumbusTimepoint::getId)).map(StreamUtils.wrapFunction(t -> this.loadTimePoint(sequence, pixelSize, channelNames, channelColors, plate, field, plane, (ColumbusTimepoint)t))).collect(Collectors.toList());
        return timeImages;
    }

    private IcyBufferedImage loadTimePoint(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, ColumbusPlate plate, ColumbusField field, ColumbusPlane plane, ColumbusTimepoint t) {
        List channelImages = t.getChannels().values().stream().sorted(Comparator.comparingLong(ColumbusChannel::getId)).map(StreamUtils.wrapFunction(ch -> this.loadChannel(sequence, pixelSize, channelNames, channelColors, plate, field, plane, t, (ColumbusChannel)ch))).collect(Collectors.toList());
        return IcyBufferedImage.createFrom(channelImages);
    }

    private IcyBufferedImage loadChannel(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, ColumbusPlate plate, ColumbusField field, ColumbusPlane plane, ColumbusTimepoint t, ColumbusChannel ch) throws IOException {
        String folderPath = plate.getFolder();
        String flexFile = ch.getImage().getUrl();
        String fullFilePath = Paths.get(folderPath, flexFile).toString();
        ColumbusImage image = ch.getImage();
        channelNames.put((int)ch.getId(), ch.getName());
        LinearColorMap colorMap = new LinearColorMap(String.valueOf((int)ch.getEmissionWavelength()) + "nm", ch.getColor());
        channelColors.put((int)ch.getId(), (IcyColorMap)colorMap);
        pixelSize.setSize(image.getResolutionX(), image.getResolutionY());
        try (MinimalTiffReader reader = new MinimalTiffReader();){
            reader.setId(fullFilePath);
            IcyBufferedImage icyBufferedImage = this.loadIcyBufferedImage(reader, (int)ch.getImage().getBufferNumber(), (int)ch.getImage().getSizeX(), (int)ch.getImage().getSizeY());
            return icyBufferedImage;
        }
    }

    private IcyBufferedImage loadIcyBufferedImage(MinimalTiffReader reader, int series, int sizeX, int sizeY) throws IOException {
        byte[] bytes;
        DataType dataType = DataType.getDataTypeFromFormatToolsType((int)reader.getPixelType());
        boolean little = reader.isLittleEndian();
        try {
            bytes = reader.openBytes(series);
        }
        catch (FormatException e) {
            throw new IOException(e);
        }
        Object pixelData = Array1DUtil.createArray((DataType)dataType, (int)(sizeX * sizeY));
        ByteArrayConvert.byteArrayTo((byte[])bytes, (int)0, (Object)pixelData, (int)0, (int)bytes.length, (boolean)little);
        return new IcyBufferedImage(sizeX, sizeY, pixelData, dataType.isSigned());
    }
}

