/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.columbus.ColumbusImage;
import danyfel80.wells.data.columbus.ColumbusPlane;
import danyfel80.wells.util.CollectionUtils;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ColumbusField
implements IField {
    private long id;
    public Point2D.Double position;
    private Map<Long, ColumbusPlane> planes;
    public Rectangle2D bounds;
    public Rectangle2D pixelBounds;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public Map<Long, ColumbusPlane> getPlanes() {
        return Collections.unmodifiableMap(this.planes);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getPixelBounds() {
        return this.pixelBounds;
    }

    public String toString() {
        String fieldString = "Field " + this.getId() + "[";
        if (this.getBounds() != null) {
            Rectangle2D bnds = this.getBounds();
            fieldString = fieldString + bnds.getX() + ", " + bnds.getY() + ", " + bnds.getWidth() + ", " + bnds.getHeight();
        } else {
            fieldString = fieldString + "null";
        }
        fieldString = fieldString + "]";
        return fieldString;
    }

    public static class Builder {
        public static ColumbusField fromImages(List<ColumbusImage> fieldImages) {
            Map<Long, List<ColumbusImage>> planeImages = fieldImages.stream().collect(Collectors.groupingBy(ColumbusImage::getPlaneId));
            ColumbusField field = new ColumbusField();
            field.id = fieldImages.stream().findAny().map(im -> im.getFieldId()).orElse(-1L);
            field.position = fieldImages.stream().findAny().map(im -> new Point2D.Double(im.getPositionX(), im.getPositionY())).orElse(new Point2D.Double());
            field.planes = planeImages.entrySet().stream().map(planeEntry -> CollectionUtils.newEntry(planeEntry.getKey(), ColumbusPlane.Builder.fromImages((List)planeEntry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            field.bounds = fieldImages.stream().findAny().map(im -> new Rectangle2D.Double(im.getPositionX(), im.getPositionY(), (double)im.getSizeX() * im.getResolutionX(), (double)im.getSizeY() * im.getResolutionY())).orElse(new Rectangle2D.Double());
            field.pixelBounds = fieldImages.stream().findAny().map(im -> new Rectangle2D.Double(im.getPositionX() / im.getResolutionX(), im.getPositionY() / im.getResolutionY(), im.getSizeX(), im.getSizeY())).orElse(new Rectangle2D.Double());
            return field;
        }
    }
}

