/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.IPlane;
import danyfel80.wells.data.columbus.ColumbusImage;
import danyfel80.wells.data.columbus.ColumbusTimepoint;
import danyfel80.wells.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ColumbusPlane
implements IPlane {
    private long id;
    private double positionZ;
    private Map<Long, ColumbusTimepoint> timepoints;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public double getPositionZ() {
        return this.positionZ;
    }

    public Map<Long, ColumbusTimepoint> getTimepoints() {
        return Collections.unmodifiableMap(this.timepoints);
    }

    public String toString() {
        return "Plane " + this.getId() + ": posZ=" + this.getPositionZ();
    }

    public static final class Builder {
        public static ColumbusPlane fromImages(List<ColumbusImage> planeImages) {
            Map<Long, List<ColumbusImage>> timepointImages = planeImages.stream().collect(Collectors.groupingBy(ColumbusImage::getTimepointId));
            ColumbusPlane plane = new ColumbusPlane();
            plane.id = planeImages.stream().findAny().map(im -> im.getPlaneId()).orElse(-1L);
            plane.positionZ = planeImages.stream().findAny().map(im -> im.getPositionZ()).orElse(0.0);
            plane.timepoints = timepointImages.entrySet().stream().map(timepointEntry -> CollectionUtils.newEntry(timepointEntry.getKey(), ColumbusTimepoint.Builder.fromImages((List)timepointEntry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return plane;
        }
    }
}

