/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.columbus;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.columbus.ColumbusField;
import danyfel80.wells.data.columbus.ColumbusImage;
import danyfel80.wells.data.columbus.ColumbusWellShape;
import danyfel80.wells.util.CollectionUtils;
import icy.util.XMLUtil;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumbusWell
implements IWell {
    private long id;
    private Point positionInPlate;
    private Map<Long, ColumbusField> fields;
    private ColumbusWellShape shape;

    private ColumbusWell() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Map<Long, ColumbusField> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    @Override
    public Point getPositionInPlate() {
        return this.positionInPlate;
    }

    @Override
    public ColumbusWellShape getShape() {
        return this.shape;
    }

    @Override
    public Rectangle2D getFieldBoundsOnWell(IField field) {
        return field.getBounds().getBounds2D();
    }

    public String toString() {
        String wellString = "Well " + Objects.toString(this.id) + " at (";
        wellString = wellString + (this.positionInPlate != null ? this.positionInPlate.x + ", " + this.positionInPlate.y : "null");
        wellString = wellString + ")";
        return wellString;
    }

    public static class Builder {
        public static ColumbusWell fromXMLElement(Element wellElement, Map<String, ColumbusImage> images) throws RuntimeException {
            long wellId = XMLUtil.getElementLongValue((Node)wellElement, (String)"id", (long)0L);
            int wellRow = XMLUtil.getElementIntValue((Node)wellElement, (String)"Row", (int)0);
            int wellCol = XMLUtil.getElementIntValue((Node)wellElement, (String)"Col", (int)0);
            Set wellImageIds = XMLUtil.getElements((Node)wellElement, (String)"Image").stream().map(imageElement -> XMLUtil.getAttributeValue((Element)imageElement, (String)"id", null)).collect(Collectors.toSet());
            ColumbusWell well = new ColumbusWell();
            well.id = wellId;
            well.positionInPlate = new Point(wellRow, wellCol);
            Map wellImages = wellImageIds.stream().map(imId -> (ColumbusImage)images.get(imId)).collect(Collectors.toMap(ColumbusImage::getId, Function.identity()));
            Map<Long, List<ColumbusImage>> fieldImages = wellImages.values().stream().collect(Collectors.groupingBy(ColumbusImage::getFieldId));
            Map<Long, ColumbusField> fields = fieldImages.entrySet().stream().map(fieldEntry -> CollectionUtils.newEntry(fieldEntry.getKey(), ColumbusField.Builder.fromImages((List)fieldEntry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            well.fields = fields;
            Rectangle2D wellRect = fields.values().stream().map(f -> f.getBounds()).reduce(new Rectangle2D.Double(), (acc, elem) -> {
                if (acc.isEmpty()) {
                    acc.setRect((Rectangle2D)elem);
                } else if (!elem.isEmpty()) {
                    acc.add((Rectangle2D)elem);
                }
                return acc;
            });
            well.shape = new ColumbusWellShape(wellRect);
            return well;
        }
    }
}

