/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.wells.data.opera;

import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Directory;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.opera.OperaCamera;
import danyfel80.wells.data.opera.OperaFilterCombination;
import danyfel80.wells.data.opera.OperaFilterSlider;
import danyfel80.wells.data.opera.OperaLightSource;
import danyfel80.wells.data.opera.OperaObjective;
import danyfel80.wells.data.opera.OperaStack;
import danyfel80.wells.data.opera.OperaSublayout;
import danyfel80.wells.data.opera.OperaWell;
import danyfel80.wells.data.opera.OperaWellShape;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.file.FileUtil;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OperaPlate
implements IPlate {
    private String folder;
    private String device;
    private String version;
    private String name;
    private Dimension dimension;
    private OperaWellShape shape;
    private String barcode;
    private Date startTime;
    private int operaMeasNumber;
    private Map<String, OperaLightSource> lightSources;
    private Map<String, OperaFilterSlider> filterSliders;
    private Map<String, OperaCamera> cameras;
    private Map<String, OperaObjective> objectives;
    private Map<String, OperaSublayout> sublayouts;
    private Map<String, OperaStack> stacks;
    private Map<String, String> lightSourceCombinations;
    private Map<String, OperaFilterCombination> filterCombinations;
    private Map<Long, OperaWell> wells;

    public String getFolder() {
        return this.folder;
    }

    @Override
    public String getId() {
        return this.barcode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.name;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public Map<Long, ? extends IWell> getWells() {
        return this.wells;
    }

    public String getDevice() {
        return this.device;
    }

    public String getVersion() {
        return this.version;
    }

    public OperaWellShape getShape() {
        return this.shape;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getOperaMeasNumber() {
        return this.operaMeasNumber;
    }

    public Map<String, OperaLightSource> getLightSources() {
        return this.lightSources;
    }

    public OperaLightSource getLightSource(String id) {
        return this.lightSources.get(id);
    }

    public Map<String, OperaFilterSlider> getFilterSliders() {
        return this.filterSliders;
    }

    public OperaFilterSlider getFilterSlide(String id) {
        return this.filterSliders.get(id);
    }

    public Map<String, OperaCamera> getCameras() {
        return this.cameras;
    }

    public OperaCamera getCamera(String id) {
        return this.cameras.get(id);
    }

    public Map<String, OperaObjective> getObjectives() {
        return this.objectives;
    }

    public OperaObjective getObjective(String id) {
        return this.objectives.get(id);
    }

    public Map<String, OperaSublayout> getSublayouts() {
        return this.sublayouts;
    }

    public OperaSublayout getSublayout(String id) {
        return this.sublayouts.get(id);
    }

    public Map<String, OperaStack> getStacks() {
        return this.stacks;
    }

    public OperaStack getStack(String id) {
        return this.stacks.get(id);
    }

    public Map<String, String> getLightSourceCombinations() {
        return this.lightSourceCombinations;
    }

    public Map<String, OperaFilterCombination> getFilterCombinations() {
        return this.filterCombinations;
    }

    public OperaFilterCombination getFilterCombination(String id) {
        return this.filterCombinations.get(id);
    }

    public String toString() {
        String plateID = this.getId();
        String plateType = this.getName();
        return plateID + " (" + plateType + ")";
    }

    public static class Builder {
        private String folder;
        private String[] flexFiles;
        private MessageProgressListener progressListener;
        private OperaPlate plate;

        public Builder(String folder, String[] flexFiles) {
            this.folder = folder;
            this.flexFiles = flexFiles;
            this.progressListener = null;
        }

        public Builder progressListener(MessageProgressListener progressListener) {
            this.progressListener = progressListener;
            return this;
        }

        public OperaPlate build() throws IOException {
            this.initializePlate();
            this.fillWellsData();
            return this.plate;
        }

        private void initializePlate() throws IOException {
            Document flexDocument;
            Metadata flexMetadata;
            this.notifyProgress(() -> 0.01, () -> "Initializing plate");
            this.plate = new OperaPlate();
            try {
                flexMetadata = TiffMetadataReader.readMetadata((File)new File(this.flexFiles[0]));
            }
            catch (TiffProcessingException e) {
                throw new IOException(e);
            }
            Directory flexDirectory = flexMetadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            String flexDescriptionXml = flexDirectory.getDescription(65200);
            try {
                flexDocument = XMLUtil.createDocument((String)flexDescriptionXml);
            }
            catch (SAXException e) {
                throw new IOException("Could not read xml correctly", e);
            }
            Element rootElement = XMLUtil.getElement((Node)flexDocument, (String)"Root");
            Element flexElement = XMLUtil.getElement((Node)rootElement, (String)"FLEX");
            this.plate.folder = this.folder;
            this.plate.device = XMLUtil.getAttributeValue((Element)flexElement, (String)"OperaDevice", null);
            this.plate.version = XMLUtil.getAttributeValue((Element)flexElement, (String)"version", null);
            this.plate.lightSources = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"LightSources")).map(sources -> XMLUtil.getElements((Node)sources, (String)"LightSource").stream().map(source -> OperaLightSource.Builder.fromXML(source)).collect(Collectors.toMap(OperaLightSource::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.filterSliders = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Filters")).map(filters -> XMLUtil.getElements((Node)filters, (String)"Slider").stream().map(sliderElement -> OperaFilterSlider.Builder.fromXML(sliderElement)).collect(Collectors.toMap(OperaFilterSlider::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.cameras = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Cameras")).map(cameras -> XMLUtil.getElements((Node)cameras, (String)"Camera").stream().map(cameraElement -> OperaCamera.Builder.fromXML(cameraElement)).collect(Collectors.toMap(OperaCamera::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.objectives = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Objectives")).map(objectives -> XMLUtil.getElements((Node)objectives, (String)"Objective").stream().map(objectiveElement -> OperaObjective.Buider.fromXML(objectiveElement)).collect(Collectors.toMap(OperaObjective::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.sublayouts = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Sublayouts")).map(sublayouts -> XMLUtil.getElements((Node)sublayouts, (String)"Sublayout").stream().map(sublayoutElement -> OperaSublayout.Builder.fromXML(sublayoutElement)).collect(Collectors.toMap(OperaSublayout::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.stacks = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Stacks")).map(stacks -> XMLUtil.getElements((Node)stacks, (String)"Stack").stream().map(stackElement -> OperaStack.Builder.fromXml(stackElement)).collect(Collectors.toMap(OperaStack::getId, Function.identity()))).orElse(Collections.emptyMap());
            this.plate.lightSourceCombinations = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"LightSourceCombinations")).map(combinations -> XMLUtil.getElements((Node)combinations, (String)"LightSourceCombination")).orElse(new ArrayList()).stream().collect(Collectors.toMap(combination -> XMLUtil.getAttributeValue((Element)combination, (String)"ID", null), combination -> XMLUtil.getAttributeValue((Element)XMLUtil.getElement((Node)combination, (String)"LightSourceRef"), (String)"ID", null)));
            this.plate.filterCombinations = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"FilterCombinations")).map(filterCombinations -> XMLUtil.getElements((Node)filterCombinations, (String)"FilterCombination")).orElse(new ArrayList()).stream().map(combinationElement -> OperaFilterCombination.Builder.fromXml(combinationElement)).collect(Collectors.toMap(OperaFilterCombination::getId, Function.identity()));
            Optional<Element> plateElement = Optional.ofNullable(XMLUtil.getElement((Node)flexElement, (String)"Plate"));
            this.plate.name = plateElement.map(elem -> XMLUtil.getElementValue((Node)elem, (String)"PlateName", null)).orElse(null);
            this.plate.dimension = plateElement.map(elem -> new Dimension(XMLUtil.getElementIntValue((Node)elem, (String)"YSize", (int)0), XMLUtil.getElementIntValue((Node)elem, (String)"XSize", (int)0))).orElse(new Dimension());
            this.plate.shape = plateElement.map(elem -> OperaWellShape.Builder.fromXml(XMLUtil.getElement((Node)elem, (String)"WellShape"))).orElse(OperaWellShape.defalutShape());
            this.plate.barcode = plateElement.map(elem -> XMLUtil.getElementValue((Node)elem, (String)"Barcode", null)).orElse(null);
            this.plate.startTime = plateElement.map(StreamUtils.wrapFunction(elem -> {
                String timeText = XMLUtil.getElementValue((Node)elem, (String)"StartTime", null);
                return timeText == null ? null : DatatypeConverter.parseDateTime((String)timeText).getTime();
            })).orElse(null);
            this.plate.operaMeasNumber = plateElement.map(elem -> XMLUtil.getElementIntValue((Node)elem, (String)"OperaMeasNo", (int)1)).orElse(1);
        }

        private void fillWellsData() {
            this.notifyProgress(() -> 0.1, () -> "Reading flex files");
            int flexFileCount = this.flexFiles.length;
            AtomicInteger processedFiles = new AtomicInteger();
            Map<Point, List<OperaWell>> wellsByCoordinate = ((Stream)Arrays.stream(this.flexFiles).parallel()).map(e -> {
                int fileNumber = processedFiles.incrementAndGet();
                this.notifyProgress(() -> 0.1 + 0.9 * (double)fileNumber / (double)flexFileCount, () -> "Reading flex files (" + fileNumber + "/" + flexFileCount + ")");
                return e;
            }).map(StreamUtils.wrapFunction(file -> this.readWell((String)file))).collect(Collectors.groupingBy(OperaWell::getPositionInPlate));
            this.plate.wells = wellsByCoordinate.entrySet().stream().map(coordinateWells -> OperaWell.joinWellsByField((List)coordinateWells.getValue(), this.plate.shape)).collect(Collectors.toMap(OperaWell::getId, Function.identity(), (v1, v2) -> {
                throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
            }, TreeMap::new));
        }

        private OperaWell readWell(String file) throws IOException, TiffProcessingException {
            Document flexDocument;
            Metadata flexMetadata = TiffMetadataReader.readMetadata((File)new File(file));
            Directory flexDirectory = flexMetadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            String flexDescriptionXml = flexDirectory.getDescription(65200);
            try {
                flexDocument = XMLUtil.createDocument((String)flexDescriptionXml);
            }
            catch (SAXException e) {
                throw new IOException("Could not read xml correctly", e);
            }
            Element rootElement = XMLUtil.getElement((Node)flexDocument, (String)"Root");
            Element flexElement = XMLUtil.getElement((Node)rootElement, (String)"FLEX");
            Element wellElement = XMLUtil.getElement((Node)flexElement, (String)"Well");
            return OperaWell.Builder.fromXml(wellElement, FileUtil.getFileName((String)file), this.plate.filterCombinations);
        }

        private void notifyProgress(DoubleSupplier progress, Supplier<String> message) {
            if (this.progressListener != null) {
                this.progressListener.notifyProgress(progress.getAsDouble(), message.get());
            }
        }
    }
}

